/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.services.monitor.persist.CountersHandler;
import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.engine.services.monitor.persist.FileManagerOrganizer;
import com.sap.engine.services.monitor.persist.IMonitorsHandler;
import com.sap.engine.services.monitor.persist.JARMComponentOverviewHandler;
import com.sap.engine.services.monitor.persist.JARMRequestOverviewHandler;
import com.sap.engine.services.monitor.persist.JARMRequestsSummaryHandler;
import com.sap.engine.services.monitor.persist.JARMUserOverviewHandler;
import com.sap.engine.services.monitor.persist.LogWriter;
import java.util.Vector;

public class MonitoringInfoWriter
extends Thread {
    private boolean initialized = false;
    private boolean enabled = false;
    CountersHandler[] handlers = new CountersHandler[0];
    private int sleepTime = 15000;
    static int REPORT_PERIOD_JARM = 15000;
    static int REPORT_PERIOD_J2EE = 60000;
    static int WEEKS_TO_KEEP = 12;
    public static long START_TIME = System.currentTimeMillis();
    public static long PERIOD = 0L;
    public static String CLUSTER_ELEMENT_ID = "ID000";
    FileManagerOrganizer fileOrganizer = null;
    static /* synthetic */ Class class$com$sap$util$monitor$jarm$OverviewMonitor;

    public MonitoringInfoWriter(String clusterID, int period, int j2ee_interval, int jarm_interval, int weeks_to_keep) {
        CLUSTER_ELEMENT_ID = clusterID;
        PERIOD = period * 60 * 1000;
        REPORT_PERIOD_JARM = jarm_interval * 1000;
        REPORT_PERIOD_J2EE = j2ee_interval * 1000;
        WEEKS_TO_KEEP = weeks_to_keep > 1 && weeks_to_keep < 53 ? weeks_to_keep : 12;
    }

    private synchronized void initHandlers() throws Exception {
        block12: {
            JARMUserOverviewHandler h5;
            JARMComponentOverviewHandler h4;
            JARMRequestOverviewHandler h3;
            JARMRequestsSummaryHandler h2;
            IMonitorsHandler h1;
            block11: {
                this.handlers = new CountersHandler[0];
                h1 = null;
                h2 = null;
                h3 = null;
                h4 = null;
                h5 = null;
                try {
                    (class$com$sap$util$monitor$jarm$OverviewMonitor == null ? (class$com$sap$util$monitor$jarm$OverviewMonitor = MonitoringInfoWriter.class$("com.sap.util.monitor.jarm.OverviewMonitor")) : class$com$sap$util$monitor$jarm$OverviewMonitor).getName();
                    h2 = new JARMRequestsSummaryHandler();
                    h3 = new JARMRequestOverviewHandler();
                    h4 = new JARMComponentOverviewHandler();
                    h5 = new JARMUserOverviewHandler();
                }
                catch (Throwable t) {
                    if (!LogWriter.isError()) break block11;
                    LogWriter.logError(t);
                }
            }
            try {
                h1 = new IMonitorsHandler();
            }
            catch (Throwable t) {
                LogWriter.logError(t);
            }
            Vector<CountersHandler> h = new Vector<CountersHandler>();
            if (h1 != null) {
                h.add(h1);
            }
            if (h2 != null) {
                h.add(h2);
            }
            if (h3 != null) {
                h.add(h3);
            }
            if (h4 != null) {
                h.add(h4);
            }
            if (h5 != null) {
                h.add(h5);
            }
            this.handlers = h.toArray(new CountersHandler[0]);
            try {
                this.fileOrganizer = new FileManagerOrganizer(CLUSTER_ELEMENT_ID);
                this.assignLocations();
            }
            catch (Throwable r) {
                this.handlers = new CountersHandler[0];
                if (!LogWriter.isError()) break block12;
                LogWriter.logError(r);
            }
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void run() {
        block16: {
            try {
                this.initHandlers();
                if (this.handlers.length > 0) {
                    this.enabled = true;
                    START_TIME = System.currentTimeMillis();
                    this.sleepTime = this.getBestSleepApproximation(REPORT_PERIOD_J2EE, REPORT_PERIOD_JARM);
                }
                while (this.enabled) {
                    MonitoringInfoWriter monitoringInfoWriter = this;
                    synchronized (monitoringInfoWriter) {
                        if (!this.enabled) {
                            return;
                        }
                        int i = 0;
                        while (i < this.handlers.length) {
                            block15: {
                                if (this.handlers[i] != null) {
                                    try {
                                        this.handlers[i].handleObject();
                                        this.handlers[i].reset();
                                    }
                                    catch (Throwable r) {
                                        if (!LogWriter.isError()) break block15;
                                        LogWriter.logError(r);
                                    }
                                }
                            }
                            ++i;
                        }
                        if (System.currentTimeMillis() - START_TIME > PERIOD) {
                            START_TIME = System.currentTimeMillis();
                            this.assignLocations();
                        }
                    }
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                this.enabled = false;
                if (!LogWriter.isError()) break block16;
                LogWriter.logError(t);
            }
        }
    }

    public void hold() throws Exception {
        MonitoringInfoWriter monitoringInfoWriter = this;
        synchronized (monitoringInfoWriter) {
            this.enabled = false;
            this.fileOrganizer.forceReset();
            this.handlers = new CountersHandler[0];
            this.fileOrganizer = null;
        }
    }

    private void assignLocations() throws Exception {
        this.fileOrganizer.forceReset();
        int i = 0;
        while (i < this.handlers.length) {
            if (this.handlers[i] != null) {
                FileManager fileManager = this.fileOrganizer.getFile(this.handlers[i].getPreferredLocationName());
                this.handlers[i].setFileLocation(fileManager);
            }
            ++i;
        }
    }

    private int getBestSleepApproximation(int i1, int i2) {
        if (i1 == i2) {
            return i1;
        }
        if (i1 < i2) {
            if (i2 - i1 <= i1) {
                return i2 - i1;
            }
            return i1;
        }
        if (i1 > i2) {
            if (i1 - i2 >= i2) {
                return i1 - i2;
            }
            return i2;
        }
        return 5000;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

