/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.services.monitor.persist.CountersHandler;
import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.engine.services.monitor.persist.MonitoringInfoWriter;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.OverviewMonitor;
import com.sap.util.monitor.jarm.UserOverview;

public class JARMUserOverviewHandler
implements CountersHandler {
    static String[] userOverviewHeaders = new String[]{"User Name ", "First request at ", "Last request at ", "Number of requests", "Duration for all requests (ms) ", "Average duration of request (ms) "};
    String[] userOverviewLine = new String[userOverviewHeaders.length];
    FileManager fileManager = null;
    long prevReport = System.currentTimeMillis();
    boolean allowReset = false;

    public void setFileLocation(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public FileManager getFileLocation() throws Exception {
        return this.fileManager;
    }

    public String getPreferredLocationName() {
        return "JARMUserOverview.tsv";
    }

    public String[] getReadyLine() throws Exception {
        return null;
    }

    public String[][] getReadyLines() throws Exception {
        return null;
    }

    public String[] getHeaderLine() throws Exception {
        return userOverviewHeaders;
    }

    public void reset() throws Exception {
        if (this.allowReset) {
            OverviewMonitor.resetMonitorData((int)3);
        }
    }

    public void handleObject() throws Exception {
        UserOverview[] userOverview_;
        long tt = System.currentTimeMillis() - this.prevReport;
        if (tt < (long)MonitoringInfoWriter.REPORT_PERIOD_JARM) {
            this.allowReset = false;
            return;
        }
        this.prevReport = System.currentTimeMillis();
        this.allowReset = true;
        if (this.fileManager.isFirstLine()) {
            this.fileManager.writeSingleLine(userOverviewHeaders);
        }
        if ((userOverview_ = OverviewMonitor.getTopUsers((int)3, (String)"*", (int)ConfMonitor.initMaxUserRet)) != null) {
            this.persist(userOverview_);
        }
        Object var3_2 = null;
    }

    private void persist(UserOverview[] userOverview) throws Exception {
        int i = 0;
        while (i < userOverview.length) {
            this.userOverviewLine[0] = userOverview[i].userName;
            this.userOverviewLine[1] = Long.toString(userOverview[i].userFirstTS);
            this.userOverviewLine[2] = Long.toString(userOverview[i].userLastTS);
            this.userOverviewLine[3] = Long.toString(userOverview[i].userAccNr);
            this.userOverviewLine[4] = Long.toString(userOverview[i].userAccTime);
            this.userOverviewLine[5] = Long.toString(userOverview[i].userAvgTime);
            this.fileManager.writeSingleLine(this.userOverviewLine);
            ++i;
        }
    }
}

