/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.services.monitor.persist.CountersHandler;
import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.util.monitor.jarm.OverviewMonitor;
import com.sap.util.monitor.jarm.RequestSummary;

public class JARMRequestsSummaryHandler
implements CountersHandler {
    static String[] requestsSummaryHeader = new String[]{"Number of Requests ", "Time for all Requests (milliseconds)", "Average Execution Time of a Request (milliseconds)", "Requests per Second ", "Number of Calls with Outbound Data ", "Accumulated Amount of Outbound Data (bytes)", "Average Amount of Outbound Data per Request (bytes)", "Correct closed components", "Not closed components", "Force closed components", "Number of Component Calls for all Requests", "Average Number of Component Calls per Request"};
    String[] requestsSummaryLine = new String[requestsSummaryHeader.length];
    FileManager fileManager;
    long prevReport = System.currentTimeMillis();
    boolean allowReset = false;

    public void setFileLocation(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public FileManager getFileLocation() {
        return this.fileManager;
    }

    public String getPreferredLocationName() {
        return "JARMRequestsSummary.tsv";
    }

    public String[] getReadyLine() throws Exception {
        return null;
    }

    public String[][] getReadyLines() throws Exception {
        return null;
    }

    public String[] getHeaderLine() throws Exception {
        return requestsSummaryHeader;
    }

    public void reset() throws Exception {
    }

    public void handleObject() throws Exception {
        RequestSummary requestSummary;
        if (this.fileManager.isFirstLine()) {
            this.fileManager.writeSingleLine(requestsSummaryHeader);
        }
        if ((requestSummary = OverviewMonitor.getSummaryOfRequests()) != null) {
            this.requestsSummaryLine[0] = Long.toString(requestSummary.reqAccNr);
            this.requestsSummaryLine[1] = Long.toString(requestSummary.reqAccTime);
            this.requestsSummaryLine[2] = Long.toString(requestSummary.reqAvgTime);
            this.requestsSummaryLine[3] = Long.toString(requestSummary.reqPerSec);
            this.requestsSummaryLine[4] = Long.toString(requestSummary.reqAccOutDataFilled);
            this.requestsSummaryLine[5] = Long.toString(requestSummary.reqAccOutData);
            this.requestsSummaryLine[6] = Long.toString(requestSummary.reqAvgOutData);
            this.requestsSummaryLine[7] = Long.toString(requestSummary.reqAccStatusOk);
            this.requestsSummaryLine[8] = Long.toString(requestSummary.reqAccStatusCompNotClosed);
            this.requestsSummaryLine[9] = Long.toString(requestSummary.reqAccStatusEndForced);
            this.requestsSummaryLine[10] = Long.toString(requestSummary.reqAccComp);
            this.requestsSummaryLine[11] = Long.toString(requestSummary.reqAvgComp);
            this.fileManager.writeSingleLine(this.requestsSummaryLine);
        }
        Object var1_1 = null;
    }
}

