/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.services.monitor.persist.CountersHandler;
import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.engine.services.monitor.persist.MonitoringInfoWriter;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.OverviewMonitor;
import com.sap.util.monitor.jarm.RequestOverview;

public class JARMRequestOverviewHandler
implements CountersHandler {
    static String[] requestOverviewHeaders = new String[]{"User ID ", "Request name ", "Status of the request ", "Beginning of the request ", "Duration (ms) ", "Outbound data (bytes) ", "Nr components entered  ", "Slowest component time (ms)", "Biggest component outbound data (bytes)"};
    String[] requestOverviewLine = new String[requestOverviewHeaders.length];
    FileManager fileManager = null;
    long prevReport = System.currentTimeMillis();
    boolean allowReset = false;

    public void setFileLocation(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public FileManager getFileLocation() throws Exception {
        return this.fileManager;
    }

    public String getPreferredLocationName() {
        return "JARMRequestOverview.tsv";
    }

    public String[] getReadyLine() throws Exception {
        return null;
    }

    public String[][] getReadyLines() throws Exception {
        return null;
    }

    public String[] getHeaderLine() throws Exception {
        return requestOverviewHeaders;
    }

    public void reset() throws Exception {
        if (this.allowReset) {
            OverviewMonitor.resetMonitorData((int)1);
        }
    }

    public void handleObject() throws Exception {
        RequestOverview[] requestOverview_;
        long tt = System.currentTimeMillis() - this.prevReport;
        if (tt < (long)MonitoringInfoWriter.REPORT_PERIOD_JARM) {
            this.allowReset = false;
            return;
        }
        this.prevReport = System.currentTimeMillis();
        this.allowReset = true;
        if (this.fileManager.isFirstLine()) {
            this.fileManager.writeSingleLine(requestOverviewHeaders);
        }
        if ((requestOverview_ = OverviewMonitor.getTopRequests((int)1, (int)0, (String)"*", (int)ConfMonitor.initNrTops)) != null) {
            this.persist(requestOverview_);
        }
        Object var3_2 = null;
    }

    private void persist(RequestOverview[] requestOverview) throws Exception {
        int i = 0;
        while (i < requestOverview.length) {
            this.requestOverviewLine[0] = requestOverview[i].userName;
            this.requestOverviewLine[1] = requestOverview[i].reqName;
            this.requestOverviewLine[2] = Integer.toString(requestOverview[i].reqStatus);
            this.requestOverviewLine[3] = Long.toString(requestOverview[i].reqTS);
            this.requestOverviewLine[4] = Long.toString(requestOverview[i].reqTime);
            this.requestOverviewLine[5] = Integer.toString(requestOverview[i].reqOutData);
            this.requestOverviewLine[6] = Integer.toString(requestOverview[i].reqComp);
            this.requestOverviewLine[7] = Long.toString(requestOverview[i].compNetTime);
            this.requestOverviewLine[8] = Long.toString(requestOverview[i].compOutData);
            this.fileManager.writeSingleLine(this.requestOverviewLine);
            ++i;
        }
    }
}

