/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.services.monitor.persist.CountersHandler;
import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.engine.services.monitor.persist.MonitoringInfoWriter;
import com.sap.util.monitor.jarm.ComponentOverview;
import com.sap.util.monitor.jarm.OverviewMonitor;

public class JARMComponentOverviewHandler
implements CountersHandler {
    static String[] componentOverviewHeaders = new String[]{"Component Name", "No. of Calls ", "Gross time filled", "Total Gross Time (ms)", "Avg Gross Time (ms) ", "Net time filled", "Total Net Time (ms)", "Avg Net Time (ms)", "Data filled", "Amount of Data (bytes)", "Avg Amount of Data (bytes)"};
    String[] componentOverviewLine = new String[componentOverviewHeaders.length];
    FileManager fileManager;
    long prevReport = System.currentTimeMillis();
    boolean allowReset = false;

    public void setFileLocation(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public String getPreferredLocationName() {
        return "JARMComponentOverview.tsv";
    }

    public FileManager getFileLocation() {
        return this.fileManager;
    }

    public String[] getReadyLine() throws Exception {
        return null;
    }

    public String[][] getReadyLines() throws Exception {
        return null;
    }

    public String[] getHeaderLine() throws Exception {
        return componentOverviewHeaders;
    }

    public void reset() throws Exception {
        if (this.allowReset) {
            OverviewMonitor.resetMonitorData((int)2);
        }
    }

    public void handleObject() throws Exception {
        ComponentOverview[] componentOverview;
        long tt = System.currentTimeMillis() - this.prevReport;
        if (tt < (long)MonitoringInfoWriter.REPORT_PERIOD_JARM) {
            this.allowReset = false;
            return;
        }
        this.prevReport = System.currentTimeMillis();
        this.allowReset = true;
        if (this.fileManager.isFirstLine()) {
            this.fileManager.writeSingleLine(componentOverviewHeaders);
        }
        if ((componentOverview = OverviewMonitor.getComponents((String)"*", (int)2000)) != null) {
            int i = 0;
            while (i < componentOverview.length) {
                this.componentOverviewLine[0] = componentOverview[i].compName;
                this.componentOverviewLine[1] = Long.toString(componentOverview[i].compAccNr);
                this.componentOverviewLine[2] = Long.toString(componentOverview[i].compAccGrossTimeFilled);
                this.componentOverviewLine[3] = Long.toString(componentOverview[i].compAccGrossTime);
                this.componentOverviewLine[4] = Long.toString(componentOverview[i].compAvgGrossTime);
                this.componentOverviewLine[5] = Long.toString(componentOverview[i].compAccNetTimeFilled);
                this.componentOverviewLine[6] = Long.toString(componentOverview[i].compAccNetTime);
                this.componentOverviewLine[7] = Long.toString(componentOverview[i].compAvgNetTime);
                this.componentOverviewLine[8] = Long.toString(componentOverview[i].compAccOutDataFilled);
                this.componentOverviewLine[9] = Long.toString(componentOverview[i].compAccOutData);
                this.componentOverviewLine[10] = Long.toString(componentOverview[i].compAvgOutData);
                this.fileManager.writeSingleLine(this.componentOverviewLine);
                ++i;
            }
        }
        Object var3_2 = null;
    }
}

