/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.persist.CountersHandler;
import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.engine.services.monitor.persist.LogWriter;

public class IMonitorsHandler
implements CountersHandler {
    FileManager fileManager;
    String[] headers = new String[0];
    String[] values = new String[0];
    boolean HEADERCHANGED = false;

    public void setFileLocation(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public FileManager getFileLocation() {
        return this.fileManager;
    }

    public String getPreferredLocationName() {
        return "J2EEIMonitors.tsv";
    }

    public String[] getReadyLine() throws Exception {
        return this.values;
    }

    public String[][] getReadyLines() throws Exception {
        return null;
    }

    public String[] getHeaderLine() throws Exception {
        return this.headers;
    }

    public void reset() throws Exception {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = "n/a";
            ++i;
        }
    }

    public void handleObject() throws Exception {
        MappedTree m_tree = null;
        try {
            m_tree = MonitorServiceRuntime.getMappedTree();
        }
        catch (Throwable t) {
            LogWriter.logError("Monitoring tree is still not initialized.");
        }
        if (m_tree == null) {
            return;
        }
        MappingTreeNode root = m_tree.getRootNode();
        if (root == null) {
            return;
        }
        this.HEADERCHANGED = false;
        this.getTree(root);
        if (this.fileManager.isFirstLine()) {
            this.fileManager.writeSingleLine(this.headers);
        } else if (this.HEADERCHANGED) {
            this.fileManager.writeSingleLine(new String[]{""});
            this.fileManager.writeSingleLine(this.headers);
        }
        this.fileManager.writeSingleLine(this.values);
    }

    private void getTree(MappingTreeNode node) {
        if (node.getChildCount() == 0) {
            IMonitorNode n = node.getMonitorObject();
            this.prepareIMonitorsForWrite(node.getMappingPath(), n.getMostSignificantValueAsString());
        } else {
            int i = 0;
            while (i < node.getChildCount()) {
                this.getTree((MappingTreeNode)node.getChildAt(i));
                ++i;
            }
        }
    }

    private synchronized void prepareIMonitorsForWrite(String treePath, String counterValue) {
        boolean found = false;
        int i = 0;
        while (i < this.headers.length) {
            if (this.headers[i].equals(treePath)) {
                this.values[i] = counterValue.equals("No value has been reported yet") ? "n/a" : counterValue;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            String[] extheaders = new String[this.headers.length + 1];
            System.arraycopy(this.headers, 0, extheaders, 0, this.headers.length);
            extheaders[this.headers.length] = treePath;
            this.headers = extheaders;
            extheaders = null;
            String[] extvalues = new String[this.values.length + 1];
            System.arraycopy(this.values, 0, extvalues, 0, this.values.length);
            extvalues[this.values.length] = counterValue.equals("No value has been reported yet") ? "n/a" : counterValue;
            this.values = extvalues;
            extvalues = null;
            this.HEADERCHANGED = true;
        }
    }
}

