/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.engine.services.monitor.persist.FileManagerImpl;
import com.sap.engine.services.monitor.persist.LogWriter;
import com.sap.engine.services.monitor.persist.MonitoringInfoWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileManagerOrganizer {
    File currentFolder;
    Vector fileManagers = new Vector();
    String clusterNodeIDDirName;
    static String REPORTS_LOCATION = ".." + File.separator + "MonitoringData";
    static SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyMMdd-HHmmss");
    static String CLUSTER_ELEMENT_ID = "ID_000";

    public FileManagerOrganizer(String clusterID) throws Exception {
        CLUSTER_ELEMENT_ID = clusterID;
        this.prepareFolders();
    }

    private void prepareFolders() throws Exception {
        File pathDir = new File(REPORTS_LOCATION);
        if (!pathDir.exists()) {
            pathDir.mkdir();
        }
        this.clusterNodeIDDirName = REPORTS_LOCATION + File.separator + CLUSTER_ELEMENT_ID;
        File clusterNodeIDDir = new File(this.clusterNodeIDDirName);
        if (!clusterNodeIDDir.exists()) {
            clusterNodeIDDir.mkdir();
        } else {
            File[] available = clusterNodeIDDir.listFiles();
            if (available.length > 0) {
                int m = 0;
                while (m < available.length) {
                    block8: {
                        if (available[m].isDirectory()) {
                            try {
                                this.zipSourceData(available[m].getAbsolutePath());
                            }
                            catch (Throwable e) {
                                if (!LogWriter.isError()) break block8;
                                LogWriter.logError(e);
                            }
                        }
                    }
                    ++m;
                }
            }
        }
    }

    public void forceReset() throws Exception {
        String oldFolder = null;
        if (this.currentFolder != null) {
            oldFolder = this.currentFolder.getAbsolutePath();
            this.currentFolder = null;
        }
        FileManagerOrganizer fileManagerOrganizer = this;
        synchronized (fileManagerOrganizer) {
            int i = 0;
            while (i < this.fileManagers.size()) {
                ((FileManager)this.fileManagers.elementAt(i)).close();
                ++i;
            }
            this.fileManagers = new Vector();
        }
        if (oldFolder != null) {
            this.zipSourceData(oldFolder);
        }
    }

    public FileManager getFile(String preferredName) throws Exception {
        if (this.currentFolder == null) {
            this.fileManagers = new Vector();
            this.currentFolder = new File(REPORTS_LOCATION + File.separator + CLUSTER_ELEMENT_ID + File.separator + FILE_DATE_FORMAT.format(new Date(System.currentTimeMillis())));
        }
        if (!this.currentFolder.exists()) {
            this.currentFolder.mkdir();
        }
        FileManagerImpl fileManager = new FileManagerImpl(this.currentFolder.getAbsolutePath() + File.separator + preferredName);
        this.fileManagers.add(fileManager);
        return fileManager;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private void zip(String oldFolder, int week) throws Exception {
        block23: {
            String tempZipLoc;
            File f;
            File[] oldfiles = new File(oldFolder).listFiles();
            String[] filenames = new String[oldfiles.length];
            int m = 0;
            while (m < oldfiles.length) {
                filenames[m] = oldfiles[m].getAbsolutePath();
                ++m;
            }
            String weekFolderLoc = REPORTS_LOCATION + File.separator + CLUSTER_ELEMENT_ID + "_kw" + week;
            File weekFolder = new File(weekFolderLoc);
            if (!weekFolder.exists()) {
                weekFolder.mkdir();
            }
            if (!(f = new File(tempZipLoc = weekFolderLoc + File.separator + new File(oldFolder).getName() + ".zip")).exists()) {
                f.createNewFile();
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempZipLoc));
            int i = 0;
            while (i < filenames.length) {
                block21: {
                    File parent_;
                    File old_;
                    int len;
                    FileInputStream in = null;
                    byte[] buf = new byte[100000];
                    in = new FileInputStream(filenames[i]);
                    int x = filenames[i].lastIndexOf(File.separator);
                    String zippath = filenames[i].substring(0, x);
                    x = zippath.lastIndexOf(File.separator);
                    zippath = zippath.substring(0, x);
                    x = zippath.lastIndexOf(File.separator);
                    zippath = filenames[i].substring(x);
                    out.putNextEntry(new ZipEntry(zippath));
                    while ((len = in.read(buf)) > 0) {
                        void var16_18;
                        out.write(buf, 0, (int)var16_18);
                    }
                    Object var18_19 = null;
                    try {
                        out.closeEntry();
                        in.close();
                        old_ = new File(filenames[i]);
                        parent_ = old_.getParentFile();
                        old_.delete();
                        if (i == filenames.length - 1) {
                            parent_.delete();
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        if (LogWriter.isError()) {
                            LogWriter.logError(e2);
                        }
                        break block21;
                    }
                    {
                        catch (Exception e) {
                            if (LogWriter.isError()) {
                                LogWriter.logError(e);
                            }
                            var18_19 = null;
                            try {
                                out.closeEntry();
                                in.close();
                                old_ = new File(filenames[i]);
                                parent_ = old_.getParentFile();
                                old_.delete();
                                if (i == filenames.length - 1) {
                                    parent_.delete();
                                }
                                break block21;
                            }
                            catch (Exception e2) {
                                if (LogWriter.isError()) {
                                    LogWriter.logError(e2);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        block22: {
                            var18_19 = null;
                            try {
                                out.closeEntry();
                                in.close();
                                old_ = new File(filenames[i]);
                                parent_ = old_.getParentFile();
                                old_.delete();
                                if (i == filenames.length - 1) {
                                    parent_.delete();
                                }
                            }
                            catch (Exception e2) {
                                if (!LogWriter.isError()) break block22;
                                LogWriter.logError(e2);
                            }
                        }
                        throw throwable;
                    }
                }
                ++i;
            }
            try {
                ((FilterOutputStream)out).flush();
                out.close();
            }
            catch (Throwable e) {
                if (!LogWriter.isError()) break block23;
                LogWriter.logError(e);
            }
        }
    }

    private void deleteOldCalendarWeeks(int week) {
        File f = new File(REPORTS_LOCATION);
        if (f.exists()) {
            String[] oldnames = f.list();
            int i = 0;
            while (i < oldnames.length) {
                block7: {
                    try {
                        File old;
                        int oldweek;
                        int left = oldnames[i].indexOf("_kw");
                        int right = -1;
                        if (left != -1) {
                            left += 3;
                            right = oldnames[i].length();
                        }
                        if (left != -1 && right != -1 && left < right && ((oldweek = Integer.parseInt(oldnames[i].substring(left, right))) <= week && week - oldweek > MonitoringInfoWriter.WEEKS_TO_KEEP || oldweek > week && 52 - oldweek + week > MonitoringInfoWriter.WEEKS_TO_KEEP) && (old = new File(REPORTS_LOCATION + File.separator + oldnames[i])).isDirectory()) {
                            File[] toDelete = old.listFiles();
                            int v = 0;
                            while (v < toDelete.length) {
                                toDelete[v].delete();
                                ++v;
                            }
                            old.delete();
                        }
                    }
                    catch (Exception e) {
                        if (!LogWriter.isError()) break block7;
                        LogWriter.logError(e);
                    }
                }
                ++i;
            }
        }
    }

    private void zipSourceData(String oldFolder) throws Exception {
        int week = Calendar.getInstance().get(3);
        this.zip(oldFolder, week);
        this.deleteOldCalendarWeeks(week);
    }
}

