/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.persist;

import com.sap.engine.services.monitor.persist.FileManager;
import com.sap.engine.services.monitor.persist.LogWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileManagerImpl
implements FileManager {
    public String filename;
    BufferedOutputStream out;
    File file;
    private boolean isFirst = true;

    public FileManagerImpl(String filename_) throws IOException {
        this.filename = filename_;
        this.newFile();
    }

    public boolean isFirstLine() {
        return this.isFirst;
    }

    public void writeSingleLine(String[] line) throws IOException {
        long start = System.currentTimeMillis();
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            if (this.isFirst) {
                this.write("timestamp\t");
                this.isFirst = false;
            } else {
                this.write(System.currentTimeMillis() + "\t");
            }
            int i = 0;
            while (i < line.length) {
                this.write(line[i] + "\t");
                ++i;
            }
            this.write("\n");
            this.out.flush();
        }
    }

    private void write(String counter) throws IOException {
        this.out.write(counter.getBytes());
    }

    public void close() {
        FileManagerImpl fileManagerImpl = this;
        synchronized (fileManagerImpl) {
            block8: {
                block7: {
                    try {
                        this.out.flush();
                    }
                    catch (Throwable r) {
                        if (!LogWriter.isError()) break block7;
                        LogWriter.logError(r);
                    }
                }
                try {
                    this.out.close();
                }
                catch (Throwable t) {
                    if (!LogWriter.isError()) break block8;
                    LogWriter.logError(t);
                }
            }
            this.out = null;
        }
    }

    private void newFile() throws IOException {
        this.file = new File(this.filename);
        this.out = new BufferedOutputStream(new FileOutputStream(this.file), 8192);
        this.isFirst = true;
    }
}

