/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IPropertiesMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.IVersionMonitor;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.VersionMonitorMBean;
import com.sap.jmx.monitoring.api.VersionInfo;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;

public class VersionMonitor
extends Monitor
implements IVersionMonitor,
VersionMonitorMBean {
    public VersionMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IPropertiesMonitorNode versionMonitorNode = Monitor.monitorObjectFactory.createVersionMonitorNode(installInfo.getName(), installInfo.getParentNode());
        this.monitorNode = versionMonitorNode;
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the VersionMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        try {
            this.setVersionInfo((VersionInfo)this.getMBeanResult());
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        try {
            this.setVersionInfo((VersionInfo)this.getMBeanResult());
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup.");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("Version")) {
            this.setVersionInfo((VersionInfo)notification.getNewValue());
        }
    }

    public String[][] getVersionInfo() {
        return ((IPropertiesMonitorNode)this.monitorNode).getProperties();
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        String[][] versionInfoArray = versionInfo.getInfo();
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New values for the version info monitor node with path [" + this.getPath() + "] :");
            if (versionInfoArray != null) {
                int i = 0;
                while (i < versionInfoArray.length) {
                    String row = "";
                    if (versionInfoArray[i] != null) {
                        int j = 0;
                        while (j < versionInfoArray[i].length) {
                            row = row + " [" + versionInfoArray[i][j] + "] ";
                            ++j;
                        }
                        Monitor.location.infoT(row);
                    }
                    ++i;
                }
            } else {
                Monitor.location.infoT("New values for the version info monitor node with path [" + this.getPath() + "] :null");
            }
        }
        ((IPropertiesMonitorNode)this.monitorNode).setProperties(versionInfoArray);
    }
}

