/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IVariableStateMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.StateMonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.IVariableStateMonitor;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.VariableStateMonitorMBean;
import com.sap.jmx.monitoring.api.StateValue;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;

public class VariableStateMonitor
extends Monitor
implements IVariableStateMonitor,
VariableStateMonitorMBean {
    public VariableStateMonitor(StateMonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void configureMonitorNode(IMonitorNode monitorNode, MonitorInstallationInfo installInfo) throws com.sap.engine.library.monitor.MonitorException {
        StateConfigurationGroup configGroup = (StateConfigurationGroup)installInfo.getConfigurationGroup();
        ((IVariableStateMonitorNode)monitorNode).setAlertMode(configGroup.getAlertMode());
        super.configureMonitorNode(monitorNode, installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.monitorNode = Monitor.monitorObjectFactory.createVariableStateMonitorNode(installInfo.getName(), installInfo.getParentNode(), ((StateMonitorInstallationInfo)installInfo).isExplicitGreen());
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the VariableStateMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        try {
            StateValue value = (StateValue)this.getMBeanResult();
            this.setState(value.getDefaultText(), value.getAlertColor());
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        try {
            StateValue value = (StateValue)this.getMBeanResult();
            this.setState(value.getDefaultText(), value.getAlertColor());
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup.");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        StateValue value = (StateValue)notification.getNewValue();
        this.setState(value.getDefaultText(), value.getAlertColor());
    }

    public void setState(String state, int color) {
        try {
            if (Monitor.location.beInfo()) {
                Monitor.location.infoT("New values for the variable state monitor node with path [" + this.getPath() + "] are: state [" + state + "] and color :[" + color + "]");
            }
            ((IVariableStateMonitorNode)this.monitorNode).setState(state, color);
        }
        catch (com.sap.engine.library.monitor.MonitorException e) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in states.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)e)));
        }
    }

    public String getState() {
        return ((IVariableStateMonitorNode)this.monitorNode).getState();
    }
}

