/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IObjectMonitorNode;
import com.sap.engine.library.monitor.ISummaryMonitorNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.common.Parameter;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.install.InstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstaller;
import com.sap.engine.services.monitor.install.StateMonitorInstallationInfo;
import com.sap.engine.services.monitor.install.TableMonitorInstallationInfo;
import com.sap.engine.services.monitor.install.TemplateInstallationInfo;
import com.sap.engine.services.monitor.install.TemplateTreeNode;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.TemplateAttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.TimerFilter;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class Template
implements NotificationListener {
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_DAY = 86400000;
    private static final String DYNAMIC_DATA_SYMBOL = "%";
    private Object dynamicData = null;
    private String templateName = null;
    private TemplateTreeNode templateTree = null;
    private IMonitorNode parentNode = null;
    private TemplateInstallationInfo templateInstallationInfo = null;
    private Hashtable groups = null;
    private String applicationName = null;
    private MBeanServer mbs = null;
    private boolean oneDimensionalData = false;
    private String[] removalPath = null;
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.common.Template");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Date;

    public Template(String templateName, TemplateTreeNode templateTree, IMonitorNode parentNode, TemplateInstallationInfo templateInstallationInfo, Hashtable groups, String applicationName) {
        this.templateName = templateName;
        this.templateTree = templateTree;
        this.parentNode = parentNode;
        this.templateInstallationInfo = templateInstallationInfo;
        this.groups = groups;
        this.applicationName = applicationName;
        this.mbs = MonitorServiceRuntime.getMBeanServer();
    }

    public void start() {
        byte dataCollectionType = this.templateInstallationInfo.getDataCollectionType();
        switch (dataCollectionType) {
            case 1: {
                this.registerForTimerEvents();
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                String generatingResourceName = this.templateInstallationInfo.getGeneratingResourceName();
                String generatingResourceType = this.templateInstallationInfo.getGeneratingResourceType();
                ObjectName generatingResourceObjectName = this.buildObjectName(generatingResourceName, generatingResourceType);
                try {
                    this.mbs.addNotificationListener(generatingResourceObjectName, this, null, null);
                }
                catch (JMException ex) {
                    this.location.errorT("Cannot add notification listener for resource with object name: " + generatingResourceObjectName);
                    this.location.errorT(Util.getStackTraceAsString(ex));
                }
                try {
                    this.pollDynamicData();
                    this.processDynamicData(this.dynamicData);
                }
                catch (Exception e) {
                    this.location.infoT("Data could not be collected for resource with object name [" + generatingResourceName + "] at startup.");
                }
                break;
            }
        }
    }

    public void stop() {
        this.removeMonitors(this.dynamicData);
    }

    public void removeNotificationForTemplate() {
        if (this.templateInstallationInfo.getDataCollectionType() == 2) {
            String generatingResourceName = this.templateInstallationInfo.getGeneratingResourceName();
            String generatingResourceType = this.templateInstallationInfo.getGeneratingResourceType();
            ObjectName generatingResourceObjectName = this.buildObjectName(generatingResourceName, generatingResourceType);
            try {
                this.mbs.removeNotificationListener(generatingResourceObjectName, this, null, null);
            }
            catch (JMException ex) {
                this.location.errorT("Cannot remove notification listener for resource with object name: " + generatingResourceObjectName);
                this.location.infoT(Util.getStackTraceAsString(ex));
            }
        }
    }

    protected void registerForTimerEvents() {
        ObjectName timerObjectName = null;
        Date date = null;
        Integer notificationId = null;
        try {
            timerObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
        }
        catch (MalformedObjectNameException ex) {
            // empty catch block
        }
        date = new Date(System.currentTimeMillis() + 5000L);
        try {
            Period period = this.templateInstallationInfo.getPeriod();
            int periodUnit = period.getUnit();
            int periodValue = period.getValue();
            notificationId = (Integer)this.mbs.invoke(timerObjectName, "addNotification", new Object[]{"timer.notification", "template trigger", null, date, new Long(this.getGranularityPeriod(periodUnit, periodValue))}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = Template.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = Template.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = Template.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$util$Date == null ? (class$java$util$Date = Template.class$("java.util.Date")) : class$java$util$Date).getName(), "long"});
        }
        catch (JMException ex) {
            this.location.errorT(Util.getStackTraceAsString(ex));
        }
        catch (Exception e) {
            this.location.errorT(Util.getStackTraceAsString(e));
        }
        TimerFilter timerFilter = new TimerFilter(notificationId);
        try {
            this.mbs.addNotificationListener(timerObjectName, this, (NotificationFilter)timerFilter, (Object)"TimerNotification");
        }
        catch (JMException ex) {
            this.location.errorT(Util.getStackTraceAsString(ex));
        }
    }

    public void unregisterForTimerEvents() {
        if (this.templateInstallationInfo.getDataCollectionType() == 1) {
            ObjectName timerObjectName = null;
            try {
                timerObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
            }
            catch (MalformedObjectNameException ex) {
                this.location.errorT(ex.getMessage());
            }
            try {
                this.mbs.removeNotificationListener(timerObjectName, this);
                this.location.infoT("Remove notification listener for app :" + this.applicationName + " template name:" + this.templateName);
            }
            catch (JMException ex) {
                this.location.errorT("Cannot remove notification listener for template " + this.templateName);
                this.location.errorT(Util.getStackTraceAsString(ex));
            }
        }
    }

    public void dynamicallySuppliedData(Object returnValue) {
        if (returnValue == null) {
            this.location.infoT("Dynamic data for template " + this.templateName + " is null");
        }
        this.processDynamicData(returnValue);
    }

    protected void processDynamicData(Object returnValue) {
        if (returnValue == null) {
            return;
        }
        if (returnValue instanceof String[][]) {
            this.oneDimensionalData = false;
            String[][] returnValueArray = (String[][])returnValue;
            Object dynamicDataArray = null;
            dynamicDataArray = this.dynamicData == null ? new String[][]{} : (String[][])this.dynamicData;
            if (returnValueArray == null) {
                returnValueArray = new String[][]{};
            }
            if (this.location.beInfo()) {
                this.location.infoT("********* dynamic data for template [" + this.templateName + "]********");
                int i = 0;
                while (i < returnValueArray.length) {
                    int size = 0;
                    if (returnValueArray[0] != null) {
                        size = returnValueArray[0].length;
                    }
                    String row = "";
                    int j = 0;
                    while (j < size) {
                        row = row + "  -  " + returnValueArray[i][j];
                        ++j;
                    }
                    this.location.infoT(row);
                    ++i;
                }
                this.location.infoT("*****************************************************");
            }
            Vector unchangedData = this.getIntersection(returnValueArray, dynamicDataArray);
            this.removeMonitors(dynamicDataArray);
            this.installMonitors(returnValueArray);
            this.dynamicData = new String[returnValueArray.length][];
            int t = unchangedData.size();
            int i = 0;
            while (i < t) {
                ((String[][])this.dynamicData)[i] = (String[])unchangedData.elementAt(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < returnValueArray.length) {
                if (returnValueArray[i2] != null) {
                    ((String[][])this.dynamicData)[t] = returnValueArray[i2];
                    ++t;
                }
                ++i2;
            }
        } else {
            int i;
            String row;
            if (returnValue instanceof int[]) {
                int[] intArray = (int[])returnValue;
                returnValue = new String[intArray.length];
                int i3 = 0;
                while (i3 < intArray.length) {
                    returnValue[i3] = String.valueOf(intArray[i3]);
                    ++i3;
                }
                if (this.location.beInfo() && returnValue != null) {
                    this.location.infoT("********* dynamic data for template [" + this.templateName + "]********");
                    row = "";
                    i = 0;
                    while (i < returnValue.length) {
                        row = "  -  " + returnValue[i];
                        ++i;
                    }
                    this.location.infoT(row);
                    this.location.infoT("*****************************************************");
                }
            }
            if (returnValue instanceof String[]) {
                this.oneDimensionalData = true;
                String[] returnValueArray = returnValue;
                String[] dynamicDataArray = null;
                dynamicDataArray = this.dynamicData == null ? new String[]{} : (String[])this.dynamicData;
                if (returnValueArray == null) {
                    returnValueArray = new String[]{};
                }
                if (this.location.beInfo()) {
                    this.location.infoT("********* dynamic data for template [" + this.templateName + "]********");
                    row = "";
                    i = 0;
                    while (i < returnValueArray.length) {
                        row = "  -  " + returnValueArray[i];
                        ++i;
                    }
                    this.location.infoT(row);
                    this.location.infoT("*****************************************************");
                }
                Vector unchangedData = this.getIntersection(returnValueArray, dynamicDataArray);
                this.removeMonitors(dynamicDataArray);
                this.installMonitors(returnValueArray);
                this.dynamicData = new String[returnValueArray.length];
                int t = unchangedData.size();
                int i4 = 0;
                while (i4 < t) {
                    ((String[])this.dynamicData)[i4] = (String)unchangedData.elementAt(i4);
                    ++i4;
                }
                int i5 = 0;
                while (i5 < returnValueArray.length) {
                    if (returnValueArray[i5] != null) {
                        ((String[])this.dynamicData)[t] = returnValueArray[i5];
                        ++t;
                    }
                    ++i5;
                }
            } else {
                this.location.infoT("Data source method of the template [" + this.templateName + "] for application [" + this.applicationName + "] must return String[][],int[] or String[]");
            }
        }
    }

    private void installMonitors(Object data) {
        if (this.oneDimensionalData) {
            String[] dataArray = (String[])data;
            int i = 0;
            while (i < dataArray.length) {
                if (dataArray[i] != null) {
                    String[] temp = new String[]{dataArray[i]};
                    this.installTemplateInstance(temp);
                }
                ++i;
            }
        } else {
            String[][] dataArray = (String[][])data;
            int i = 0;
            while (i < dataArray.length) {
                if (dataArray[i] != null) {
                    this.installTemplateInstance(dataArray[i]);
                }
                ++i;
            }
        }
    }

    private void removeMonitors(Object data) {
        if (this.oneDimensionalData) {
            String[] dataArray = (String[])data;
            int i = 0;
            while (i < dataArray.length) {
                if (dataArray[i] != null) {
                    String[] temp = new String[]{dataArray[i]};
                    this.removeTemplateInstance(temp);
                }
                ++i;
            }
        } else {
            String[][] dataArray = (String[][])data;
            int i = 0;
            while (i < dataArray.length) {
                if (dataArray[i] != null) {
                    this.removeTemplateInstance(dataArray[i]);
                }
                ++i;
            }
        }
    }

    public void installTemplateInstance(String[] instanceData) {
        this.installTemplateTreeNode(this.parentNode, this.templateTree, instanceData);
    }

    public void removeTemplateInstance(String[] instanceData) {
        String[] resolvedPath;
        String[] removalPath = this.getRemovalPath();
        if (removalPath != null && (resolvedPath = this.getResolvedPath(removalPath, instanceData)) != null) {
            this.seekAndDestroy(this.parentNode, removalPath, resolvedPath);
            this.destroyParentNodes(this.parentNode, removalPath, resolvedPath);
        }
    }

    public void installTemplateTreeNode(IMonitorNode parentNode, TemplateTreeNode templateTreeNode, String[] instanceData) {
        String name = this.getMappedValue(templateTreeNode.getName(), instanceData);
        if (name == null) {
            this.location.errorT("There is no mapped value for template node:" + templateTreeNode.getName());
            return;
        }
        this.resolveAndInstallRecursively(parentNode, templateTreeNode, name, instanceData);
    }

    private void resolveAndInstallRecursively(IMonitorNode parent, TemplateTreeNode templateTreeNode, String name, String[] instanceData) {
        byte nodeType = templateTreeNode.getNodeType();
        switch (nodeType) {
            case 1: {
                Vector children;
                if (name == null && (name = this.getMappedValue(templateTreeNode.getName(), instanceData)) == null) {
                    this.location.errorT("There is no mapped value for summary node:" + templateTreeNode.getName());
                    return;
                }
                IMonitorNode monitorNode = parent.subNodeWithName(name);
                if (monitorNode == null) {
                    InstallationInfo installationInfo = this.buildSimpleInstallationInfo(name, parent, templateTreeNode, instanceData);
                    if (installationInfo == null) {
                        return;
                    }
                    monitorNode = MonitorInstaller.installSummary(installationInfo);
                }
                if ((children = templateTreeNode.getChildren()) == null) break;
                int i = 0;
                while (i < children.size()) {
                    this.resolveAndInstallRecursively(monitorNode, (TemplateTreeNode)children.elementAt(i), null, instanceData);
                    ++i;
                }
                break;
            }
            case 2: {
                Vector children;
                if (name == null && (name = this.getMappedValue(templateTreeNode.getName(), instanceData)) == null) {
                    this.location.errorT("There is no mapped value for object node:" + templateTreeNode.getName());
                    return;
                }
                IMonitorNode monitorNode = parent.subNodeWithName(name);
                if (monitorNode == null) {
                    InstallationInfo installationInfo = this.buildSimpleInstallationInfo(name, parent, templateTreeNode, instanceData);
                    if (installationInfo == null) {
                        return;
                    }
                    monitorNode = MonitorInstaller.installObject(installationInfo);
                }
                if ((children = templateTreeNode.getChildren()) == null) break;
                int i = 0;
                while (i < children.size()) {
                    this.resolveAndInstallRecursively(monitorNode, (TemplateTreeNode)children.elementAt(i), null, instanceData);
                    ++i;
                }
                break;
            }
            case 8: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installAvailabilityMonitor(installationInfo);
                break;
            }
            case 11: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installFrequencyMonitor(installationInfo);
                break;
            }
            case 9: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installIntegerMonitor(installationInfo);
                break;
            }
            case 10: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installLongMonitor(installationInfo);
                break;
            }
            case 12: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installQualityRateMonitor(installationInfo);
                break;
            }
            case 13: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installDurationMonitor(installationInfo);
                break;
            }
            case 4: {
                StateMonitorInstallationInfo installationInfo = this.buildStateMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                StateConfigurationGroup stateGroup = (StateConfigurationGroup)installationInfo.getConfigurationGroup();
                if (!(stateGroup.getGreenStates() != null && stateGroup.getGreenStates().length != 0 || stateGroup.getYellowStates() != null && stateGroup.getYellowStates().length != 0 || stateGroup.getRedStates() != null && stateGroup.getRedStates().length != 0)) {
                    MonitorInstaller.installVariableStateMonitor(installationInfo);
                    break;
                }
                MonitorInstaller.installStateMonitor(installationInfo);
                break;
            }
            case 5: {
                TableMonitorInstallationInfo installationInfo = this.buildTableMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installTableMonitor(installationInfo);
                break;
            }
            case 3: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installTextMonitor(installationInfo);
                break;
            }
            case 6: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installVersionMonitor(installationInfo);
                break;
            }
            case 7: {
                MonitorInstallationInfo installationInfo = this.buildMonitorInstallationInfo(name, parent, templateTreeNode, instanceData);
                if (installationInfo == null) {
                    return;
                }
                MonitorInstaller.installConfigurationMonitor(installationInfo);
                break;
            }
        }
    }

    private void seekAndDestroy(IMonitorNode parentNode, String[] removalPath, String[] resolvedPath) {
        if (resolvedPath.length == 0) {
            return;
        }
        IMonitorNode parent = parentNode;
        TemplateTreeNode treeNode = this.templateTree;
        int i = 0;
        while (i < resolvedPath.length - 1) {
            parent = parent.subNodeWithName(resolvedPath[i]);
            treeNode = treeNode.getChildWithName(removalPath[i + 1]);
            ++i;
        }
        if (parent != null) {
            byte nodeType = treeNode.getNodeType();
            switch (nodeType) {
                case 1: {
                    IMonitorNode nodeToRemove = parent.subNodeWithName(resolvedPath[resolvedPath.length - 1]);
                    if (nodeToRemove == null) break;
                    MonitorInstaller.uninstallSummary((ISummaryMonitorNode)nodeToRemove, null);
                    break;
                }
                case 2: {
                    IMonitorNode nodeToRemove = parent.subNodeWithName(resolvedPath[resolvedPath.length - 1]);
                    if (nodeToRemove == null) break;
                    MonitorInstaller.uninstallObject((IObjectMonitorNode)nodeToRemove, null);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    MonitorInstaller.uninstallAttribute(parent, resolvedPath[resolvedPath.length - 1], null);
                }
            }
        }
    }

    private void destroyParentNodes(IMonitorNode parentNode, String[] removalPath, String[] resolvedPath) {
        if (resolvedPath.length == 0) {
            return;
        }
        IMonitorNode parent = parentNode;
        IMonitorNode[] parents = new IMonitorNode[removalPath.length - 1];
        int i = 0;
        while (i < resolvedPath.length - 1) {
            parents[i] = parent.subNodeWithName(resolvedPath[i]);
            parent = parents[i];
            ++i;
        }
        int i2 = removalPath.length - 2;
        while (i2 >= 0) {
            if (parents[i2] != null && parents[i2].getSubNodes().length == 0) {
                MonitorInstaller.uninstallSummary((ISummaryMonitorNode)parents[i2], null);
            }
            --i2;
        }
    }

    protected InstallationInfo buildSimpleInstallationInfo(String name, IMonitorNode parent, TemplateTreeNode templateTreeNode, String[] instanceData) {
        if (name == null && (name = this.getMappedValue(templateTreeNode.getName(), instanceData)) == null) {
            this.location.errorT("There is no mapped value for template node:" + templateTreeNode.getName());
            return null;
        }
        String configurationGroup = templateTreeNode.getGroupName();
        InstallationInfo installationInfo = null;
        installationInfo = new InstallationInfo(name, parent, (SimpleConfigurationGroup)this.groups.get(configurationGroup), this.applicationName);
        return installationInfo;
    }

    protected MonitorInstallationInfo buildMonitorInstallationInfo(String name, IMonitorNode parent, TemplateTreeNode templateTreeNode, String[] instanceData) {
        if (name == null && (name = this.getMappedValue(templateTreeNode.getName(), instanceData)) == null) {
            this.location.errorT("There is no mapped value for template node:" + templateTreeNode.getName());
            return null;
        }
        String configurationGroup = templateTreeNode.getGroupName();
        String monitoredResourceName = this.getMappedValue(templateTreeNode.getMonitoredResourceName(), instanceData);
        String monitoredResourceType = this.getMappedValue(templateTreeNode.getMonitoredResourceType(), instanceData);
        Vector attributeMappings = this.resolveAttributeMappings(templateTreeNode.getAttributeMappings(), instanceData);
        MonitorInstallationInfo installationInfo = null;
        installationInfo = new MonitorInstallationInfo(name, parent, (SimpleConfigurationGroup)this.groups.get(configurationGroup), monitoredResourceName, monitoredResourceType, attributeMappings, this.applicationName);
        return installationInfo;
    }

    protected StateMonitorInstallationInfo buildStateMonitorInstallationInfo(String name, IMonitorNode parent, TemplateTreeNode templateTreeNode, String[] instanceData) {
        if (name == null && (name = this.getMappedValue(templateTreeNode.getName(), instanceData)) == null) {
            this.location.errorT("There is no mapped value for template(state) node:" + templateTreeNode.getName());
            return null;
        }
        String configurationGroup = templateTreeNode.getGroupName();
        String monitoredResourceName = this.getMappedValue(templateTreeNode.getMonitoredResourceName(), instanceData);
        String monitoredResourceType = this.getMappedValue(templateTreeNode.getMonitoredResourceType(), instanceData);
        Vector attributeMappings = this.resolveAttributeMappings(templateTreeNode.getAttributeMappings(), instanceData);
        StateMonitorInstallationInfo installationInfo = null;
        installationInfo = new StateMonitorInstallationInfo(name, parent, (SimpleConfigurationGroup)this.groups.get(configurationGroup), monitoredResourceName, monitoredResourceType, attributeMappings, templateTreeNode.isExplicitGreen(), this.applicationName);
        return installationInfo;
    }

    protected TableMonitorInstallationInfo buildTableMonitorInstallationInfo(String name, IMonitorNode parent, TemplateTreeNode templateTreeNode, String[] instanceData) {
        if (name == null && (name = this.getMappedValue(templateTreeNode.getName(), instanceData)) == null) {
            this.location.errorT("There is no mapped value for template(table) node:" + templateTreeNode.getName());
            return null;
        }
        String configurationGroup = templateTreeNode.getGroupName();
        String monitoredResourceName = this.getMappedValue(templateTreeNode.getMonitoredResourceName(), instanceData);
        String monitoredResourceType = this.getMappedValue(templateTreeNode.getMonitoredResourceType(), instanceData);
        Vector attributeMappings = this.resolveAttributeMappings(templateTreeNode.getAttributeMappings(), instanceData);
        TableMonitorInstallationInfo installationInfo = null;
        installationInfo = new TableMonitorInstallationInfo(name, parent, (SimpleConfigurationGroup)this.groups.get(configurationGroup), monitoredResourceName, monitoredResourceType, attributeMappings, templateTreeNode.getFileName(), this.applicationName);
        return installationInfo;
    }

    private boolean existsChild(IMonitorNode parent, String name) {
        IMonitorNode[] children = parent.getSubNodes();
        int i = 0;
        while (i < children.length) {
            if (name.equals(children[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String getMappedValue(String value, String[] instanceData) {
        if (value == null) {
            return null;
        }
        if (value.startsWith(DYNAMIC_DATA_SYMBOL)) {
            int index = Integer.parseInt(value.substring(DYNAMIC_DATA_SYMBOL.length()));
            try {
                return instanceData[index];
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                return null;
            }
        }
        return value;
    }

    protected Vector resolveAttributeMappings(Vector attributeMappings, String[] instanceData) {
        Vector<AttributeMappingInfo> result = new Vector<AttributeMappingInfo>(attributeMappings.size());
        int i = 0;
        while (i < attributeMappings.size()) {
            TemplateAttributeMappingInfo temp = (TemplateAttributeMappingInfo)attributeMappings.elementAt(i);
            String monitorNodeAttributeName = temp.getMonitorNodeAttributeName();
            String mbeanAttributeName = this.getMappedValue(temp.getmBeanAttributeName(), instanceData);
            Parameter[] parameters = temp.getParameters();
            MBeanCallInfo mBeanCallInfo = null;
            mBeanCallInfo = parameters == null ? new MBeanCallInfo(mbeanAttributeName) : this.resolveOperationMapping(mbeanAttributeName, parameters, instanceData);
            AttributeMappingInfo currentAttributeMapping = new AttributeMappingInfo(monitorNodeAttributeName, mBeanCallInfo);
            result.add(currentAttributeMapping);
            ++i;
        }
        return result;
    }

    protected MBeanCallInfo resolveOperationMapping(String mbeanOperationName, Parameter[] parameters, String[] instanceData) {
        Arrays.sort(parameters);
        Object[] parametersArray = new Object[parameters.length];
        String[] signaturesArray = new String[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            String paramType = this.getMappedValue(parameter.getType(), instanceData);
            String paramValue = this.getMappedValue(parameter.getValue(), instanceData);
            try {
                if (paramType.equals("int")) {
                    parametersArray[i] = new Integer(paramValue);
                    signaturesArray[i] = "int";
                } else if (paramType.equals("String")) {
                    parametersArray[i] = paramValue;
                    signaturesArray[i] = "java.lang.String";
                } else if (paramType.equals("boolean")) {
                    parametersArray[i] = new Boolean(paramValue);
                    signaturesArray[i] = "boolean";
                } else if (paramType.equals("char")) {
                    parametersArray[i] = new Character(paramValue.charAt(0));
                    signaturesArray[i] = "char";
                } else if (paramType.equals("byte")) {
                    parametersArray[i] = new Byte(paramValue);
                    signaturesArray[i] = "byte";
                } else if (paramType.equals("short")) {
                    parametersArray[i] = new Short(paramValue);
                    signaturesArray[i] = "short";
                } else if (paramType.equals("long")) {
                    parametersArray[i] = new Long(paramValue);
                    signaturesArray[i] = "long";
                } else if (paramType.equals("float")) {
                    parametersArray[i] = new Float(paramValue);
                    signaturesArray[i] = "float";
                } else if (paramType.equals("double")) {
                    parametersArray[i] = new Double(paramValue);
                    signaturesArray[i] = "double";
                } else {
                    this.location.errorT("error in XML:Signature for a parameter's type for attribute [" + mbeanOperationName + "] cannot be [" + paramType + "]");
                }
            }
            catch (NumberFormatException ex) {
                this.location.errorT("Wrong paarameter value [" + paramValue + "] .Cannot be parsed : " + ex.getMessage());
            }
            ++i;
        }
        return new MBeanCallInfo(mbeanOperationName, parametersArray, signaturesArray);
    }

    public void handleNotification(Notification notification, Object handle) {
        if (notification.getType().equals("timer.notification")) {
            Object dynamicData = null;
            try {
                dynamicData = this.pollDynamicData();
            }
            catch (Exception e) {
                this.location.warningT(Util.getStackTraceAsString(e));
            }
            this.processDynamicData(dynamicData);
        } else if (notification instanceof AttributeChangeNotification) {
            String attributeName = ((AttributeChangeNotification)notification).getAttributeName();
            if (attributeName != null && attributeName.equals("_TRIGGER_MONITOR_UPDATE")) {
                Object dynamicData = null;
                try {
                    dynamicData = this.pollDynamicData();
                }
                catch (Exception e) {
                    this.location.warningT(Util.getStackTraceAsString(e));
                }
                this.processDynamicData(dynamicData);
            } else {
                Object dynamicData = ((AttributeChangeNotification)notification).getNewValue();
                this.processDynamicData(dynamicData);
            }
        }
    }

    protected Object pollDynamicData() throws Exception {
        Object result = null;
        String generatingResourceName = this.templateInstallationInfo.getGeneratingResourceName();
        String generatingResourceType = this.templateInstallationInfo.getGeneratingResourceType();
        ObjectName generatingResourceObjectName = this.buildObjectName(generatingResourceName, generatingResourceType);
        MBeanCallInfo mBeanCallInfo = this.templateInstallationInfo.getMBeanCallInfo();
        int callType = mBeanCallInfo.getCallType();
        switch (callType) {
            case 1: {
                result = this.mbs.invoke(generatingResourceObjectName, mBeanCallInfo.getMBeanOperationName(), mBeanCallInfo.getParameter(), mBeanCallInfo.getSignature());
                break;
            }
            case 0: {
                result = this.mbs.getAttribute(generatingResourceObjectName, mBeanCallInfo.getMBeanAttributeName());
            }
        }
        return result;
    }

    public ObjectName buildObjectName(String resourceName, String resourceType) {
        ObjectName objectName = null;
        if (resourceType.equals("MANAGER")) {
            try {
                objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelRuntimePerNode", (String)resourceName, null, null);
            }
            catch (MalformedObjectNameException ex) {
                this.location.errorT(Util.getStackTraceAsString(ex));
            }
        } else if (resourceType.equals("SERVICE")) {
            try {
                objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)resourceName, null, null);
            }
            catch (MalformedObjectNameException ex) {
                this.location.errorT(Util.getStackTraceAsString(ex));
            }
        } else if (resourceType.equals("MBEAN")) {
            try {
                objectName = new ObjectName(resourceName);
            }
            catch (MalformedObjectNameException ex) {
                this.location.errorT(Util.getStackTraceAsString(ex));
            }
        } else if (resourceType.equals("APPLICATION")) {
            try {
                String appName = this.applicationName;
                if (appName.startsWith("application ")) {
                    StringBuffer app = new StringBuffer(appName);
                    app.delete(0, "application ".length());
                    appName = app.toString();
                }
                objectName = ObjectNameFactory.getNameForApplicationResourcePerNode((String)resourceName, (String)appName, null, null);
            }
            catch (MalformedObjectNameException ex) {
                this.location.errorT(Util.getStackTraceAsString(ex));
            }
        }
        return objectName;
    }

    private long getGranularityPeriod(int unit, int value) {
        long granularityPeriod = 0L;
        switch (unit) {
            case 0: {
                granularityPeriod = value * 60000;
                break;
            }
            case 1: {
                granularityPeriod = value * 3600000;
                break;
            }
            case 2: {
                granularityPeriod = value * 86400000;
            }
        }
        return granularityPeriod;
    }

    protected Vector getIntersection(Object firstSet, Object secondSet) {
        Vector<Object> result = new Vector<Object>();
        if (this.oneDimensionalData) {
            String[] firstSetArray = (String[])firstSet;
            String[] secondSetArray = (String[])secondSet;
            int i = 0;
            while (i < firstSetArray.length) {
                String element = firstSetArray[i];
                int t = 0;
                while (t < secondSetArray.length) {
                    if (element.equals(secondSetArray[t])) {
                        result.addElement(element);
                        firstSetArray[i] = null;
                        secondSetArray[t] = null;
                        break;
                    }
                    ++t;
                }
                ++i;
            }
        } else {
            String[][] firstSetArray = (String[][])firstSet;
            String[][] secondSetArray = (String[][])secondSet;
            int i = 0;
            while (i < firstSetArray.length) {
                String[] element = firstSetArray[i];
                int t = 0;
                while (t < secondSetArray.length) {
                    if (this.areEqual(element, secondSetArray[t])) {
                        result.addElement(element);
                        firstSetArray[i] = null;
                        secondSetArray[t] = null;
                        break;
                    }
                    ++t;
                }
                ++i;
            }
        }
        return result;
    }

    protected boolean areEqual(String[] firstArray, String[] secondArray) {
        if (firstArray != null && secondArray != null) {
            if (firstArray.length != secondArray.length) {
                return false;
            }
            int i = 0;
            while (i < firstArray.length) {
                if (firstArray[i] == null || secondArray[i] == null || !firstArray[i].equals(secondArray[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    protected String[] getRemovalPath() {
        if (this.removalPath == null) {
            TemplateTreeNode node = this.templateTree;
            Vector children = null;
            Vector<String> temp = new Vector<String>();
            int index = 0;
            String name = null;
            do {
                name = node.getName();
                temp.add(name);
                if (name.startsWith(DYNAMIC_DATA_SYMBOL)) {
                    index = temp.size();
                }
                if ((children = node.getChildren()) == null || children.size() != 1) break;
                node = (TemplateTreeNode)children.elementAt(0);
            } while (children != null || children.size() == 1);
            this.removalPath = new String[index];
            int i = 0;
            while (i < index) {
                this.removalPath[i] = (String)temp.elementAt(i);
                ++i;
            }
        }
        return this.removalPath;
    }

    protected String[] getResolvedPath(String[] path, String[] instanceData) {
        String[] result = new String[path.length];
        int i = 0;
        while (i < path.length) {
            result[i] = this.getMappedValue(path[i], instanceData);
            ++i;
        }
        return result;
    }

    public String getApplicationName() {
        if (this.applicationName != null) {
            return this.applicationName;
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

