/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.config.TableConfigurationGroup;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.TableMonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.ITableMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.TableMonitorMBean;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.Enumeration;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class TableMonitor
extends Monitor
implements TableMonitorMBean,
ITableMonitor {
    private Serializable[] tableHeader;
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.mbeans.TableMonitor");

    public TableMonitor(TableMonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    public void setObservedAttribute(String attribute) {
        throw new UnsupportedOperationException("Operation setObservedAttribute(...) not supported");
    }

    public String getObservedAttribute() {
        throw new UnsupportedOperationException("Operation getObservedAttribute() not supported");
    }

    protected void configureMonitorNode(IMonitorNode monitorNode, MonitorInstallationInfo installInfo) throws com.sap.engine.library.monitor.MonitorException {
        ((ITableMonitorNode)monitorNode).setTableFileName(((TableMonitorInstallationInfo)installInfo).getFilename());
        super.configureMonitorNode(monitorNode, installInfo);
        ((ITableMonitorNode)monitorNode).setHeader(Util.objectArray2StringArray(((TableConfigurationGroup)installInfo.getConfigurationGroup()).getColumns().toArray()));
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.monitorNode = Monitor.monitorObjectFactory.createTableMonitorNode(installInfo.getName(), installInfo.getParentNode());
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the TableMonitor");
        }
        catch (MonitorException ex) {
            this.location.warningT("Timer triger could not be activated");
            this.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        Serializable[][] tabEntries = null;
        try {
            tabEntries = this.collectMonitoringData();
            this.storeMonitoringData(tabEntries);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        Serializable[][] tabEntries = null;
        try {
            tabEntries = this.collectMonitoringData();
            this.storeMonitoringData(tabEntries);
        }
        catch (JMException ex) {
            this.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            this.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("Entries")) {
            Serializable[][] tabEntries = null;
            tabEntries = (Serializable[][])notification.getNewValue();
            this.storeMonitoringData(tabEntries);
        }
    }

    public Serializable entryAt(int rowPos, int colPos) {
        return ((ITableMonitorNode)this.monitorNode).entryAt(rowPos, colPos);
    }

    public Serializable[] rowAt(int index) {
        return ((ITableMonitorNode)this.monitorNode).rowAt(index);
    }

    public Serializable[][] getEntries() {
        return ((ITableMonitorNode)this.monitorNode).getEntries();
    }

    public Serializable[] getHeader() {
        return ((ITableMonitorNode)this.monitorNode).getHeader();
    }

    public void setEntries(Serializable[][] entries) {
        ((ITableMonitorNode)this.monitorNode).setEntries(entries);
    }

    public void setHeader(String[] header) {
        ((ITableMonitorNode)this.monitorNode).setHeader(header);
    }

    private void storeTableHeader(Serializable[] tableHeader) {
        ((ITableMonitorNode)this.monitorNode).setHeader((String[])tableHeader);
    }

    private void storeMonitoringData(Serializable[][] tabEntries) {
        block9: {
            try {
                if (tabEntries != null) {
                    ((ITableMonitorNode)this.monitorNode).setEntries(tabEntries);
                    if (this.location.beInfo()) {
                        this.location.infoT("New values for the table monitor node with path [" + this.getPath() + "] :");
                        int i = 0;
                        while (i < tabEntries.length) {
                            String row = "";
                            if (tabEntries[i] != null) {
                                int j = 0;
                                while (j < tabEntries[i].length) {
                                    row = row + " [" + tabEntries[i][j] + "] ";
                                    ++j;
                                }
                                this.location.infoT(row);
                            }
                            ++i;
                        }
                    }
                } else if (this.location.beInfo()) {
                    this.location.infoT("New values for the table monitor node with path [" + this.getPath() + "] :null");
                }
            }
            catch (Exception e) {
                if (!this.location.beInfo()) break block9;
                this.location.infoT("Wrong table entries for table monitor with path [" + this.getPath() + "] ");
            }
        }
    }

    private Serializable[][] collectMonitoringData() throws JMException {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("Entries")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
        }
        return (Serializable[][])mBeanResult;
    }
}

