/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.IStringMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.StringMonitorMBean;
import java.util.Enumeration;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class StringMonitor
extends Monitor
implements StringMonitorMBean,
IStringMonitor {
    public StringMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.monitorNode = Monitor.monitorObjectFactory.createStringMonitorNode(installInfo.getName(), installInfo.getParentNode());
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the StringMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        String stringVal = null;
        try {
            stringVal = this.collectMonitoringData();
            this.storeMonitoringData(stringVal);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        String stringVal = null;
        try {
            stringVal = this.collectMonitoringData();
            this.storeMonitoringData(stringVal);
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("Text")) {
            String text = (String)notification.getNewValue();
            this.storeMonitoringData(text);
        }
    }

    public String getText() {
        return ((IStringMonitorNode)this.monitorNode).getText();
    }

    public void setText(String text) {
        ((IStringMonitorNode)this.monitorNode).setText(text);
    }

    private String collectMonitoringData() throws JMException {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("Text")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
        }
        return (String)mBeanResult;
    }

    private void storeMonitoringData(String stringVal) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the string monitor node with path [" + this.getPath() + "] is: [" + stringVal + "]");
        }
        this.setText(stringVal);
    }
}

