/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IStateMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.IStateMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.StateMonitorMBean;
import java.util.Enumeration;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class StateMonitor
extends Monitor
implements StateMonitorMBean,
IStateMonitor {
    public StateMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void configureMonitorNode(IMonitorNode monitorNode, MonitorInstallationInfo installInfo) throws com.sap.engine.library.monitor.MonitorException {
        StateConfigurationGroup configGroup = (StateConfigurationGroup)installInfo.getConfigurationGroup();
        ((IStateMonitorNode)monitorNode).setAlertMode(configGroup.getAlertMode());
        super.configureMonitorNode(monitorNode, installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        StateConfigurationGroup configGroup = (StateConfigurationGroup)installInfo.getConfigurationGroup();
        IStateMonitorNode stateMonitorNode = Monitor.monitorObjectFactory.createStateMonitorNode(installInfo.getName(), installInfo.getParentNode(), configGroup.getRedStates(), configGroup.getYellowStates(), configGroup.getGreenStates());
        this.monitorNode = stateMonitorNode;
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the StateMonitor");
        }
        catch (MonitorException ex) {
            ex.log();
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        String stateVal = null;
        try {
            stateVal = this.collectMonitoringData();
            this.storeMonitoringData(stateVal);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        String stateVal = null;
        try {
            stateVal = this.collectMonitoringData();
            this.storeMonitoringData(stateVal);
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("State")) {
            String state = (String)notification.getNewValue();
            this.storeMonitoringData(state);
        }
    }

    public String[] getRedStates() {
        return ((IStateMonitorNode)this.monitorNode).getRedStates();
    }

    public String[] getGreenStates() {
        return ((IStateMonitorNode)this.monitorNode).getGreenStates();
    }

    public String[] getYellowStates() {
        return ((IStateMonitorNode)this.monitorNode).getYellowStates();
    }

    public String getState() {
        return ((IStateMonitorNode)this.monitorNode).getState();
    }

    public void setRedStates(String[] redStates) {
        ((IStateMonitorNode)this.monitorNode).setRedStates(redStates);
    }

    public void setGreenStates(String[] greenStates) {
        ((IStateMonitorNode)this.monitorNode).setGreenStates(greenStates);
    }

    public void setYellowState(String[] yellowStates) {
        ((IStateMonitorNode)this.monitorNode).setYellowStates(yellowStates);
    }

    public void setState(String state) {
        try {
            ((IStateMonitorNode)this.monitorNode).setState(state);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in states.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
    }

    private String collectMonitoringData() throws JMException {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("State")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
        }
        return (String)mBeanResult;
    }

    private void storeMonitoringData(String state) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the state monitor node with path [" + this.getPath() + "] is: [" + state + "]");
        }
        this.setState(state);
    }
}

