/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IQualityRateMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.IQualityRateMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import com.sap.engine.services.monitor.mbeans.QualityRateMonitorMBean;
import com.sap.jmx.monitoring.api.QualityRateValue;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class QualityRateMonitor
extends PerformanceMonitor
implements QualityRateMonitorMBean,
IQualityRateMonitor {
    public QualityRateMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IThresholds thresholds = null;
        try {
            thresholds = this.getThresholds(installInfo);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in thresholds.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.monitorNode = Monitor.monitorObjectFactory.createQualityRateMonitorNode(installInfo.getName(), installInfo.getParentNode(), thresholds);
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the QualityRateMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        Object mBeanResult = null;
        Object monitorNodeAttributeName = null;
        long totalTriesFromStartup = 0L;
        long totalSuccessfulTriesFromStartup = 0L;
        try {
            if (this.attributeMappings.size() == 1) {
                mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo());
                totalTriesFromStartup = ((QualityRateValue)mBeanResult).getTries();
                totalSuccessfulTriesFromStartup = ((QualityRateValue)mBeanResult).getHits();
            } else if (this.attributeMappings.size() == 2) {
                MBeanCallInfo mBeanCallInfo1 = ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo();
                MBeanCallInfo mBeanCallInfo2 = ((AttributeMappingInfo)this.attributeMappings.get(1)).getMBeanCallInfo();
                if (((AttributeMappingInfo)this.attributeMappings.get(0)).getMonitorNodeAttributeName().equals("TotalTriesFromStartup")) {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalTriesFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalSuccessfulTriesFromStartup = (Long)mBeanResult;
                } else {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalTriesFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalSuccessfulTriesFromStartup = (Long)mBeanResult;
                }
            }
            this.storeMonitoringData(totalTriesFromStartup, totalSuccessfulTriesFromStartup);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        Object mBeanResult = null;
        long totalTriesFromStartup = 0L;
        long totalSuccessfulTriesFromStartup = 0L;
        try {
            if (this.attributeMappings.size() == 1) {
                mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo());
                totalTriesFromStartup = ((QualityRateValue)mBeanResult).getTries();
                totalSuccessfulTriesFromStartup = ((QualityRateValue)mBeanResult).getHits();
            } else if (this.attributeMappings.size() == 2) {
                MBeanCallInfo mBeanCallInfo1 = ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo();
                MBeanCallInfo mBeanCallInfo2 = ((AttributeMappingInfo)this.attributeMappings.get(1)).getMBeanCallInfo();
                if (((AttributeMappingInfo)this.attributeMappings.get(0)).getMonitorNodeAttributeName().equals("TotalTriesFromStartup")) {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalTriesFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalSuccessfulTriesFromStartup = (Long)mBeanResult;
                } else {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalTriesFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalSuccessfulTriesFromStartup = (Long)mBeanResult;
                }
            }
            this.storeMonitoringData(totalTriesFromStartup, totalSuccessfulTriesFromStartup);
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        QualityRateValue value = (QualityRateValue)notification.getNewValue();
        this.storeMonitoringData(value.getTries(), value.getHits());
    }

    public double getCurrentQualityRate() {
        return ((IQualityRateMonitorNode)this.monitorNode).getCurrentQualityRate();
    }

    public double getAverageQualityRate() {
        return ((IQualityRateMonitorNode)this.monitorNode).getAverageQualityRate();
    }

    public long getTotalTries() {
        return ((IQualityRateMonitorNode)this.monitorNode).getTotalTries();
    }

    public long getSuccessfulTries() {
        return ((IQualityRateMonitorNode)this.monitorNode).getSuccessfulTries();
    }

    public double getMinQualityRate() {
        return ((IQualityRateMonitorNode)this.monitorNode).getMinQualityRate();
    }

    public double getMaxQualityRate() {
        return ((IQualityRateMonitorNode)this.monitorNode).getMaxQualityRate();
    }

    public void addTries(long totalTries, long successfulTries) {
        ((IQualityRateMonitorNode)this.monitorNode).addTries(totalTries, successfulTries);
    }

    public void resetTries(long totalTries, long successfulTries) {
        ((IQualityRateMonitorNode)this.monitorNode).resetTries(totalTries, successfulTries);
    }

    private void storeMonitoringData(long totalTriesFromStartup, long totalSuccessfulTriesFromStartup) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the quality rate monitor node with path [" + this.getPath() + "] are total Tries From Startup: [" + totalTriesFromStartup + "] and total Successful Tries From Startup: [" + totalSuccessfulTriesFromStartup + "]");
        }
        ((IQualityRateMonitorNode)this.monitorNode).resetTries(totalTriesFromStartup, totalSuccessfulTriesFromStartup);
    }
}

