/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IPoolMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.IPoolMonitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import com.sap.engine.services.monitor.mbeans.PoolMonitorMBean;
import javax.management.AttributeChangeNotification;

public class PoolMonitor
extends PerformanceMonitor
implements PoolMonitorMBean,
IPoolMonitor {
    public PoolMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the PoolMonitor");
        }
        catch (MonitorException monitorException) {
            // empty catch block
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
    }

    protected void tryToCollectAndStoreMonitoringData() {
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("NumberOfCurrentUsedObjects")) {
            int numberOfCurrentUsedObjects = (Integer)notification.getNewValue();
            this.storeNumberOfCurrentUsedObjects(numberOfCurrentUsedObjects);
        } else if (monitorAttribute.equals("MinPoolSize")) {
            int minPoolSize = (Integer)notification.getNewValue();
            this.storeMinPoolSize(minPoolSize);
        } else if (monitorAttribute.equals("InitialPoolSize")) {
            int initialPoolSize = (Integer)notification.getNewValue();
            this.storeInitialPoolSize(initialPoolSize);
        } else if (monitorAttribute.equals("IncrementSize")) {
            int incrementSize = (Integer)notification.getNewValue();
            this.storeIncrementSize(incrementSize);
        } else if (monitorAttribute.equals("MaxPoolSize")) {
            int maxPoolSize = (Integer)notification.getNewValue();
            this.storeMaxPoolSize(maxPoolSize);
        } else if (monitorAttribute.equals("CurrentPoolSize")) {
            int currentPoolSize = (Integer)notification.getNewValue();
            this.storeCurrentPoolSize(currentPoolSize);
        }
    }

    public int getMaxPoolSize() {
        return ((IPoolMonitorNode)this.monitorNode).getMaxPoolSize();
    }

    public int getCurrentPoolSize() {
        return ((IPoolMonitorNode)this.monitorNode).getCurrentPoolSize();
    }

    public int getNumberOfCurrentUsedObjects() {
        return ((IPoolMonitorNode)this.monitorNode).getNumberOfCurrentUsedObjects();
    }

    public int getMaxNumberOfCurrentUsedObjects() {
        return ((IPoolMonitorNode)this.monitorNode).getMaxNumberOfCurrentUsedObjects();
    }

    public int getMinNumberOfCurrentUsedObjects() {
        return ((IPoolMonitorNode)this.monitorNode).getMinNumberOfCurrentUsedObjects();
    }

    public int getMinPoolSize() {
        return ((IPoolMonitorNode)this.monitorNode).getMinPoolSize();
    }

    public int getInitialPoolSize() {
        return ((IPoolMonitorNode)this.monitorNode).getInitialPoolSize();
    }

    public int getIncrementSize() {
        return ((IPoolMonitorNode)this.monitorNode).getIncrementSize();
    }

    public void setNumberOfCurrentUsedObjects(int number) {
        ((IPoolMonitorNode)this.monitorNode).setNumberOfCurrentUsedObjects(number);
    }

    public void setMinPoolSize(int minSize) {
        ((IPoolMonitorNode)this.monitorNode).setMinPoolSize(minSize);
    }

    public void setInitialPoolSize(int initialSize) {
        ((IPoolMonitorNode)this.monitorNode).setInitialPoolSize(initialSize);
    }

    public void setIncrementSize(int incrementorSize) {
        ((IPoolMonitorNode)this.monitorNode).setIncrementSize(incrementorSize);
    }

    public void setMaxPoolSize(int maxSize) {
        ((IPoolMonitorNode)this.monitorNode).setMaxPoolSize(maxSize);
    }

    public void setCurrentPoolSize(int size) {
        ((IPoolMonitorNode)this.monitorNode).setCurrentPoolSize(size);
    }

    private void storeNumberOfCurrentUsedObjects(int numberOfCurrentUsedObjects) {
        ((IPoolMonitorNode)this.monitorNode).setNumberOfCurrentUsedObjects(numberOfCurrentUsedObjects);
    }

    private void storeMinPoolSize(int minPoolSize) {
        ((IPoolMonitorNode)this.monitorNode).setMinPoolSize(minPoolSize);
    }

    private void storeInitialPoolSize(int initialPoolSize) {
        ((IPoolMonitorNode)this.monitorNode).setInitialPoolSize(initialPoolSize);
    }

    private void storeIncrementSize(int incrementSize) {
        ((IPoolMonitorNode)this.monitorNode).setIncrementSize(incrementSize);
    }

    private void storeMaxPoolSize(int maxPoolSize) {
        ((IPoolMonitorNode)this.monitorNode).setMaxPoolSize(maxPoolSize);
    }

    private void storeCurrentPoolSize(int currentPoolSize) {
        ((IPoolMonitorNode)this.monitorNode).setCurrentPoolSize(currentPoolSize);
    }
}

