/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.library.monitor.IAttributeMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorNodeListener;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.MonitorFactory;
import com.sap.engine.services.jmx.server.LocalMBeanServerNotificationFilter;
import com.sap.engine.services.monitor.MonitorConstants;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.MonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstaller;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.IMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.MonitorResourceAccessor;
import com.sap.engine.services.monitor.mbeans.ResourceMBeanFilter;
import com.sap.engine.services.monitor.mbeans.TimerFilter;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public abstract class Monitor
implements IMonitor,
MBeanRegistration,
NotificationListener,
LocalMBeanServerNotificationFilter {
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_DAY = 86400000;
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$monitor$mbeans$Monitor == null ? (class$com$sap$engine$services$monitor$mbeans$Monitor = Monitor.class$("com.sap.engine.services.monitor.mbeans.Monitor")) : class$com$sap$engine$services$monitor$mbeans$Monitor));
    private static final String MBeanServerDelegateName = "JMImplementation:type=MBeanServerDelegate";
    private static final String[] SIGNATURE = new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = Monitor.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()};
    private static final String METHOD = "replaceEmptyKeyValues";
    public static IMonitorObjectFactory monitorObjectFactory;
    protected MBeanServer mbs = null;
    public ObjectName myObjectName = null;
    protected ObjectName timer = null;
    protected boolean isTimerTriggerActive = false;
    protected boolean isRegisteredToRuntimeMBean = false;
    protected Vector observedObjects = new Vector();
    protected boolean isActive;
    protected IMonitorNode monitorNode = null;
    protected DataCollection dataCollection = null;
    protected Vector attributeMappings = null;
    protected static Location location;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$Monitor;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Date;

    public static void init() {
        monitorObjectFactory = MonitorFactory.createMonitorObjectFactory();
        monitorObjectFactory.getRootNode().setName("Root");
        CATEGORY.setEffectiveSeverity(0);
        CATEGORY.setResourceBundleName(MonitorResourceAccessor.getResourceAccessor().getResourceBundleName());
    }

    public static void destroy() {
        MonitorResourceAccessor.clearResourceAccessor();
        monitorObjectFactory = null;
    }

    public String getPath() {
        return this.monitorNode.getPath();
    }

    public void unregister() {
        try {
            this.stop();
            if (this.mbs != null && this.myObjectName != null) {
                this.mbs.unregisterMBean(this.myObjectName);
            }
        }
        catch (JMException ex) {
            LOCATION.errorT("cannot unregister monitor " + this.myObjectName.toString() + " from MBean server");
        }
    }

    public void handleNotification(Notification notification, Object hb) {
        if (notification.getType().equals("timer.notification")) {
            this.collectAndStoreMonitoringData();
        } else if (notification instanceof AttributeChangeNotification) {
            this.updateMonitoringData((AttributeChangeNotification)notification);
        } else if (notification instanceof MBeanServerNotification) {
            this.registerMonitorToRuntimeMBean();
        }
    }

    public void start() {
        if (this.dataCollection.getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
            this.activateTimerTrigger();
        }
        if (this.dataCollection.getDataCollectionType() == DataCollection.TRIGGERED_BY_RESOURCE || this.dataCollection.getDataCollectionType() == DataCollection.PUSHED_BY_RESOURCE) {
            this.registerToRuntimeMBean();
        }
        this.isActive = true;
    }

    public void stop() {
        this.deregisterFromTimerAndRuntimeMBean();
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public ObjectName getObservedObject() {
        return (ObjectName)this.observedObjects.get(0);
    }

    public void setObservedObject(ObjectName object) {
        this.observedObjects.clear();
        this.observedObjects.add(object);
    }

    public String getObservedAttribute() {
        throw new UnsupportedOperationException("Operation getObservedAttribute() not supported");
    }

    public void setObservedAttribute(String attribute) {
        throw new UnsupportedOperationException("Operation setObservedAttribute() not supported");
    }

    public long getGranularityPeriod() {
        Period collectPeriod = this.dataCollection.getCollectPeriod();
        int unit = collectPeriod.getUnit();
        int value = collectPeriod.getValue();
        return this.getGranularityPeriod(unit, value);
    }

    public void setGranularityPeriod(long period) {
        throw new UnsupportedOperationException("Operation setGranularityPeriod not supported");
    }

    public void addObservedObject(ObjectName object) throws IllegalArgumentException {
        this.observedObjects.clear();
        this.observedObjects.add(object);
    }

    public boolean containsObservedObject(ObjectName object) {
        return this.observedObjects.contains(object);
    }

    public ObjectName[] getObservedObjects() {
        return (ObjectName[])this.observedObjects.toArray();
    }

    public void removeObservedObject(ObjectName object) {
        this.observedObjects.remove(object);
    }

    public ObjectName preRegister(MBeanServer mbs, ObjectName name) {
        this.mbs = mbs;
        this.myObjectName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() {
        this.deregisterFromTimerAndRuntimeMBean();
        if (this.monitorNode != null && this.monitorNode.getParent() != null) {
            this.monitorNode.remove(null);
            this.monitorNode = null;
        }
    }

    public void postDeregister() {
    }

    public IMonitorNode getMonitorNode() {
        return this.monitorNode;
    }

    protected static String extractMonitorNameFromPath(String treePath) {
        int lastSlashInPath = treePath.lastIndexOf("/");
        return treePath.substring(lastSlashInPath + 1);
    }

    protected static Object getMBeanResult(MBeanServer mbs, ObjectName runtimeMBean, MBeanCallInfo mBeanCallInfo) throws JMException {
        Object mBeanResult = null;
        switch (mBeanCallInfo.getCallType()) {
            case 0: {
                try {
                    mBeanResult = mbs.getAttribute(runtimeMBean, mBeanCallInfo.getMBeanAttributeName());
                }
                catch (RuntimeOperationsException ex) {
                    location.errorT("Cannot get result for an attribure:" + mBeanCallInfo.getMBeanAttributeName() + " ; resource MBean name:" + runtimeMBean);
                    location.debugT(Util.getStackTraceAsString(ex));
                }
                break;
            }
            case 1: {
                try {
                    mBeanResult = mbs.invoke(runtimeMBean, mBeanCallInfo.getMBeanOperationName(), mBeanCallInfo.getParameter(), mBeanCallInfo.getSignature());
                    break;
                }
                catch (RuntimeOperationsException ex) {
                    location.errorT("Cannot get result for an attribure:" + mBeanCallInfo.getMBeanOperationName() + " from resource MBean name:" + runtimeMBean);
                    location.debugT(Util.getStackTraceAsString(ex));
                }
            }
        }
        return mBeanResult;
    }

    protected void constructMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.createMonitorNode(installInfo);
        try {
            this.registerToMonitorNode();
            this.configureMonitorNode(this.monitorNode, installInfo);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            LOCATION.errorT("Error in constructing monitor node [" + this.monitorNode.getPath() + "]. Reason: " + ex.getMessage());
            LOCATION.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.addObservedObject(installInfo);
    }

    protected void configureMonitorNode(IMonitorNode monitorNode, MonitorInstallationInfo installInfo) throws com.sap.engine.library.monitor.MonitorException {
        this.storeConfigDataInMonitor(installInfo);
        MonitorInstaller.configureMonitorNode(monitorNode, installInfo, this.dataCollection);
    }

    protected void storeConfigDataInMonitor(MonitorInstallationInfo installInfo) {
        this.dataCollection = ((MonitorConfigurationGroup)installInfo.getConfigurationGroup()).getDataCollection();
        this.attributeMappings = installInfo.getAttributeMappings();
    }

    protected String getMonitorAttribute(AttributeChangeNotification notification) {
        String monitorAttribute = "";
        Iterator it = ((AbstractList)this.attributeMappings).iterator();
        AttributeMappingInfo attributeMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        while (it.hasNext()) {
            attributeMappingInfo = (AttributeMappingInfo)it.next();
            mBeanCallInfo = attributeMappingInfo.getMBeanCallInfo();
            if (!this.isMatching(mBeanCallInfo, notification)) continue;
            monitorAttribute = attributeMappingInfo.getMonitorNodeAttributeName();
            break;
        }
        return monitorAttribute;
    }

    private boolean isMatching(MBeanCallInfo mBeanCallInfo, AttributeChangeNotification notification) {
        return mBeanCallInfo.getCallType() == 0 && mBeanCallInfo.getMBeanAttributeName().equals(notification.getAttributeName());
    }

    protected void addObservedObject(MonitorInstallationInfo installInfo) {
        String attrType = installInfo.getMonitoredResourceType();
        String attrName = installInfo.getMonitoredResourceName();
        String appName = installInfo.getApplicationName();
        ObjectName resourceName = null;
        if (attrType.equals("MBEAN") || appName == null) {
            resourceName = this.getResourceMBean(attrType, attrName);
        } else if (attrType.equals("APPLICATION")) {
            resourceName = this.getResourceMBean(attrType, attrName, appName);
        }
        try {
            this.addObservedObject(resourceName);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    protected void activateTimerTrigger(String timerMessage) throws MonitorException {
        Date date = null;
        Integer notificationId = null;
        try {
            this.timer = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
        }
        catch (MalformedObjectNameException ex) {
            String method = "activateTimerTrigger(String)";
            String messageKey = MonitorException.messageDomain + "_" + new Integer(0).toString();
            MonitorException monEx = new MonitorException(CATEGORY, 500, LOCATION, method, messageKey, new Object[]{"timer service"}, ex);
            LOCATION.throwing(method, (Throwable)((Object)monEx));
            LoggingHelper.traceThrowable((int)500, (Location)LOCATION, (String)method, (Throwable)((Object)monEx));
            throw monEx;
        }
        date = new Date(System.currentTimeMillis() + 5000L);
        try {
            notificationId = (Integer)this.mbs.invoke(this.timer, "addNotification", new Object[]{"timer.notification", timerMessage, null, date, new Long(this.getGranularityPeriod())}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = Monitor.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = Monitor.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = Monitor.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$util$Date == null ? (class$java$util$Date = Monitor.class$("java.util.Date")) : class$java$util$Date).getName(), "long"});
        }
        catch (JMException ex) {
            ex.printStackTrace();
        }
        TimerFilter timerFilter = new TimerFilter(notificationId);
        try {
            this.mbs.addNotificationListener(this.timer, this.myObjectName, (NotificationFilter)timerFilter, (Object)"TimerNotification");
        }
        catch (JMException ex) {
            ex.printStackTrace();
        }
    }

    protected void deactivateTimerTrigger() {
        if (this.isTimerTriggerActive && this.mbs != null) {
            try {
                this.mbs.removeNotificationListener(this.timer, this.myObjectName);
                this.isTimerTriggerActive = false;
            }
            catch (JMException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void registerToRuntimeMBean() {
        try {
            ObjectName name = ObjectNameFactory.getNameForServerChildPerNode((String)"com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor", (String)"ParameterCompletionInterceptor", null, null);
            ObjectName resourceName = (ObjectName)this.mbs.invoke(name, METHOD, new Object[]{(ObjectName)this.observedObjects.get(0)}, SIGNATURE);
            this.mbs.addNotificationListener(new ObjectName(MBeanServerDelegateName), this.myObjectName, (NotificationFilter)new ResourceMBeanFilter(resourceName), null);
        }
        catch (JMException ex) {
            LOCATION.errorT("Error registering to Runtime MBean. Reason: [" + ex.getMessage() + "]");
        }
        this.registerMonitorToRuntimeMBean();
        this.tryToCollectAndStoreMonitoringData();
    }

    protected void removeOnConfigured() {
        switch (this.dataCollection.getReactOnCollectionFailure()) {
            case 3: {
                this.monitorNode.remove(null);
                LOCATION.errorT("monitor " + this.monitorNode.getPath() + " was removed due to failure during data collection");
                break;
            }
        }
    }

    private void registerMonitorToRuntimeMBean() {
        try {
            this.mbs.addNotificationListener((ObjectName)this.observedObjects.get(0), this.myObjectName, null, null);
            this.isRegisteredToRuntimeMBean = true;
            this.mbs.removeNotificationListener(new ObjectName(MBeanServerDelegateName), this.myObjectName);
        }
        catch (JMException ex) {
            LOCATION.warningT("Cannot register monitor [" + this.myObjectName + "] to runtime MBean [" + this.observedObjects.get(0) + "], because it still does not exist.");
            LOCATION.infoT(Util.getStackTraceAsString(ex));
        }
        catch (RuntimeOperationsException e) {
            location.errorT("Error in arguments. Reason: [" + e.getTargetException().getMessage() + "]");
            location.infoT(Util.getStackTraceAsString(e));
        }
    }

    protected void deregisterFromRuntimeMBean() {
        if (this.isRegisteredToRuntimeMBean) {
            try {
                this.mbs.removeNotificationListener((ObjectName)this.observedObjects.get(0), this.myObjectName);
            }
            catch (JMException ex) {
                LOCATION.infoT(Util.getStackTraceAsString(ex));
            }
        }
        this.isRegisteredToRuntimeMBean = false;
    }

    protected void setMonitorNode(IMonitorNode monitorNode) {
        this.monitorNode = monitorNode;
    }

    protected ObjectName getResourceMBean(String monitoredResourceType, String monitoredResourceName) {
        ObjectName resourceMBean = null;
        if (monitoredResourceType.equals("MANAGER")) {
            try {
                resourceMBean = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEKernelRuntimePerNode", (String)monitoredResourceName, null, null);
            }
            catch (MalformedObjectNameException ex) {
                ex.printStackTrace();
            }
        } else if (monitoredResourceType.equals("SERVICE")) {
            try {
                resourceMBean = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)monitoredResourceName, null, null);
            }
            catch (MalformedObjectNameException ex) {
                ex.printStackTrace();
            }
        } else if (monitoredResourceType.equals("MBEAN")) {
            try {
                resourceMBean = monitoredResourceName == MonitorConstants.CONFIGURATION_RESOURCE_MBEAN ? ObjectNameFactory.getObjectName((String)MonitorConstants.CONFIGURATION_RESOURCE_MBEAN_NAME, (String)MonitorConstants.CONFIGURATION_RESOURCE_MBEAN_TYPE) : new ObjectName(monitoredResourceName);
            }
            catch (MalformedObjectNameException ex) {
                ex.printStackTrace();
            }
        }
        return resourceMBean;
    }

    protected ObjectName getResourceMBean(String monitoredResourceType, String monitoredResourceName, String applicName) {
        ObjectName resourceMBean = null;
        try {
            if (applicName != null) {
                if (applicName.startsWith("application ")) {
                    StringBuffer app = new StringBuffer(applicName);
                    app.delete(0, "application ".length());
                    applicName = app.toString();
                }
            } else {
                throw new MalformedObjectNameException();
            }
            resourceMBean = ObjectNameFactory.getNameForApplicationResourcePerNode((String)monitoredResourceName, (String)applicName, null, null);
        }
        catch (MalformedObjectNameException ex) {
            ex.printStackTrace();
        }
        return resourceMBean;
    }

    protected Object getMBeanResult() throws JMException {
        AttributeMappingInfo attributeMappingInfo = (AttributeMappingInfo)this.attributeMappings.firstElement();
        return Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.firstElement(), attributeMappingInfo.getMBeanCallInfo());
    }

    private long getGranularityPeriod(int unit, int value) {
        long granularityPeriod = 0L;
        switch (unit) {
            case 0: {
                granularityPeriod = value * 60000;
                break;
            }
            case 1: {
                granularityPeriod = value * 3600000;
                break;
            }
            case 2: {
                granularityPeriod = value * 86400000;
            }
        }
        return granularityPeriod;
    }

    private void deregisterFromTimerAndRuntimeMBean() {
        if (this.dataCollection.getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
            this.deactivateTimerTrigger();
        }
        if (this.dataCollection.getDataCollectionType() == DataCollection.TRIGGERED_BY_RESOURCE || this.dataCollection.getDataCollectionType() == DataCollection.PUSHED_BY_RESOURCE) {
            this.deregisterFromRuntimeMBean();
        }
    }

    private IMonitorNode navigateToLastExistingMonitorNode(Vector pathVector) {
        IMonitorNode monitorNode = monitorObjectFactory.getRootNode();
        Iterator it = ((AbstractList)pathVector).iterator();
        String firstElement = (String)it.next();
        it.remove();
        while (it.hasNext()) {
            String pathElement = (String)it.next();
            IMonitorNode lastExistingMonitorNode = monitorNode;
            if ((monitorNode = monitorNode.subNodeWithName(pathElement)) == null) {
                monitorNode = lastExistingMonitorNode;
                break;
            }
            it.remove();
        }
        return monitorNode;
    }

    private IMonitorNode constructSimpleMonitorNodes(IMonitorNode monitorNode, Vector pathVector) {
        int i = 0;
        while (i < pathVector.size() - 1) {
            String monitorName = (String)pathVector.get(i);
            try {
                monitorNode = monitorObjectFactory.createSimpleMonitorNode(monitorName, monitorNode);
            }
            catch (InvalidNameException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        return monitorNode;
    }

    private void registerToMonitorNode() {
        if (this.monitorNode == null) {
            LOCATION.errorT("Cannot register monitor " + this.myObjectName + " to its monitor node");
            return;
        }
        ((IAttributeMonitorNode)this.monitorNode).registerNodeListener((IMonitorNodeListener)this);
    }

    protected abstract void createMonitorNode(MonitorInstallationInfo var1) throws InvalidNameException;

    protected abstract void activateTimerTrigger();

    protected abstract void collectAndStoreMonitoringData();

    protected abstract void tryToCollectAndStoreMonitoringData();

    protected abstract void updateMonitoringData(AttributeChangeNotification var1);

    protected void echo(String text) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
        }
    }

    protected void echoNL(String text) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
        }
    }

    public Vector getAttributeMapping() {
        return this.attributeMappings;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        location = Location.getLocation((String)"com.sap.engine.services.monitor.mbeans");
    }
}

