/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.ILongMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.ILongMonitor;
import com.sap.engine.services.monitor.mbeans.LongMonitorMBean;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import java.util.Enumeration;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class LongMonitor
extends PerformanceMonitor
implements LongMonitorMBean,
ILongMonitor {
    public LongMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IThresholds thresholds = null;
        try {
            thresholds = this.getThresholds(installInfo);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in thresholds.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.monitorNode = Monitor.monitorObjectFactory.createLongMonitorNode(installInfo.getName(), installInfo.getParentNode(), thresholds);
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the LongMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        try {
            long longVal = this.collectMonitoringData();
            this.storeMonitoringData(longVal);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        try {
            long longVal = this.collectMonitoringData();
            this.storeMonitoringData(longVal);
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("Value")) {
            long longVal = (Long)notification.getNewValue();
            this.storeMonitoringData(longVal);
        }
    }

    public long getValue() {
        return ((ILongMonitorNode)this.monitorNode).getValue();
    }

    public long getMaxValue() {
        return ((ILongMonitorNode)this.monitorNode).getMaxValue();
    }

    public long getMinValue() {
        return ((ILongMonitorNode)this.monitorNode).getMinValue();
    }

    public void setValue(long value) {
        ((ILongMonitorNode)this.monitorNode).setValue(value);
    }

    private long collectMonitoringData() throws JMException {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("Value")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
        }
        if (mBeanResult == null) {
            Monitor.location.warningT("Return NULL as a result from the MBean server for a monitor with name[" + this.myObjectName);
            return 0L;
        }
        return (Long)mBeanResult;
    }

    private void storeMonitoringData(long longVal) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the long monitor node with path [" + this.getPath() + "] is: [" + longVal + "]");
        }
        ((ILongMonitorNode)this.monitorNode).setValue(longVal);
    }
}

