/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.IIntegerMonitor;
import com.sap.engine.services.monitor.mbeans.IntegerMonitorMBean;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import java.util.Enumeration;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class IntegerMonitor
extends PerformanceMonitor
implements IntegerMonitorMBean,
IIntegerMonitor {
    public IntegerMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IThresholds thresholds = null;
        try {
            thresholds = this.getThresholds(installInfo);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in thresholds.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.monitorNode = Monitor.monitorObjectFactory.createIntegerMonitorNode(installInfo.getName(), installInfo.getParentNode(), thresholds);
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the IntegerMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        try {
            int integerVal = this.collectMonitoringData();
            this.storeMonitoringData(integerVal);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        try {
            int integerVal = this.collectMonitoringData();
            this.storeMonitoringData(integerVal);
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("Value")) {
            int integerVal = (Integer)notification.getNewValue();
            this.storeMonitoringData(integerVal);
        }
    }

    public int getValue() {
        return ((IIntegerMonitorNode)this.monitorNode).getValue();
    }

    public int getMaxValue() {
        return ((IIntegerMonitorNode)this.monitorNode).getMaxValue().getExtremum();
    }

    public int getMinValue() {
        return ((IIntegerMonitorNode)this.monitorNode).getMinValue().getExtremum();
    }

    public void setValue(int value) {
        ((IIntegerMonitorNode)this.monitorNode).setValue(value);
    }

    private int collectMonitoringData() throws JMException {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("Value")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
        }
        return (Integer)mBeanResult;
    }

    private void storeMonitoringData(int integerVal) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the integer monitor node with path [" + this.getPath() + "] is: [" + integerVal + "]");
        }
        ((IIntegerMonitorNode)this.monitorNode).setValue(integerVal);
    }
}

