/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.mbeans.GenericConfigurationResourceMBean;
import com.sap.jmx.monitoring.api.ConfigurationList;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class GenericConfigurationResource
implements GenericConfigurationResourceMBean {
    private ConfigurationHandler configHandler;
    private SystemMonitor systemMonitor;
    boolean isServer = true;
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.mbeans.GenericConfigurationResource");

    public GenericConfigurationResource(ConfigurationHandler configHandler, SystemMonitor systemMonitor, boolean isServer) {
        this.configHandler = configHandler;
        this.systemMonitor = systemMonitor;
        this.isServer = isServer;
    }

    public ConfigurationList getConfigurationForPath(String path, String[] pattern) {
        ConfigurationList list = new ConfigurationList();
        try {
            Configuration config = this.configHandler.openConfiguration(path, 0);
            PropertySheet sheet = config.getPropertySheetInterface();
            PropertyEntry[] props = sheet.getAllPropertyEntries();
            int i = 0;
            while (i < props.length) {
                String value = null;
                value = props[i].isSecure() ? "**********" : props[i].getValue().toString();
                String key = props[i].getName();
                if (pattern == null) {
                    try {
                        list.setConfigurationParameter(key, value);
                    }
                    catch (IllegalArgumentException e) {
                        this.location.warningT("The pair with  key: " + key + " and value:" + value + " is not added to the configuration properties.Reason:" + e.getMessage());
                    }
                } else {
                    int j = 0;
                    while (j < pattern.length) {
                        if (key.equals(pattern[j])) {
                            try {
                                list.setConfigurationParameter(key, value);
                            }
                            catch (IllegalArgumentException e) {
                                this.location.warningT("The pair with  key: " + key + " and value:" + value + " is not added to the configuration properties.Reason:" + e.getMessage());
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            config.close();
        }
        catch (Exception e) {
            this.location.errorT(Util.getStackTraceAsString(e));
        }
        return list;
    }

    public ConfigurationList getConfigurationForServiceName(String serviceName, String[] pattern) {
        ConfigurationList list = new ConfigurationList();
        ServiceMonitor serv = this.systemMonitor.getService(serviceName);
        Properties props = serv.getProperties();
        if (props != null) {
            Enumeration keys = ((Hashtable)props).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                if (pattern == null) {
                    try {
                        list.setConfigurationParameter(key, value);
                    }
                    catch (IllegalArgumentException e) {
                        this.location.warningT("The pair with  key: " + key + " and value:" + value + " is not added to the configuration properties.Reason:" + e.getMessage());
                    }
                    continue;
                }
                int j = 0;
                while (j < pattern.length) {
                    if (key.equals(pattern[j])) {
                        try {
                            list.setConfigurationParameter(key, value);
                        }
                        catch (IllegalArgumentException e) {
                            this.location.warningT("The pair with  key: " + key + " and value:" + value + " is not added to the configuration properties.Reason:" + e.getMessage());
                        }
                    }
                    ++j;
                }
            }
        }
        return list;
    }
}

