/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.FrequencyMonitorMBean;
import com.sap.engine.services.monitor.mbeans.IFrequencyMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import java.util.Enumeration;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class FrequencyMonitor
extends PerformanceMonitor
implements FrequencyMonitorMBean,
IFrequencyMonitor {
    public FrequencyMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IThresholds thresholds = null;
        try {
            thresholds = this.getThresholds(installInfo);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in thresholds.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.monitorNode = Monitor.monitorObjectFactory.createFrequencyMonitorNode(installInfo.getName(), installInfo.getParentNode(), thresholds);
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the FrequencyMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("ReportedEvents")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            try {
                mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
                this.storeMonitoringData((Integer)mBeanResult);
            }
            catch (JMException ex) {
                this.removeOnConfigured();
            }
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("ReportedEvents")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            try {
                mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
                this.storeMonitoringData((Integer)mBeanResult);
            }
            catch (JMException ex) {
                Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
                Monitor.location.infoT(Util.getStackTraceAsString(ex));
            }
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("ReportedEvents")) {
            int reportedEvents = (Integer)notification.getNewValue();
            this.storeMonitoringData(reportedEvents);
        }
    }

    public double getFrequency() {
        return ((IFrequencyMonitorNode)this.monitorNode).getFrequency();
    }

    public double getMaxFrequency() {
        return ((IFrequencyMonitorNode)this.monitorNode).getMaxFreqency();
    }

    public double getMinFrequency() {
        return ((IFrequencyMonitorNode)this.monitorNode).getMinFrequency();
    }

    public void reportEvents(int number) {
        ((IFrequencyMonitorNode)this.monitorNode).reportEvents(number);
    }

    private void storeMonitoringData(int reportedEvents) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the frequency monitor node with path [" + this.getPath() + "] is: [" + reportedEvents + "]");
        }
        ((IFrequencyMonitorNode)this.monitorNode).reportEvents(reportedEvents);
    }
}

