/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IDurationMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.DurationMonitorMBean;
import com.sap.engine.services.monitor.mbeans.IDurationMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import com.sap.jmx.monitoring.api.DurationValue;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class DurationMonitor
extends PerformanceMonitor
implements DurationMonitorMBean,
IDurationMonitor {
    public DurationMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IThresholds thresholds = null;
        try {
            thresholds = this.getThresholds(installInfo);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in thresholds.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.monitorNode = Monitor.monitorObjectFactory.createDurationMonitorNode(installInfo.getName(), installInfo.getParentNode(), thresholds);
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the DurationMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        try {
            Object mBeanResult = null;
            long totalNumberFromStartup = 0L;
            long totalTimeFromStartup = 0L;
            if (this.attributeMappings.size() == 1) {
                mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo());
                totalNumberFromStartup = ((DurationValue)mBeanResult).getTotalNumber();
                totalTimeFromStartup = ((DurationValue)mBeanResult).getTotalTime();
            } else if (this.attributeMappings.size() == 2) {
                MBeanCallInfo mBeanCallInfo1 = ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo();
                MBeanCallInfo mBeanCallInfo2 = ((AttributeMappingInfo)this.attributeMappings.get(1)).getMBeanCallInfo();
                if (((AttributeMappingInfo)this.attributeMappings.get(0)).getMonitorNodeAttributeName().equals("TotalNumberFromStartup")) {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalNumberFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalTimeFromStartup = (Long)mBeanResult;
                } else {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalNumberFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalTimeFromStartup = (Long)mBeanResult;
                }
            }
            this.storeMonitoringData(totalNumberFromStartup, totalTimeFromStartup);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        try {
            Object mBeanResult = null;
            long totalNumberFromStartup = 0L;
            long totalTimeFromStartup = 0L;
            if (this.attributeMappings.size() == 1) {
                mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo());
                totalNumberFromStartup = ((DurationValue)mBeanResult).getTotalNumber();
                totalTimeFromStartup = ((DurationValue)mBeanResult).getTotalTime();
            } else if (this.attributeMappings.size() == 2) {
                MBeanCallInfo mBeanCallInfo1 = ((AttributeMappingInfo)this.attributeMappings.get(0)).getMBeanCallInfo();
                MBeanCallInfo mBeanCallInfo2 = ((AttributeMappingInfo)this.attributeMappings.get(1)).getMBeanCallInfo();
                if (((AttributeMappingInfo)this.attributeMappings.get(0)).getMonitorNodeAttributeName().equals("TotalNumberFromStartup")) {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalNumberFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalTimeFromStartup = (Long)mBeanResult;
                } else {
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo2);
                    totalNumberFromStartup = (Long)mBeanResult;
                    mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo1);
                    totalTimeFromStartup = (Long)mBeanResult;
                }
            }
            this.storeMonitoringData(totalNumberFromStartup, totalTimeFromStartup);
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        DurationValue value = (DurationValue)notification.getNewValue();
        this.storeMonitoringData(value.getTotalNumber(), value.getTotalTime());
    }

    public long getTotalNumber() {
        return ((IDurationMonitorNode)this.monitorNode).getTotalNumber();
    }

    public long getTotalTime() {
        return ((IDurationMonitorNode)this.monitorNode).getTotalTime();
    }

    public double getCurrentDuration() {
        return ((IDurationMonitorNode)this.monitorNode).getCurrentDuration();
    }

    public double getAverageDuration() {
        return ((IDurationMonitorNode)this.monitorNode).getAverageDuration();
    }

    public void set(long totalNumber, long totalTime) {
        ((IDurationMonitorNode)this.monitorNode).set(totalNumber, totalTime);
    }

    private void storeMonitoringData(long totalNumberFromStartup, long totalTimeFromStartup) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the duration monitor node with path [" + this.getPath() + "] are total Number From Startup: [" + totalNumberFromStartup + "] and total Time From Startup: [" + totalTimeFromStartup + "]");
        }
        ((IDurationMonitorNode)this.monitorNode).set(totalNumberFromStartup, totalTimeFromStartup);
    }
}

