/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IPropertiesMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.ConfigurationMonitorMBean;
import com.sap.engine.services.monitor.mbeans.IConfigurationMonitor;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.jmx.monitoring.api.ConfigurationList;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;

public class ConfigurationMonitor
extends Monitor
implements ConfigurationMonitorMBean,
IConfigurationMonitor {
    public ConfigurationMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IPropertiesMonitorNode propertiesMonitorNode = Monitor.monitorObjectFactory.createConfigurationMonitorNode(installInfo.getName(), installInfo.getParentNode());
        this.monitorNode = propertiesMonitorNode;
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the ConfigurationMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        try {
            this.setConfigurationParameters((ConfigurationList)this.getMBeanResult());
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        try {
            this.setConfigurationParameters((ConfigurationList)this.getMBeanResult());
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "] at startup");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("Configuration")) {
            this.setConfigurationParameters((ConfigurationList)notification.getNewValue());
        }
    }

    public String[][] getConfigurationParameters() {
        return ((IPropertiesMonitorNode)this.monitorNode).getProperties();
    }

    public void setConfigurationParameters(ConfigurationList configurationList) {
        String[][] parameters = null;
        if (configurationList != null) {
            parameters = configurationList.getParameters();
        } else {
            Monitor.location.infoT("Cannot set new configuration list parameters because they are  NULL");
        }
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New values for the configuration monitor node with path [" + this.getPath() + "] :");
            if (parameters != null) {
                int i = 0;
                while (i < parameters.length) {
                    String row = "";
                    if (parameters[i] != null) {
                        int j = 0;
                        while (j < parameters[i].length) {
                            row = row + " [" + parameters[i][j] + "] ";
                            ++j;
                        }
                        Monitor.location.infoT(row);
                    }
                    ++i;
                }
            } else {
                Monitor.location.infoT("New values for the configuration monitor node with path [" + this.getPath() + "] :null");
            }
        }
        ((IPropertiesMonitorNode)this.monitorNode).setProperties(parameters);
    }
}

