/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.ICacheMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.CacheMonitorMBean;
import com.sap.engine.services.monitor.mbeans.ICacheMonitor;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import javax.management.AttributeChangeNotification;

public class CacheMonitor
extends PerformanceMonitor
implements CacheMonitorMBean,
ICacheMonitor {
    public CacheMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the CacheMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
    }

    protected void tryToCollectAndStoreMonitoringData() {
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("currentUsage")) {
            long currentUsage = (Long)notification.getNewValue();
            this.storeCurrentUsage(currentUsage);
        } else if (monitorAttribute.equals("maxSize")) {
            long maxSize = (Long)notification.getNewValue();
            this.storeMaxSize(maxSize);
        }
    }

    public long getCurrentUsage() {
        return ((ICacheMonitorNode)this.monitorNode).getCurrentUsage();
    }

    public double getCurrentUsageInPercent() {
        return ((ICacheMonitorNode)this.monitorNode).getCurrentUsageInPercent();
    }

    public long getMaxSize() {
        return ((ICacheMonitorNode)this.monitorNode).getMaxSize();
    }

    public long getMaxUsage() {
        return ((ICacheMonitorNode)this.monitorNode).getMaxUsage();
    }

    public double getMaxUsageInPercent() {
        return ((ICacheMonitorNode)this.monitorNode).getMaxUsageInPercent();
    }

    public void setCurrentUsage(long size) {
        ((ICacheMonitorNode)this.monitorNode).setCurrentUsage(size);
    }

    public void setMaxSize(long maxSize) {
        ((ICacheMonitorNode)this.monitorNode).setMaxSize(maxSize);
    }

    private void storeMaxSize(long maxSize) {
        ((ICacheMonitorNode)this.monitorNode).setMaxSize(maxSize);
    }

    private void storeCurrentUsage(long currentUsage) {
        ((ICacheMonitorNode)this.monitorNode).setCurrentUsage(currentUsage);
    }
}

