/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.mbeans;

import com.sap.engine.library.monitor.IAvailabilityMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.AvailabilityMonitorMBean;
import com.sap.engine.services.monitor.mbeans.IAvailabilityMonitor;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.MonitorException;
import com.sap.engine.services.monitor.mbeans.PerformanceMonitor;
import java.util.Enumeration;
import javax.management.AttributeChangeNotification;
import javax.management.JMException;
import javax.management.ObjectName;

public class AvailabilityMonitor
extends PerformanceMonitor
implements AvailabilityMonitorMBean,
IAvailabilityMonitor {
    public AvailabilityMonitor(MonitorInstallationInfo installInfo) throws InvalidNameException {
        this.constructMonitor(installInfo);
    }

    protected void createMonitorNode(MonitorInstallationInfo installInfo) throws InvalidNameException {
        IThresholds thresholds = null;
        try {
            thresholds = this.getThresholds(installInfo);
        }
        catch (com.sap.engine.library.monitor.MonitorException ex) {
            Monitor.location.errorT("Could not create monitor node [" + this.monitorNode.getPath() + "]. Error in thresholds.");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.monitorNode = Monitor.monitorObjectFactory.createAvailabilityMonitorNode(installInfo.getName(), installInfo.getParentNode(), thresholds);
    }

    protected void activateTimerTrigger() {
        try {
            this.activateTimerTrigger("Trigger the AvailabilityMonitor");
        }
        catch (MonitorException ex) {
            Monitor.location.warningT("Timer triger could not be activated");
            Monitor.location.infoT(Util.getStackTraceAsString((Exception)((Object)ex)));
        }
        this.isTimerTriggerActive = true;
    }

    protected void collectAndStoreMonitoringData() {
        try {
            boolean availabilityVal = this.collectMonitoringData();
            this.storeMonitoringData(availabilityVal);
        }
        catch (JMException ex) {
            this.removeOnConfigured();
        }
    }

    protected void tryToCollectAndStoreMonitoringData() {
        try {
            boolean availabilityVal = this.collectMonitoringData();
            this.storeMonitoringData(availabilityVal);
        }
        catch (JMException ex) {
            Monitor.location.infoT("Data could not be collected for monitor [" + this.monitorNode.getPath() + "]");
            Monitor.location.infoT(Util.getStackTraceAsString(ex));
        }
    }

    protected void updateMonitoringData(AttributeChangeNotification notification) {
        String monitorAttribute = this.getMonitorAttribute(notification);
        if (monitorAttribute.equals("Value")) {
            boolean availability = (Boolean)notification.getNewValue();
            this.storeMonitoringData(availability);
        }
    }

    public boolean getValue() {
        return ((IAvailabilityMonitorNode)this.monitorNode).getValue();
    }

    public double getAvailability() {
        return ((IAvailabilityMonitorNode)this.monitorNode).getAvailability();
    }

    public long getTimeOnTrueInMilliseconds() {
        return ((IAvailabilityMonitorNode)this.monitorNode).getTimeOnTrueInMilliseconds();
    }

    public long getTimeOnFalseInMilliseconds() {
        return ((IAvailabilityMonitorNode)this.monitorNode).getTimeOnFalseInMilliseconds();
    }

    public void setValue(boolean value) {
        ((IAvailabilityMonitor)this.monitorNode).setValue(value);
    }

    private boolean collectMonitoringData() throws JMException {
        Enumeration enumeration = null;
        AttributeMappingInfo attributMappingInfo = null;
        MBeanCallInfo mBeanCallInfo = null;
        Object mBeanResult = null;
        String monitorNodeAttributeName = null;
        enumeration = this.attributeMappings.elements();
        while (enumeration.hasMoreElements()) {
            attributMappingInfo = (AttributeMappingInfo)enumeration.nextElement();
            monitorNodeAttributeName = attributMappingInfo.getMonitorNodeAttributeName();
            if (!monitorNodeAttributeName.equals("Value")) continue;
            mBeanCallInfo = attributMappingInfo.getMBeanCallInfo();
            mBeanResult = Monitor.getMBeanResult(this.mbs, (ObjectName)this.observedObjects.get(0), mBeanCallInfo);
        }
        return (Boolean)mBeanResult;
    }

    private void storeMonitoringData(boolean availabilityVal) {
        if (Monitor.location.beInfo()) {
            Monitor.location.infoT("New value for the availability monitor node with path [" + this.getPath() + "] is: [" + availabilityVal + "]");
        }
        ((IAvailabilityMonitorNode)this.monitorNode).setValue(availabilityVal);
    }
}

