/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.install;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.IObjectMonitorNode;
import com.sap.engine.library.monitor.ISummaryMonitorNode;
import com.sap.engine.library.monitor.InvalidNameException;
import com.sap.engine.library.monitor.NotUniqueNameException;
import com.sap.engine.library.monitor.impl0.AttributeMonitorNode;
import com.sap.engine.library.monitor.impl0.ObjectMonitorNode;
import com.sap.engine.library.monitor.impl0.SummaryMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.common.StandardMBeanWrapper;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.install.InstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.StateMonitorInstallationInfo;
import com.sap.engine.services.monitor.install.TableMonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AvailabilityMonitor;
import com.sap.engine.services.monitor.mbeans.AvailabilityMonitorMBean;
import com.sap.engine.services.monitor.mbeans.CacheMonitor;
import com.sap.engine.services.monitor.mbeans.CacheMonitorMBean;
import com.sap.engine.services.monitor.mbeans.ConfigurationMonitor;
import com.sap.engine.services.monitor.mbeans.ConfigurationMonitorMBean;
import com.sap.engine.services.monitor.mbeans.DurationMonitor;
import com.sap.engine.services.monitor.mbeans.DurationMonitorMBean;
import com.sap.engine.services.monitor.mbeans.FrequencyMonitor;
import com.sap.engine.services.monitor.mbeans.FrequencyMonitorMBean;
import com.sap.engine.services.monitor.mbeans.IMonitor;
import com.sap.engine.services.monitor.mbeans.IMonitorFactory;
import com.sap.engine.services.monitor.mbeans.IntegerMonitor;
import com.sap.engine.services.monitor.mbeans.IntegerMonitorMBean;
import com.sap.engine.services.monitor.mbeans.LongMonitor;
import com.sap.engine.services.monitor.mbeans.LongMonitorMBean;
import com.sap.engine.services.monitor.mbeans.MonitorFactory;
import com.sap.engine.services.monitor.mbeans.PoolMonitor;
import com.sap.engine.services.monitor.mbeans.PoolMonitorMBean;
import com.sap.engine.services.monitor.mbeans.QualityRateMonitor;
import com.sap.engine.services.monitor.mbeans.QualityRateMonitorMBean;
import com.sap.engine.services.monitor.mbeans.StateMonitor;
import com.sap.engine.services.monitor.mbeans.StateMonitorMBean;
import com.sap.engine.services.monitor.mbeans.StringMonitor;
import com.sap.engine.services.monitor.mbeans.StringMonitorMBean;
import com.sap.engine.services.monitor.mbeans.TableMonitor;
import com.sap.engine.services.monitor.mbeans.TableMonitorMBean;
import com.sap.engine.services.monitor.mbeans.VariableStateMonitor;
import com.sap.engine.services.monitor.mbeans.VariableStateMonitorMBean;
import com.sap.engine.services.monitor.mbeans.VersionMonitor;
import com.sap.engine.services.monitor.mbeans.VersionMonitorMBean;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.swing.tree.MutableTreeNode;

public class MonitorInstaller {
    private static final int SUMMARY = 0;
    private static final int OBJECT = 1;
    private static final int ATTRIBUTE = 2;
    private static final int TEMPLATE = 3;
    private static IMonitorObjectFactory monitorNodeFactory;
    private static IMonitorFactory monitorFactory;
    private static Location location;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$StringMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$StateMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$VariableStateMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$TableMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$VersionMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$ConfigurationMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$AvailabilityMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$IntegerMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$LongMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$FrequencyMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$QualityRateMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$DurationMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$CacheMonitorMBean;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$PoolMonitorMBean;

    public static void initialize() {
        monitorNodeFactory = com.sap.engine.library.monitor.MonitorFactory.createMonitorObjectFactory();
        monitorFactory = new MonitorFactory();
    }

    public static void destroy() {
        monitorNodeFactory = null;
        monitorFactory = null;
    }

    public static IMonitorNode getKernelRootNode() {
        return monitorNodeFactory.getRootNode().subNodeWithName("Kernel");
    }

    public static IMonitorNode getServicesRootNode() {
        return monitorNodeFactory.getRootNode().subNodeWithName("Services");
    }

    public static IMonitorNode getApplicationsRootNode() {
        return monitorNodeFactory.getRootNode().subNodeWithName("Applications");
    }

    public static IMonitorNode getPerformanceRootNode() {
        return monitorNodeFactory.getRootNode().subNodeWithName("Performance");
    }

    public static IMonitorNode getChildNode(IMonitorNode parentNode, String childName) {
        return parentNode.subNodeWithName(childName);
    }

    public static IMonitorNode installSummary(InstallationInfo installInfo) {
        IMonitorNode summaryNode = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 0)) {
                summaryNode = monitorNodeFactory.createSummaryMonitorNode(installInfo.getName(), installInfo.getParentNode());
                MonitorInstaller.configureMonitorNode(summaryNode, installInfo);
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        String name = installInfo.getName();
        MappingTreeNode m_parent = null;
        try {
            m_parent = MonitorServiceRuntime.getMappedTree().search(summaryNode.getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(name, summaryNode, m_parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install summary with name :[" + name + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return summaryNode;
    }

    public static IMonitorNode installObject(InstallationInfo installInfo) {
        IMonitorNode objectNode = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 1)) {
                objectNode = monitorNodeFactory.createObjectMonitorNode(installInfo.getName(), installInfo.getParentNode());
                MonitorInstaller.configureMonitorNode(objectNode, installInfo);
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        String name = installInfo.getName();
        IMonitorNode parent = objectNode.getParent();
        MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
        MappingTreeNode m_parent = null;
        try {
            m_parent = m_tree.search(parent);
            MonitorServiceRuntime.getMappedTree().addSubnode(name, objectNode, m_parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install object with name :[" + name + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return objectNode;
    }

    public static StringMonitor installTextMonitor(MonitorInstallationInfo installInfo) {
        StringMonitor textMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                textMonitor = (StringMonitor)monitorFactory.createStringMonitor(installInfo);
                MonitorInstaller.registerMonitor(textMonitor);
                textMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(textMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), textMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install text monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return textMonitor;
    }

    public static StateMonitor installStateMonitor(StateMonitorInstallationInfo installInfo) {
        StateMonitor stateMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                stateMonitor = (StateMonitor)monitorFactory.createStateMonitor(installInfo);
                MonitorInstaller.registerMonitor(stateMonitor);
                stateMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(stateMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), stateMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install state monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return stateMonitor;
    }

    public static VariableStateMonitor installVariableStateMonitor(StateMonitorInstallationInfo installInfo) {
        VariableStateMonitor varStateMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                varStateMonitor = (VariableStateMonitor)monitorFactory.createVariableStateMonitor(installInfo);
                MonitorInstaller.registerMonitor(varStateMonitor);
                varStateMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(varStateMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), varStateMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install variable state monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return varStateMonitor;
    }

    public static TableMonitor installTableMonitor(TableMonitorInstallationInfo installInfo) {
        TableMonitor tableMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                tableMonitor = (TableMonitor)monitorFactory.createTableMonitor(installInfo);
                MonitorInstaller.registerMonitor(tableMonitor);
                tableMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(tableMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), tableMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install table monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return tableMonitor;
    }

    public static VersionMonitor installVersionMonitor(MonitorInstallationInfo installInfo) {
        VersionMonitor versionMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                versionMonitor = monitorFactory.createVersionMonitor(installInfo);
                MonitorInstaller.registerMonitor(versionMonitor);
                versionMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(versionMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), versionMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install version monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return versionMonitor;
    }

    public static ConfigurationMonitor installConfigurationMonitor(MonitorInstallationInfo installInfo) {
        ConfigurationMonitor configurationMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                configurationMonitor = monitorFactory.createConfigurationMonitor(installInfo);
                MonitorInstaller.registerMonitor(configurationMonitor);
                configurationMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(configurationMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), configurationMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install configuration monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return configurationMonitor;
    }

    public static AvailabilityMonitor installAvailabilityMonitor(MonitorInstallationInfo installInfo) {
        AvailabilityMonitor availabilityMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                availabilityMonitor = (AvailabilityMonitor)monitorFactory.createAvailabilityMonitor(installInfo);
                MonitorInstaller.registerMonitor(availabilityMonitor);
                availabilityMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(availabilityMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), availabilityMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install availability monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return availabilityMonitor;
    }

    public static IntegerMonitor installIntegerMonitor(MonitorInstallationInfo installInfo) {
        IntegerMonitor integerMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                integerMonitor = (IntegerMonitor)monitorFactory.createIntegerMonitor(installInfo);
                MonitorInstaller.registerMonitor(integerMonitor);
                integerMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(integerMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), integerMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install integer monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return integerMonitor;
    }

    public static LongMonitor installLongMonitor(MonitorInstallationInfo installInfo) {
        LongMonitor longMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                longMonitor = (LongMonitor)monitorFactory.createLongMonitor(installInfo);
                MonitorInstaller.registerMonitor(longMonitor);
                longMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(longMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), longMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install long monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return longMonitor;
    }

    public static FrequencyMonitor installFrequencyMonitor(MonitorInstallationInfo installInfo) {
        FrequencyMonitor frequencyMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                frequencyMonitor = (FrequencyMonitor)monitorFactory.createFrequencyMonitor(installInfo);
                MonitorInstaller.registerMonitor(frequencyMonitor);
                frequencyMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(frequencyMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), frequencyMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install frequency monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return frequencyMonitor;
    }

    public static QualityRateMonitor installQualityRateMonitor(MonitorInstallationInfo installInfo) {
        QualityRateMonitor qualityRateMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                qualityRateMonitor = (QualityRateMonitor)monitorFactory.createQualityRateMonitor(installInfo);
                MonitorInstaller.registerMonitor(qualityRateMonitor);
                qualityRateMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(qualityRateMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), qualityRateMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install quality rate monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return qualityRateMonitor;
    }

    public static DurationMonitor installDurationMonitor(MonitorInstallationInfo installInfo) {
        DurationMonitor durationMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 2)) {
                durationMonitor = (DurationMonitor)monitorFactory.createDurationMonitor(installInfo);
                MonitorInstaller.registerMonitor(durationMonitor);
                durationMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(durationMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), durationMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install duration monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return durationMonitor;
    }

    public static CacheMonitor installCacheMonitor(MonitorInstallationInfo installInfo) {
        CacheMonitor cacheMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 3)) {
                cacheMonitor = (CacheMonitor)monitorFactory.createCacheMonitor(installInfo);
                MonitorInstaller.registerMonitor(cacheMonitor);
                cacheMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(cacheMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), cacheMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install cache monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return cacheMonitor;
    }

    public static PoolMonitor installPoolMonitor(MonitorInstallationInfo installInfo) {
        PoolMonitor poolMonitor = null;
        try {
            if (MonitorInstaller.isConsistent(installInfo.getParentNode(), 3)) {
                poolMonitor = (PoolMonitor)monitorFactory.createPoolMonitor(installInfo);
                MonitorInstaller.registerMonitor(poolMonitor);
                poolMonitor.start();
            }
        }
        catch (NotUniqueNameException ex) {
            MonitorInstaller.traceWarning(installInfo.getParentNode(), installInfo.getName());
        }
        catch (InvalidNameException ex1) {
            MonitorInstaller.traceError(installInfo.getParentNode(), installInfo.getName());
        }
        MappingTreeNode parent = null;
        try {
            parent = MonitorServiceRuntime.getMappedTree().search(poolMonitor.getMonitorNode().getParent());
            MonitorServiceRuntime.getMappedTree().addSubnode(installInfo.getName(), poolMonitor.getMonitorNode(), parent, null, false);
        }
        catch (NullPointerException npe) {
            location.errorT("Cannot install pool monitor with name :[" + installInfo.getName() + "]");
            location.infoT(Util.getStackTraceAsString(npe));
        }
        return poolMonitor;
    }

    public static void uninstallSummary(ISummaryMonitorNode topDeletedNode, Boolean isRemovedFromCcmsPersistence) {
        MonitorInstaller.uninstallSimpleNode((IMonitorNode)topDeletedNode, isRemovedFromCcmsPersistence);
    }

    public static void uninstallObject(IObjectMonitorNode topDeletedNode, Boolean isCcmsPersistenceRemoved) {
        MonitorInstaller.uninstallSimpleNode((IMonitorNode)topDeletedNode, isCcmsPersistenceRemoved);
    }

    public static void uninstallAttribute(IMonitorNode parentNode, String monitorName, Boolean isCcmsPersistenceRemoved) {
        try {
            monitorNodeFactory.uninstallMonitorNode(parentNode.subNodeWithName(monitorName), isCcmsPersistenceRemoved);
        }
        catch (Exception exc) {
            location.errorT("Cannot unistall monitor node with name :[" + monitorName + "] and path [" + parentNode.getPath() + "]");
            location.infoT(Util.getStackTraceAsString(exc));
            System.out.println("");
            exc.printStackTrace();
        }
    }

    public static void uninstallMonitors(String monitorOwner, Boolean isCcmsPersistenceRemoved) {
        MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
        MonitorInstaller.uninstallMonitors(m_tree.getRootNode(), monitorOwner, isCcmsPersistenceRemoved);
        MonitorServiceRuntime.deleteTemplates(monitorOwner);
    }

    public static void uninstallMonitors(MappingTreeNode m_node, String monitorOwner, Boolean isCcmsPersistenceRemoved) {
        if (m_node == null) {
            location.errorT("initial parameters of uninstallMonitorNode method");
            return;
        }
        Object[] childNodes = MonitorInstaller.getObjectArray(m_node.children());
        int i = 0;
        while (i < childNodes.length) {
            MonitorInstaller.uninstallMonitors((MappingTreeNode)childNodes[i], monitorOwner, isCcmsPersistenceRemoved);
            ++i;
        }
        IMonitorNode node = m_node.getMonitorObject();
        if (m_node.children() != null && m_node.getChildCount() == 0 && node.getOwner() != null && node.getOwner().equals(monitorOwner)) {
            MappingTreeNode parent = MonitorServiceRuntime.getMappedTree().search(node.getParent());
            location.infoT("Remove node:" + node.getPath() + " ,with owner: " + node.getOwner());
            parent.remove((MutableTreeNode)m_node);
            monitorNodeFactory.uninstallMonitorNode(node, isCcmsPersistenceRemoved);
        }
    }

    public static void configureMonitorNode(IMonitorNode node, InstallationInfo installInfo) {
        SimpleConfigurationGroup group = installInfo.getConfigurationGroup();
        Description description = group.getDescription();
        String descriptionID = description.getID();
        String descriptionText = description.getText();
        String globalConfigurationGroupName = group.getGlobalConfigurationGroupName();
        String nodeOwner = installInfo.getApplicationName() == null ? "" : installInfo.getApplicationName();
        node.setVolatile(installInfo.isVolatile());
        node.setDescriptionID(descriptionID);
        node.setDescription(descriptionText);
        node.setOwner(nodeOwner);
        node.setConfigurationGroup(globalConfigurationGroupName);
        node.setPath();
        node.setConfigured(true);
        if (location.beInfo()) {
            location.infoT("Configure monitor node with path [" + node.getPath() + "]");
        }
        node.addToCcms();
    }

    public static void configureMonitorNode(IMonitorNode node, InstallationInfo installInfo, DataCollection dataCollection) {
        if (dataCollection != null) {
            if (dataCollection.getCollectPeriod() != null) {
                node.setPeriodUnit(dataCollection.getCollectPeriod().getUnit());
                node.setPeriodValue(dataCollection.getCollectPeriod().getValue());
            }
            node.setReactOnCollectionFailure(dataCollection.getReactOnCollectionFailure());
            node.setDataCollectionType(dataCollection.getDataCollectionType());
        }
        MonitorInstaller.configureMonitorNode(node, installInfo);
    }

    private static Object[] getObjectArray(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] array = new Object[vector.size()];
        int i = 0;
        while (i < vector.size()) {
            array[i] = vector.get(i);
            ++i;
        }
        return array;
    }

    private static boolean isConsistent(IMonitorNode parentNode, int childType) {
        if (parentNode instanceof SummaryMonitorNode) {
            switch (childType) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            return false;
        }
        if (parentNode instanceof ObjectMonitorNode) {
            switch (childType) {
                case 2: {
                    return true;
                }
            }
            return false;
        }
        if (parentNode instanceof AttributeMonitorNode) {
            return false;
        }
        return false;
    }

    private static ObjectName registerMonitor(IMonitor monitor) {
        String treePath = monitor.getPath();
        ObjectName monitorName = MonitorInstaller.getMonitorName(treePath);
        if (monitor instanceof StringMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$StringMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$StringMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.StringMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$StringMonitorMBean, monitorName);
        } else if (monitor instanceof StateMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$StateMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$StateMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.StateMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$StateMonitorMBean, monitorName);
        } else if (monitor instanceof VariableStateMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$VariableStateMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$VariableStateMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.VariableStateMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$VariableStateMonitorMBean, monitorName);
        } else if (monitor instanceof TableMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$TableMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$TableMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.TableMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$TableMonitorMBean, monitorName);
        } else if (monitor instanceof VersionMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$VersionMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$VersionMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.VersionMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$VersionMonitorMBean, monitorName);
        } else if (monitor instanceof ConfigurationMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$ConfigurationMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$ConfigurationMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.ConfigurationMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$ConfigurationMonitorMBean, monitorName);
        } else if (monitor instanceof AvailabilityMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$AvailabilityMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$AvailabilityMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.AvailabilityMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$AvailabilityMonitorMBean, monitorName);
        } else if (monitor instanceof IntegerMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$IntegerMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$IntegerMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.IntegerMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$IntegerMonitorMBean, monitorName);
        } else if (monitor instanceof LongMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$LongMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$LongMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.LongMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$LongMonitorMBean, monitorName);
        } else if (monitor instanceof FrequencyMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$FrequencyMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$FrequencyMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.FrequencyMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$FrequencyMonitorMBean, monitorName);
        } else if (monitor instanceof QualityRateMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$QualityRateMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$QualityRateMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.QualityRateMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$QualityRateMonitorMBean, monitorName);
        } else if (monitor instanceof DurationMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$DurationMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$DurationMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.DurationMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$DurationMonitorMBean, monitorName);
        } else if (monitor instanceof CacheMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$CacheMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$CacheMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.CacheMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$CacheMonitorMBean, monitorName);
        } else if (monitor instanceof PoolMonitorMBean) {
            MonitorInstaller.registerMonitor(monitor, class$com$sap$engine$services$monitor$mbeans$PoolMonitorMBean == null ? (class$com$sap$engine$services$monitor$mbeans$PoolMonitorMBean = MonitorInstaller.class$("com.sap.engine.services.monitor.mbeans.PoolMonitorMBean")) : class$com$sap$engine$services$monitor$mbeans$PoolMonitorMBean, monitorName);
        }
        return monitorName;
    }

    private static void registerMonitor(Object monitorInstance, Class monitorIF, ObjectName monitorName) {
        MBeanServer mbs = MonitorServiceRuntime.getMBeanServer();
        if (location.beInfo()) {
            location.infoT("Register in MBean Server monitor with name [" + monitorName + "]");
        }
        if (mbs != null) {
            try {
                mbs.registerMBean(new StandardMBeanWrapper(monitorInstance, monitorIF), monitorName);
            }
            catch (JMException ex) {
                location.errorT("Cannot register MBean with name [" + monitorName + "] to MBean server");
                location.infoT(Util.getStackTraceAsString(ex));
            }
        }
    }

    private static ObjectName getMonitorName(String monitorName) {
        ObjectName monitorObjName = null;
        try {
            monitorObjName = ObjectNameFactory.getNameForMonitorPerNode((String)ObjectName.quote(monitorName), null, null);
        }
        catch (MalformedObjectNameException ex) {
            location.errorT("Wrong Object name for monitor with name: [" + monitorName + "]");
            location.infoT(Util.getStackTraceAsString(ex));
        }
        return monitorObjName;
    }

    private static void uninstallSimpleNode(IMonitorNode topDeletedNode, Boolean isRemovedFromCcmsPersistence) {
        block2: {
            try {
                MappedTree m_tree = MonitorServiceRuntime.getMappedTree();
                m_tree.removeSubnode(m_tree.search(topDeletedNode));
                monitorNodeFactory.uninstallMonitorNode(topDeletedNode, isRemovedFromCcmsPersistence);
            }
            catch (Exception exc) {
                if (topDeletedNode.getName().trim().equals("Root")) break block2;
                location.errorT("Cannot unistall monitor node with name :[" + topDeletedNode.getName() + "]");
                location.infoT(Util.getStackTraceAsString(exc));
            }
        }
    }

    private static void traceWarning(IMonitorNode parent, String name) {
        if (parent != null) {
            location.warningT("NotUniqueNameException: name [" + name + "] is not an unique name for a monitor node for a parent with path [" + parent.getPath() + "]");
        } else {
            location.warningT("NotUniqueNameException: name [" + name + "] is not an unique name for a monitor node.The parent is null.");
        }
    }

    private static void traceError(IMonitorNode parent, String name) {
        if (parent != null) {
            location.errorT("InvalidNameException: name [" + name + "] is not a valid name for a monitor node for a parent with path [" + parent.getPath() + "]");
        } else {
            location.errorT("InvalidNameException: name [" + name + "] is not a valid name for a monitor node.The parent is null.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        location = Location.getLocation((String)"com.sap.engine.services.monitor.install.MonitorInstaller");
    }
}

