/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.install;

import com.sap.engine.interfaces.monitor.CallInfo;
import com.sap.engine.interfaces.monitor.MonitorContext;
import com.sap.engine.library.monitor.IAttributeMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.IObjectMonitorNode;
import com.sap.engine.library.monitor.ISummaryMonitorNode;
import com.sap.engine.library.monitor.MonitorFactory;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.config.AvailabilityConfigurationGroup;
import com.sap.engine.services.monitor.config.CacheConfigurationGroup;
import com.sap.engine.services.monitor.config.ConfigConfigurationGroup;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.DurationConfigurationGroup;
import com.sap.engine.services.monitor.config.FrequencyConfigurationGroup;
import com.sap.engine.services.monitor.config.History;
import com.sap.engine.services.monitor.config.IntegerConfigurationGroup;
import com.sap.engine.services.monitor.config.LongConfigurationGroup;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.config.PoolConfigurationGroup;
import com.sap.engine.services.monitor.config.QualityRateConfigurationGroup;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.config.TableConfigurationGroup;
import com.sap.engine.services.monitor.config.TextConfigurationGroup;
import com.sap.engine.services.monitor.config.Thresholds;
import com.sap.engine.services.monitor.config.VersionConfigurationGroup;
import com.sap.engine.services.monitor.install.InstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstaller;
import com.sap.engine.services.monitor.install.StateMonitorInstallationInfo;
import com.sap.engine.services.monitor.install.TableMonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Template;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MonitorContextImpl
implements MonitorContext {
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.install.MonitorContextImpl");
    private MonitorServiceRuntime msr;

    public MonitorContextImpl(MonitorServiceRuntime msr) {
        this.msr = msr;
    }

    public boolean installSummaryNode(String parentPath, String name, String configurationGroup) {
        return this.installSummaryNode(parentPath, name, configurationGroup, false);
    }

    public boolean installSummaryNode(String parentPath, String name, String configurationGroup, boolean volatility) {
        IMonitorNode parent = this.getNode(parentPath);
        Hashtable table = MonitorServiceRuntime.getConfigurationGroups();
        SimpleConfigurationGroup group = (SimpleConfigurationGroup)table.get(configurationGroup);
        if (parent != null && group != null) {
            InstallationInfo installInfo = new InstallationInfo(name, parent, group);
            installInfo.setVolatile(volatility);
            if (MonitorInstaller.installSummary(installInfo) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean installObjectNode(String parentPath, String name, String configurationGroup) {
        return this.installObjectNode(parentPath, name, configurationGroup, false);
    }

    public boolean installObjectNode(String parentPath, String name, String configurationGroup, boolean volatility) {
        IMonitorNode parent = this.getNode(parentPath);
        Hashtable table = MonitorServiceRuntime.getConfigurationGroups();
        SimpleConfigurationGroup group = (SimpleConfigurationGroup)table.get(configurationGroup);
        if (parent != null && group != null) {
            InstallationInfo installInfo = new InstallationInfo(name, parent, group);
            installInfo.setVolatile(volatility);
            if (MonitorInstaller.installObject(installInfo) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean installMonitor(int monitorType, String parentPath, String name, String configurationGroup, String monitoredResourceName, String monitoredResourceType, Vector callInfos) {
        return this.installMonitor(monitorType, parentPath, name, configurationGroup, monitoredResourceName, monitoredResourceType, callInfos, false);
    }

    public boolean installMonitor(int monitorType, String parentPath, String name, String configurationGroup, String monitoredResourceName, String monitoredResourceType, Vector callInfos, boolean volatility) {
        IMonitorNode parent = this.getNode(parentPath);
        Hashtable configurationGroups = MonitorServiceRuntime.getConfigurationGroups();
        Vector attributeMappings = this.constructAttributeMappings(callInfos);
        switch (monitorType) {
            case 7: {
                ConfigConfigurationGroup group = (ConfigConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installConfigurationMonitor(installInfo) == null) break;
                return true;
            }
            case 6: {
                VersionConfigurationGroup group = (VersionConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installVersionMonitor(installInfo) == null) break;
                return true;
            }
            case 8: {
                AvailabilityConfigurationGroup group = (AvailabilityConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installAvailabilityMonitor(installInfo) == null) break;
                return true;
            }
            case 14: {
                CacheConfigurationGroup group = (CacheConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installCacheMonitor(installInfo) == null) break;
                return true;
            }
            case 11: {
                FrequencyConfigurationGroup group = (FrequencyConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installFrequencyMonitor(installInfo) == null) break;
                return true;
            }
            case 9: {
                IntegerConfigurationGroup group = (IntegerConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installIntegerMonitor(installInfo) == null) break;
                return true;
            }
            case 10: {
                LongConfigurationGroup group = (LongConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installLongMonitor(installInfo) == null) break;
                return true;
            }
            case 15: {
                PoolConfigurationGroup group = (PoolConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installPoolMonitor(installInfo) == null) break;
                return true;
            }
            case 12: {
                QualityRateConfigurationGroup group = (QualityRateConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installQualityRateMonitor(installInfo) == null) break;
                return true;
            }
            case 3: {
                TextConfigurationGroup group = (TextConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installTextMonitor(installInfo) == null) break;
                return true;
            }
            case 13: {
                DurationConfigurationGroup group = (DurationConfigurationGroup)configurationGroups.get(configurationGroup);
                if (parent == null || group == null) break;
                MonitorInstallationInfo installInfo = new MonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings);
                installInfo.setVolatile(volatility);
                if (MonitorInstaller.installDurationMonitor(installInfo) == null) break;
                return true;
            }
        }
        return false;
    }

    private Vector constructAttributeMappings(Vector callInfos) {
        if (callInfos == null) {
            return null;
        }
        int size = callInfos.size();
        Vector<AttributeMappingInfo> attributeMappings = new Vector<AttributeMappingInfo>(size);
        int i = 0;
        while (i < size) {
            AttributeMappingInfo attrInfo;
            MBeanCallInfo mBeanInfo;
            CallInfo callInfo = (CallInfo)callInfos.get(i);
            if (!callInfo.getAttributeName().trim().equals("")) {
                mBeanInfo = new MBeanCallInfo(callInfo.getAttributeName());
                attrInfo = new AttributeMappingInfo(callInfo.getMappingAttributeName(), mBeanInfo);
                attributeMappings.add(attrInfo);
            } else {
                mBeanInfo = new MBeanCallInfo(callInfo.getOperationName(), callInfo.getParameters(), callInfo.getSignatures());
                attrInfo = new AttributeMappingInfo(callInfo.getMappingAttributeName(), mBeanInfo);
                attributeMappings.add(attrInfo);
            }
            ++i;
        }
        return attributeMappings;
    }

    public boolean installStateMonitor(String parentPath, String name, String configurationGroup, String monitoredResourceName, String monitoredResourceType, Vector callInfos, boolean explicitGreen) {
        return this.installStateMonitor(parentPath, name, configurationGroup, monitoredResourceName, monitoredResourceType, callInfos, explicitGreen, false);
    }

    public boolean installStateMonitor(String parentPath, String name, String configurationGroup, String monitoredResourceName, String monitoredResourceType, Vector callInfos, boolean explicitGreen, boolean volatility) {
        IMonitorNode parent = this.getNode(parentPath);
        Hashtable table = MonitorServiceRuntime.getConfigurationGroups();
        StateConfigurationGroup group = (StateConfigurationGroup)table.get(configurationGroup);
        Vector attributeMappings = this.constructAttributeMappings(callInfos);
        if (parent != null && group != null) {
            StateMonitorInstallationInfo installInfo = new StateMonitorInstallationInfo(name, parent, (SimpleConfigurationGroup)group, monitoredResourceName, monitoredResourceType, attributeMappings, explicitGreen);
            installInfo.setVolatile(volatility);
            StateConfigurationGroup stateGroup = (StateConfigurationGroup)installInfo.getConfigurationGroup();
            if (!(stateGroup.getGreenStates() != null && stateGroup.getGreenStates().length != 0 || stateGroup.getYellowStates() != null && stateGroup.getYellowStates().length != 0 || stateGroup.getRedStates() != null && stateGroup.getRedStates().length != 0) ? MonitorInstaller.installVariableStateMonitor(installInfo) != null : MonitorInstaller.installStateMonitor(installInfo) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean installTableMonitor(String parentPath, String name, String configurationGroup, String monitoredResourceName, String monitoredResourceType, Vector callInfos, String filename) {
        return this.installTableMonitor(parentPath, name, configurationGroup, monitoredResourceName, monitoredResourceType, callInfos, filename, false);
    }

    public boolean installTableMonitor(String parentPath, String name, String configurationGroup, String monitoredResourceName, String monitoredResourceType, Vector callInfos, String filename, boolean volatility) {
        IMonitorNode parent = this.getNode(parentPath);
        Hashtable table = MonitorServiceRuntime.getConfigurationGroups();
        TableConfigurationGroup group = (TableConfigurationGroup)table.get(configurationGroup);
        Vector attributeMappings = this.constructAttributeMappings(callInfos);
        if (parent != null && group != null) {
            TableMonitorInstallationInfo installInfo = new TableMonitorInstallationInfo(name, parent, group, monitoredResourceName, monitoredResourceType, attributeMappings, filename);
            installInfo.setVolatile(volatility);
            if (MonitorInstaller.installTableMonitor(installInfo) != null) {
                return true;
            }
        }
        return false;
    }

    public void setTemplateParams(String templateName, Object templateParams) {
        Hashtable templates = MonitorServiceRuntime.getMonitorTemplates();
        Template temlate = (Template)templates.get(templateName);
        if (temlate != null) {
            temlate.dynamicallySuppliedData(templateParams);
        }
    }

    public void uninstallMonitorsByPath(String path, boolean isRemovedFromCcmsPersistence) {
        IMonitorNode node = this.getNode(path);
        if (node != null) {
            if (node instanceof ISummaryMonitorNode) {
                MonitorInstaller.uninstallSummary((ISummaryMonitorNode)node, new Boolean(isRemovedFromCcmsPersistence));
            } else if (node instanceof IObjectMonitorNode) {
                MonitorInstaller.uninstallObject((IObjectMonitorNode)node, new Boolean(isRemovedFromCcmsPersistence));
            } else if (node instanceof IAttributeMonitorNode) {
                MonitorInstaller.uninstallAttribute(node.getParent(), node.getName(), new Boolean(isRemovedFromCcmsPersistence));
            }
        }
    }

    public void uninstallMonitorsByOwner(String monitorOwner, boolean isRemovedFromCcmsPersistence) {
        MonitorInstaller.uninstallMonitors("application " + monitorOwner, new Boolean(isRemovedFromCcmsPersistence));
    }

    private IMonitorNode getNode(String parentPath) {
        IMonitorNode node = null;
        try {
            IMonitorObjectFactory factory = MonitorFactory.createMonitorObjectFactory();
            node = factory.getRootNode();
            StringTokenizer tok = new StringTokenizer(parentPath, "/");
            tok.nextToken();
            while (tok.hasMoreTokens()) {
                String nodeName = tok.nextToken();
                node = node.subNodeWithName(nodeName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return node;
    }

    public boolean createSimpleConfigGroup(String groupName, String descriptionID, String descriptionTxt) {
        Description description;
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        if ((description = this.createDescription(groupName, descriptionID, descriptionTxt)) != null) {
            SimpleConfigurationGroup group = new SimpleConfigurationGroup(groupName, description, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        return false;
    }

    public boolean createConfigConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        if (dataCollection != null && description != null) {
            ConfigConfigurationGroup group = new ConfigConfigurationGroup(groupName, description, dataCollection, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createTextConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        if (dataCollection != null && description != null) {
            TextConfigurationGroup group = new TextConfigurationGroup(groupName, description, dataCollection, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createVersionConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        if (dataCollection != null && description != null) {
            VersionConfigurationGroup group = new VersionConfigurationGroup(groupName, description, dataCollection, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createTableConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, Vector columnNames) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        if (dataCollection != null && description != null) {
            TableConfigurationGroup group = new TableConfigurationGroup(groupName, description, dataCollection, columnNames, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createDurationConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow, int historyAveragingMode, String unit, int alertRelevantValueType) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        Thresholds thresholds = this.createThresholds(groupName, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
        History history = new History(historyAveragingMode);
        if (dataCollection != null && description != null && thresholds != null && history != null) {
            DurationConfigurationGroup group = new DurationConfigurationGroup(groupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createFrequencyConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow, int historyAveragingMode, String unit, int alertRelevantValueType) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        Thresholds thresholds = this.createThresholds(groupName, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
        History history = new History(historyAveragingMode);
        if (dataCollection != null && description != null && thresholds != null && history != null) {
            FrequencyConfigurationGroup group = new FrequencyConfigurationGroup(groupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createIntegerConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow, int historyAveragingMode, String unit, int alertRelevantValueType) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        Thresholds thresholds = this.createThresholds(groupName, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
        History history = new History(historyAveragingMode);
        if (dataCollection != null && description != null && thresholds != null && history != null) {
            IntegerConfigurationGroup group = new IntegerConfigurationGroup(groupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createLongConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow, int historyAveragingMode, String unit, int alertRelevantValueType) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        Thresholds thresholds = this.createThresholds(groupName, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
        History history = new History(historyAveragingMode);
        if (dataCollection != null && description != null && thresholds != null && history != null) {
            LongConfigurationGroup group = new LongConfigurationGroup(groupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createQualityRateConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow, int historyAveragingMode, String unit, int alertRelevantValueType) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        Thresholds thresholds = this.createThresholds(groupName, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
        History history = new History(historyAveragingMode);
        if (dataCollection != null && description != null && thresholds != null && history != null) {
            QualityRateConfigurationGroup group = new QualityRateConfigurationGroup(groupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createStateConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, String[] greenStates, String[] yellowStates, String[] redStates, String unit, int alertMode) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        if (dataCollection != null && description != null) {
            StateConfigurationGroup group = new StateConfigurationGroup(groupName, description, dataCollection, greenStates, yellowStates, redStates, alertMode, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    public boolean createAvailabilityConfigurationGroup(String groupName, String descriptionID, String descriptionTxt, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow, int historyaAveragingMode, String unit, int alertRelevantValueType) {
        if (groupName.length() > 40) {
            this.location.warningT("The group is with name more that 40 characters [" + groupName + "] and it won't be sent to CCMS");
        }
        if (descriptionID.length() > 30) {
            this.location.warningT("The group with name [" + groupName + "] has a descriptionID more that 30 characters, the description won't be sent to CCMS");
        }
        DataCollection dataCollection = this.createDataCollection(groupName, dataCollectionType, periodValue, periodUnit, reactOnCollectionFailure);
        Description description = this.createDescription(groupName, descriptionID, descriptionTxt);
        Thresholds thresholds = this.createThresholds(groupName, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
        History history = new History(historyaAveragingMode);
        if (dataCollection != null && description != null && thresholds != null && history != null) {
            AvailabilityConfigurationGroup group = new AvailabilityConfigurationGroup(groupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, "monitor ", false);
            this.msr.getMonitorConfigurationHandler().customizeGroup(group);
            return true;
        }
        this.location.errorT("Cannot create a group with name [" + groupName + "]");
        return false;
    }

    private DataCollection createDataCollection(String groupName, int dataCollectionType, int periodValue, int periodUnit, int reactOnCollectionFailure) {
        DataCollection dataCollection = null;
        if (dataCollectionType == DataCollection.POLLED_BY_MONITOR) {
            dataCollection = new DataCollection(dataCollectionType, new Period(periodValue, periodUnit), reactOnCollectionFailure);
        } else if (dataCollectionType == DataCollection.PUSHED_BY_RESOURCE) {
            dataCollection = new DataCollection(dataCollectionType, null, reactOnCollectionFailure);
        } else {
            this.location.errorT("Data Collection type for the group with name [" + groupName + "] must be POLLED_BY_MONITOR or PUSHED_BY_RESOURCE ");
        }
        return dataCollection;
    }

    private Description createDescription(String groupName, String descriptionID, String descriptionTxt) {
        if (descriptionID == null || descriptionID.equals("")) {
            this.location.errorT("DescriptionID for the group with name[ " + groupName + "] cannot be null or empty string. ");
            return null;
        }
        if (descriptionTxt == null || descriptionTxt.equals("")) {
            this.location.warningT("Description text for the group with name[ " + groupName + "] is empty.");
            return new Description(descriptionID, "");
        }
        return new Description(descriptionID, descriptionTxt);
    }

    private Thresholds createThresholds(String groupName, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow) {
        Thresholds thresholds = new Thresholds(green2Yellow, yellow2Red, red2Yellow, yellow2Green);
        return thresholds;
    }

    public boolean deleteConfigurationGroup(String groupName) {
        return this.msr.getMonitorConfigurationHandler().deleteGroup(groupName);
    }
}

