/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.services.monitor.gui.viewers.CellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class TableViewer
extends JPanel {
    DefaultTableModel m_tableModel = new DefaultTableModel();
    CellRenderer cellRenderer = new CellRenderer();
    JTable table = new JTable();
    String[] columnNames = null;

    public TableViewer(String[] columnNames, String[][] data) {
        this.columnNames = columnNames;
        this.initTable(data);
    }

    public TableViewer(String[] columnNames) {
        this.columnNames = columnNames;
        this.initTable(null);
    }

    private void initTable(String[][] data) {
        this.m_tableModel = new DefaultTableModel();
        this.table.setEnabled(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        this.setLayout(new GridBagLayout());
        this.table.setRowSelectionAllowed(false);
        this.table.setModel(this.m_tableModel);
        JScrollPane tableScrolPanel = new JScrollPane(this.table);
        tableScrolPanel.setAutoscrolls(true);
        this.add((Component)tableScrolPanel, new GridBagConstraints(0, 1, 3, 1, 0.5, 0.5, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        if (data != null) {
            this.m_tableModel.setDataVector(data, this.columnNames);
        }
        if (this.columnNames.length > 2) {
            this.table.setAutoResizeMode(0);
        } else {
            this.setCellRenderer();
        }
    }

    public void update(String[][] data) {
        int rowCount = this.m_tableModel.getRowCount();
        int i = 0;
        while (i < rowCount) {
            this.m_tableModel.removeRow(0);
            ++i;
        }
        if (data != null) {
            int i2 = 0;
            while (i2 < data.length) {
                this.m_tableModel.addRow(data[i2]);
                ++i2;
            }
        }
    }

    public void update(String[][] entries, String[] headers) {
        this.m_tableModel.setDataVector(entries, this.columnNames);
    }

    private void setCellRenderer() {
        int i = 0;
        while (i < this.m_tableModel.getColumnCount()) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setCellRenderer(this.cellRenderer);
            ++i;
        }
    }
}

