/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IQualityRateMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.viewers.PerformanceMonitorNodeViewer;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class QualityRateMonitorNodeViewer
extends PerformanceMonitorNodeViewer {
    JPanel specPanel;
    JLabel currentHitRateLabel;
    JLabel currentHitRateValue;
    JLabel averageHitRateLabel;
    JLabel averageHitRateValue;
    JLabel totalTriesLabel;
    JLabel totalTriesValue;
    JLabel successfullTriesLabel;
    JLabel succesfullTriesValue;

    public QualityRateMonitorNodeViewer(Frame mainFrame, IQualityRateMonitorNode node, MonitorPanelLogical mPanel) {
        super(mainFrame, (IMonitorNode)node, mPanel);
        this.init();
    }

    private void init() {
        this.currentHitRateLabel = new JLabel("Current hit rate:  ");
        this.currentHitRateValue = new JLabel();
        this.averageHitRateLabel = new JLabel("Average hit rate since startup:  ");
        this.averageHitRateValue = new JLabel();
        this.totalTriesLabel = new JLabel("Total tries: ");
        this.totalTriesValue = new JLabel();
        this.successfullTriesLabel = new JLabel("Total hits: ");
        this.succesfullTriesValue = new JLabel();
        this.averageHitRateLabel.setFont(MonitorUtils.LABEL_FONT);
        this.averageHitRateValue.setFont(MonitorUtils.LABEL_FONT);
        this.totalTriesLabel.setFont(MonitorUtils.LABEL_FONT);
        this.totalTriesValue.setFont(MonitorUtils.LABEL_FONT);
        this.successfullTriesLabel.setFont(MonitorUtils.LABEL_FONT);
        this.succesfullTriesValue.setFont(MonitorUtils.LABEL_FONT);
        this.specPanel = new JPanel();
        this.specPanel.setLayout(new GridLayout(6, 2));
        this.specPanel.add(this.currentHitRateLabel);
        this.specPanel.add(this.currentHitRateValue);
        this.specPanel.add(this.averageHitRateLabel);
        this.specPanel.add(this.averageHitRateValue);
        this.specPanel.add(this.totalTriesLabel);
        this.specPanel.add(this.totalTriesValue);
        this.specPanel.add(this.successfullTriesLabel);
        this.specPanel.add(this.succesfullTriesValue);
    }

    public JPanel getSpecificPanel() {
        this.updateValues();
        return this.specPanel;
    }

    private void updateValues() {
        if (this.monitorNode.getHasReportedValue()) {
            this.currentHitRateValue.setText(MonitorUtils.formatDouble(((IQualityRateMonitorNode)this.monitorNode).getCurrentQualityRate() * 100.0) + " %");
            this.averageHitRateValue.setText(MonitorUtils.formatDouble(((IQualityRateMonitorNode)this.monitorNode).getAverageQualityRate() * 100.0) + " %");
        } else {
            this.currentHitRateValue.setText("No value has been reported yet");
            this.averageHitRateValue.setText("No value has been reported yet");
        }
        this.totalTriesValue.setText(((IQualityRateMonitorNode)this.monitorNode).getTotalTries() + "");
        this.succesfullTriesValue.setText(((IQualityRateMonitorNode)this.monitorNode).getSuccessfulTries() + "");
    }
}

