/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IPoolMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.viewers.PerformanceMonitorNodeViewer;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PoolMonitorNodeViewer
extends PerformanceMonitorNodeViewer {
    public PoolMonitorNodeViewer(Frame mainFrame, IPoolMonitorNode node, MonitorPanelLogical mPanel) {
        super(mainFrame, (IMonitorNode)node, mPanel);
    }

    public JPanel getSpecificPanel() {
        JPanel specPanel = new JPanel();
        JPanel specPanelLabels = new JPanel(new GridLayout(9, 1));
        JPanel specPanelData = new JPanel(new GridLayout(9, 1));
        double usageInPercent = 0.0;
        int maxPoolSize = ((IPoolMonitorNode)this.monitorNode).getMaxPoolSize();
        int currentUsedObjects = ((IPoolMonitorNode)this.monitorNode).getNumberOfCurrentUsedObjects();
        if (maxPoolSize != 0) {
            usageInPercent = 100.0 * (double)currentUsedObjects / (double)maxPoolSize;
        }
        specPanelLabels.add(new JLabel("Usage in Percent:"));
        specPanelData.add(new JLabel(MonitorUtils.formatDouble(usageInPercent) + MonitorUtils.UNIT_PERCENTAGE));
        specPanelLabels.add(new JLabel("Number of currently used objects:  "));
        specPanelData.add(new JLabel(currentUsedObjects + ""));
        specPanelLabels.add(new JLabel("Maximal number of used objects:  "));
        specPanelData.add(new JLabel(((IPoolMonitorNode)this.monitorNode).getMaxNumberOfCurrentUsedObjects() + ""));
        specPanelLabels.add(new JLabel("Minimal number of used objects:  "));
        specPanelData.add(new JLabel(((IPoolMonitorNode)this.monitorNode).getMinNumberOfCurrentUsedObjects() + ""));
        specPanelLabels.add(new JLabel("Current pool size:  "));
        specPanelData.add(new JLabel(((IPoolMonitorNode)this.monitorNode).getCurrentPoolSize() + ""));
        specPanelLabels.add(new JLabel("Minimal pool size:  "));
        specPanelData.add(new JLabel(((IPoolMonitorNode)this.monitorNode).getMinPoolSize() + ""));
        specPanelLabels.add(new JLabel("Initial pool size:  "));
        specPanelData.add(new JLabel(((IPoolMonitorNode)this.monitorNode).getInitialPoolSize() + ""));
        specPanelLabels.add(new JLabel("Maximal pool size:  "));
        specPanelData.add(new JLabel(maxPoolSize + ""));
        specPanelLabels.add(new JLabel("Pool incrementor size  "));
        specPanelData.add(new JLabel(((IPoolMonitorNode)this.monitorNode).getIncrementSize() + ""));
        specPanel.add(specPanelLabels);
        specPanel.add(specPanelData);
        return specPanel;
    }

    public String getUnit() {
        return MonitorUtils.UNIT_PERCENTAGE;
    }
}

