/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import java.awt.GridLayout;
import java.text.BreakIterator;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultipleRowLabel
extends JPanel {
    private static BreakIterator bi = BreakIterator.getLineInstance();
    protected int cols;
    protected int minRows;
    protected int align;
    protected String text;

    public MultipleRowLabel(String text) {
        this.cols = 40;
        this.minRows = 0;
        this.align = 2;
        this.text = null;
        this.setLayout(new GridLayout(0, 1));
        this.setText(text);
    }

    public MultipleRowLabel(String text, int cols) {
        this.cols = cols;
        this.minRows = 0;
        this.align = 2;
        this.text = null;
        this.setLayout(new GridLayout(0, 1));
        this.setText(text);
    }

    public void setMinRows(int rows) {
        this.minRows = rows;
        this.refresh();
    }

    public void setColumns(int cols) {
        this.cols = cols;
        this.refresh();
    }

    public void setAlignment(int align) {
        this.align = align;
        this.refresh();
    }

    public void setText(String text) {
        this.text = text;
        this.refresh();
    }

    protected void refresh() {
        this.removeAll();
        if (this.text == null) {
            return;
        }
        bi.setText(this.text);
        int rows = 0;
        int len = this.text.length();
        int beg = 0;
        while (beg < len) {
            int end;
            if (beg + this.cols >= len) {
                end = len;
            } else {
                end = bi.following(beg);
                if (end == -1 || end > beg + this.cols) {
                    end = beg + this.cols + 1;
                } else {
                    int x = end;
                    while (x != -1 && x < beg + this.cols + 2) {
                        end = x;
                        x = bi.next();
                    }
                }
            }
            int xnl = this.text.indexOf(10, beg);
            if (xnl > beg && xnl < end) {
                end = xnl;
            }
            this.add(new JLabel(this.text.substring(beg, end), this.align));
            beg = end;
            if (xnl == beg) {
                ++beg;
            }
            ++rows;
        }
        while (rows < this.minRows) {
            this.add(new JLabel(" "));
            ++rows;
        }
        this.revalidate();
    }
}

