/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.gui.viewers.TableViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MappingNodeViewer
extends JPanel {
    BorderLayout m_layout = new BorderLayout();
    JPanel m_namePanel = new JPanel();
    JLabel m_nameLabel = new JLabel("Name: ");
    JTextField m_nameText = new JTextField();
    JLabel m_pathLabel = new JLabel("Path: ");
    JTextField m_pathText = new JTextField();
    String[] header = new String[]{"Property", "Value"};
    TableViewer m_propertiesPanel;
    protected GridBagLayout m_namePanelLayout = new GridBagLayout();

    public MappingNodeViewer() {
        this.m_propertiesPanel = new TableViewer(this.header);
        this.setLayout(this.m_layout);
        this.m_namePanel.setLayout(this.m_namePanelLayout);
        this.m_nameText.setEditable(false);
        this.m_pathText.setEditable(false);
        this.m_namePanel.add((Component)this.m_nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_namePanel.add((Component)this.m_nameText, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_namePanel.add((Component)this.m_pathLabel, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_namePanel.add((Component)this.m_pathText, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_namePanel, "North");
        this.add((Component)this.m_propertiesPanel, "Center");
    }

    public void update(MappingTreeNode node) {
        String path = node.getMappingPath();
        if (path == null) {
            path = "";
        }
        this.m_pathText.setText(path);
        this.m_nameText.setText(node.getName());
        this.m_propertiesPanel.update(this.extractProperties(node), this.header);
        this.m_layout.layoutContainer(this);
        this.revalidate();
        this.repaint();
    }

    private String[][] extractProperties(MappingTreeNode node) {
        Properties p = node.getProperties();
        if (p == null) {
            return new String[0][2];
        }
        int len = ((Hashtable)p).size();
        String[][] result = new String[len][2];
        Enumeration e = ((Hashtable)p).keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String name;
            result[i][0] = name = (String)e.nextElement();
            result[i][1] = p.getProperty(name);
            ++i;
        }
        return result;
    }
}

