/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.viewers.MultipleRowLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class MainViewer
extends JPanel {
    public static final Insets INSETS = new Insets(3, 3, 3, 3);
    public JLabel generalInfoLabel;
    public JLabel actualDataLabel;
    public IMonitorNode monitorNode;
    MultipleRowLabel row;

    public MainViewer(IMonitorNode node) {
        this.monitorNode = node;
        this.enableEvents(64L);
        this.init();
    }

    public abstract JPanel getSpecificPanel();

    public abstract JPanel getButtonsPanel();

    private void init() {
        this.setLayout(new GridBagLayout());
        this.row = new MultipleRowLabel("");
        this.generalInfoLabel = new JLabel("General Info:");
        this.actualDataLabel = new JLabel("Monitored Data:");
        this.generalInfoLabel.setFont(MonitorUtils.TITLE_FONT);
        this.actualDataLabel.setFont(MonitorUtils.TITLE_FONT);
    }

    public void update(IMonitorNode newNode) {
        this.monitorNode = newNode;
        this.removeAll();
        this.createPanels();
        this.validate();
    }

    private void createPanels() {
        this.add((Component)this.generalInfoLabel, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS_LARGE_TITLE, 0, 0));
        this.add((Component)this.getGeneralPanel(), new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS_LARGE, 0, 0));
        if (this.monitorNode.getTyp() != 0) {
            this.add((Component)this.actualDataLabel, new GridBagConstraints(0, 4, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS_LARGE_TITLE, 0, 0));
            this.add((Component)this.getSpecificPanel(), new GridBagConstraints(0, 5, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS_LARGE, 0, 0));
            this.add((Component)this.getButtonsPanel(), new GridBagConstraints(0, 6, 2, 1, 0.1, 0.0, 10, 0, MonitorUtils.INSETS_LARGE, 0, 0));
        }
    }

    public JPanel getGeneralPanel() {
        JPanel generalPanel = new JPanel(new GridBagLayout());
        this.row.setText(this.monitorNode.getDescription());
        generalPanel.add((Component)new JLabel("Name: "), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)new JLabel(this.monitorNode.getName()), new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)new JLabel("Description: "), new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)this.row, new GridBagConstraints(1, 1, 1, 2, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        if (this.monitorNode.getTyp() != 0) {
            generalPanel.add((Component)new JLabel("Type:"), new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
            generalPanel.add((Component)new JLabel(MonitorUtils.getStringType(this.monitorNode.getTyp(), this.monitorNode)), new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        }
        generalPanel.add((Component)new JLabel("Configuration group:"), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)new JLabel(this.monitorNode.getConfigurationGroup()), new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)new JLabel("Creation date: "), new GridBagConstraints(0, 5, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)new JLabel(this.monitorNode.getCreationTime().toString()), new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)new JLabel("Last change date: "), new GridBagConstraints(0, 6, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        generalPanel.add((Component)new JLabel(this.monitorNode.getLastChangeDate().toString()), new GridBagConstraints(1, 6, 1, 1, 0.1, 0.0, 17, 0, INSETS, 0, 0));
        return generalPanel;
    }
}

