/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.viewers.PerformanceMonitorNodeViewer;
import java.awt.Frame;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IntegerMonitorNodeViewer
extends PerformanceMonitorNodeViewer {
    static final SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yy ' ' hh:mm a");

    public IntegerMonitorNodeViewer(Frame mainFrame, IIntegerMonitorNode monitorNode, MonitorPanelLogical mPanel) {
        super(mainFrame, (IMonitorNode)monitorNode, mPanel);
    }

    public JPanel getSpecificPanel() {
        JLabel value;
        JPanel specPanel = new JPanel();
        JLabel valueLabel = new JLabel("Value:  ");
        if (this.monitorNode.getHasReportedValue()) {
            value = new JLabel(((IIntegerMonitorNode)this.monitorNode).getValue() + " " + ((IIntegerMonitorNode)this.monitorNode).getUnit());
        } else {
            IIntegerMonitorNode cfr_ignored_0 = (IIntegerMonitorNode)this.monitorNode;
            value = new JLabel("No value has been reported yet");
        }
        JLabel emptyLabel = new JLabel("");
        JLabel maxValueLabel = new JLabel("Maximum:  ");
        JLabel maxValue = new JLabel(((IIntegerMonitorNode)this.monitorNode).getMaxValue().getExtremum() + "");
        JLabel timeMaxValue = new JLabel();
        JLabel minValueLabel = new JLabel("Minimum:  ");
        JLabel minValue = new JLabel(((IIntegerMonitorNode)this.monitorNode).getMinValue().getExtremum() + "");
        JLabel timeMinValue = new JLabel();
        maxValueLabel.setFont(MonitorUtils.LABEL_FONT);
        maxValue.setFont(MonitorUtils.LABEL_FONT);
        timeMaxValue.setFont(MonitorUtils.LABEL_FONT);
        minValueLabel.setFont(MonitorUtils.LABEL_FONT);
        minValue.setFont(MonitorUtils.LABEL_FONT);
        timeMinValue.setFont(MonitorUtils.LABEL_FONT);
        specPanel.setLayout(new GridLayout(3, 3));
        specPanel.add(valueLabel);
        specPanel.add(value);
        specPanel.add(emptyLabel);
        specPanel.add(maxValueLabel);
        specPanel.add(maxValue);
        long maxValueLong = ((IIntegerMonitorNode)this.monitorNode).getMaxValue().getTimeStamp();
        if (maxValueLong != 0L) {
            timeMaxValue.setText(formatter.format(new Date(maxValueLong)));
        }
        specPanel.add(timeMaxValue);
        specPanel.add(minValueLabel);
        specPanel.add(minValue);
        long minValueLong = ((IIntegerMonitorNode)this.monitorNode).getMinValue().getTimeStamp();
        if (minValueLong != 0L) {
            timeMinValue.setText(formatter.format(new Date(minValueLong)));
        }
        specPanel.add(timeMinValue);
        return specPanel;
    }
}

