/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IPerformanceHistory;
import com.sap.engine.library.monitor.IPerformanceMonitorNode;
import com.sap.engine.library.monitor.ITimedSerializable;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class HistoryDialog
extends JDialog {
    static final int HISTORY_MINUTES_COUNT = 15;
    static final int HISTORY_QUARTERS_COUNT = 12;
    static final int HISTORY_HOURS_COUNT = 23;
    static final int TIME_COLUMN_INDEX = 0;
    static final int VALUE_COLUMN_INDEX = 1;
    static final int INITIAL_DIALOG_POSITION = 200;
    static final int MAX_DIALOG_POSITION = 500;
    static final int DIALOG_POSITION_OFFSET = 20;
    static final String LABEL_BUTTON_HISTORY_DIALOG = "History";
    static final Dimension TABLE_DIMENSION = new Dimension(220, 300);
    static final String DIALOG_TITLE = "Data History of ";
    static final Object[] TABLE_COLUMN_NAMES = new Object[]{"Date & Time", "Value"};
    static final SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yy ' ' hh:mm a");
    String unit = "";
    static int X_LOCATION = 100;
    static int Y_LOCATION = 100;

    public HistoryDialog(Frame mainFrame, IPerformanceMonitorNode node, Properties props, String unit) {
        super(mainFrame, DIALOG_TITLE + node.getName(), false);
        this.unit = unit;
        ((Component)this).setLocation(X_LOCATION, Y_LOCATION);
        this.setNewWindowLocation();
        this.pack();
    }

    void setNewWindowLocation() {
        X_LOCATION = X_LOCATION < 500 ? (X_LOCATION += 20) : 200;
        Y_LOCATION = Y_LOCATION < 500 ? (Y_LOCATION += 20) : 200;
    }

    protected JPanel createHistoryTablePanel(IPerformanceHistory history) {
        int history_hours_start_index;
        int history_quarters_start_index;
        ITimedSerializable tempTimeValue;
        JPanel tablePanel = new JPanel();
        JTable table = new JTable();
        Object[][] data = new Object[50][2];
        DefaultTableModel m_tableModel = new DefaultTableModel();
        String tempValue = "";
        int row = 0;
        long lastTimeStamp = 0L;
        int i = 0;
        while (i < 15) {
            tempTimeValue = history.getMinuteHistory()[i];
            if (tempTimeValue == null || tempTimeValue.getTimeStamp() == 0L) break;
            lastTimeStamp = tempTimeValue.getTimeStamp();
            data[row][0] = formatter.format(new Date(tempTimeValue.getTimeStamp()));
            tempValue = MonitorUtils.formatSerializable(tempTimeValue.getValue());
            data[row][1] = this.addUnit(tempValue);
            ++row;
            ++i;
        }
        data[row][0] = "";
        data[row++][1] = "";
        int i2 = history_quarters_start_index = HistoryDialog.findIndexForTimeStamp(lastTimeStamp, history.getQuarterHistory());
        while (i2 < 12) {
            tempTimeValue = history.getQuarterHistory()[i2];
            if (tempTimeValue == null || tempTimeValue.getTimeStamp() == 0L) break;
            lastTimeStamp = tempTimeValue.getTimeStamp();
            data[row][0] = formatter.format(new Date(tempTimeValue.getTimeStamp()));
            tempValue = MonitorUtils.formatSerializable(tempTimeValue.getValue());
            data[row][1] = this.addUnit(tempValue);
            ++row;
            ++i2;
        }
        data[row][0] = "";
        data[row++][1] = "";
        int i3 = history_hours_start_index = HistoryDialog.findIndexForTimeStamp(lastTimeStamp, history.getHourHistory());
        while (i3 < 23) {
            tempTimeValue = history.getHourHistory()[i3];
            if (tempTimeValue == null || tempTimeValue.getTimeStamp() == 0L) break;
            data[row][0] = formatter.format(new Date(tempTimeValue.getTimeStamp()));
            tempValue = MonitorUtils.formatSerializable(tempTimeValue.getValue());
            data[row][1] = this.addUnit(tempValue);
            ++row;
            ++i3;
        }
        m_tableModel.setDataVector(data, TABLE_COLUMN_NAMES);
        table.setEnabled(false);
        table.setModel(m_tableModel);
        table.setPreferredScrollableViewportSize(TABLE_DIMENSION);
        table.setBackground(MonitorUtils.TABLE_COLOR_NOT_EDITABLE);
        table.sizeColumnsToFit(0);
        table.sizeColumnsToFit(1);
        tablePanel.setLayout(new GridLayout(1, 1));
        tablePanel.add(new JScrollPane(table));
        return tablePanel;
    }

    private static int findIndexForTimeStamp(long timestamp, ITimedSerializable[] array) {
        int index = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i].getTimeStamp() < timestamp) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public String addUnit(String value) {
        if (value == null) {
            return "-";
        }
        if (value.trim().equals("-".trim())) {
            return value;
        }
        return value + " " + this.unit;
    }
}

