/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.viewers.PerformanceMonitorNodeViewer;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FrequencyMonitorNodeViewer
extends PerformanceMonitorNodeViewer {
    JLabel maxFrequencyLabel;
    JLabel maxFrequencyValue;
    JLabel minFrequencyLabel;
    JLabel minFrequencyValue;

    public FrequencyMonitorNodeViewer(Frame mainFrame, IFrequencyMonitorNode node, MonitorPanelLogical mPanel) {
        super(mainFrame, (IMonitorNode)node, mPanel);
    }

    public JPanel getSpecificPanel() {
        JLabel frequencyValue;
        JPanel specPanel = new JPanel();
        JLabel frequencyLabel = new JLabel("Frequency:  ");
        if (this.monitorNode.getHasReportedValue()) {
            frequencyValue = new JLabel(MonitorUtils.formatDouble(((IFrequencyMonitorNode)this.monitorNode).getFrequency()) + " 1/s");
        } else {
            IFrequencyMonitorNode cfr_ignored_0 = (IFrequencyMonitorNode)this.monitorNode;
            frequencyValue = new JLabel("No value has been reported yet");
        }
        this.maxFrequencyLabel = new JLabel("Maximal frequency:  ");
        this.maxFrequencyValue = new JLabel(MonitorUtils.formatDouble(((IFrequencyMonitorNode)this.monitorNode).getMaxFreqency()));
        this.minFrequencyLabel = new JLabel("Minimal frequency:  ");
        this.minFrequencyValue = new JLabel(MonitorUtils.formatDouble(((IFrequencyMonitorNode)this.monitorNode).getMinFrequency()));
        this.maxFrequencyLabel.setFont(MonitorUtils.LABEL_FONT);
        this.maxFrequencyValue.setFont(MonitorUtils.LABEL_FONT);
        this.minFrequencyLabel.setFont(MonitorUtils.LABEL_FONT);
        this.minFrequencyValue.setFont(MonitorUtils.LABEL_FONT);
        specPanel.setLayout(new GridLayout(3, 2));
        specPanel.add(frequencyLabel);
        specPanel.add(frequencyValue);
        specPanel.add(this.maxFrequencyLabel);
        specPanel.add(this.maxFrequencyValue);
        specPanel.add(this.minFrequencyLabel);
        specPanel.add(this.minFrequencyValue);
        return specPanel;
    }
}

