/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IDurationMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.viewers.PerformanceMonitorNodeViewer;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DurationMonitorNodeViewer
extends PerformanceMonitorNodeViewer {
    private JPanel panel;
    private JLabel labelForCurrentAverageTime;
    private JLabel labelForCurrentDuration;
    private JLabel labelForAverageTimeSinceStartup;
    private JLabel labelForAverageDurationValue;
    private JLabel labelForTotalNumber;
    private JLabel labelForTotalNumberValue;
    private JLabel labelForTotalTime;
    private JLabel labelForTotalTimeValue;

    public DurationMonitorNodeViewer(Frame mainFrame, IDurationMonitorNode node, MonitorPanelLogical mPanel) {
        super(mainFrame, (IMonitorNode)node, mPanel);
        this.init();
    }

    private void init() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(4, 2));
        this.labelForCurrentAverageTime = new JLabel("current average time: ");
        this.labelForCurrentDuration = new JLabel();
        this.labelForAverageTimeSinceStartup = new JLabel("average time since startup:  ");
        this.labelForAverageDurationValue = new JLabel();
        this.labelForTotalNumber = new JLabel("total number: ");
        this.labelForTotalNumberValue = new JLabel();
        this.labelForTotalTime = new JLabel("total time: ");
        this.labelForTotalTimeValue = new JLabel();
        this.labelForAverageTimeSinceStartup.setFont(MonitorUtils.LABEL_FONT);
        this.labelForAverageDurationValue.setFont(MonitorUtils.LABEL_FONT);
        this.labelForTotalNumber.setFont(MonitorUtils.LABEL_FONT);
        this.labelForTotalNumberValue.setFont(MonitorUtils.LABEL_FONT);
        this.labelForTotalTime.setFont(MonitorUtils.LABEL_FONT);
        this.labelForTotalTimeValue.setFont(MonitorUtils.LABEL_FONT);
        this.panel.add(this.labelForCurrentAverageTime);
        this.panel.add(this.labelForCurrentDuration);
        this.panel.add(this.labelForAverageTimeSinceStartup);
        this.panel.add(this.labelForAverageDurationValue);
        this.panel.add(this.labelForTotalNumber);
        this.panel.add(this.labelForTotalNumberValue);
        this.panel.add(this.labelForTotalTime);
        this.panel.add(this.labelForTotalTimeValue);
    }

    private void updateValues() {
        this.labelForCurrentDuration.setText(MonitorUtils.round(((IDurationMonitorNode)this.monitorNode).getCurrentDuration()) + " " + ((IDurationMonitorNode)this.monitorNode).getUnit());
        this.labelForAverageDurationValue.setText(MonitorUtils.round(((IDurationMonitorNode)this.monitorNode).getAverageDuration()) + " " + ((IDurationMonitorNode)this.monitorNode).getUnit());
        this.labelForTotalNumberValue.setText(((IDurationMonitorNode)this.monitorNode).getTotalNumber() + "");
        this.labelForTotalTimeValue.setText(((IDurationMonitorNode)this.monitorNode).getTotalTime() + "");
    }

    public JPanel getSpecificPanel() {
        this.updateValues();
        return this.panel;
    }
}

