/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.viewers;

import com.sap.engine.library.monitor.IAvailabilityMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.viewers.PerformanceMonitorNodeViewer;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AvailabilityMonitorNodeViewer
extends PerformanceMonitorNodeViewer {
    JPanel specPanel;
    JLabel valueLabel;
    JLabel value;
    JLabel avalLabel;
    JLabel valueInPercentage;
    JLabel timeOnTrueLabel;
    JLabel timeOnTrueValue;
    JLabel timeOnFalseLabel;
    JLabel timeOnFalseValue;

    public AvailabilityMonitorNodeViewer(Frame mainFrame, IAvailabilityMonitorNode node, MonitorPanelLogical mPanel) {
        super(mainFrame, (IMonitorNode)node, mPanel);
        this.init();
    }

    private void init() {
        this.specPanel = new JPanel();
        this.valueLabel = new JLabel("Last reported value:  ");
        this.value = new JLabel();
        this.avalLabel = new JLabel("Availability in percent: ");
        this.valueInPercentage = new JLabel();
        this.timeOnTrueLabel = new JLabel("Available time in sec:  ");
        this.timeOnTrueValue = new JLabel();
        this.timeOnFalseLabel = new JLabel("Non available time in sec:  ");
        this.timeOnFalseValue = new JLabel();
        this.valueLabel.setFont(MonitorUtils.LABEL_FONT);
        this.value.setFont(MonitorUtils.LABEL_FONT);
        this.timeOnTrueLabel.setFont(MonitorUtils.LABEL_FONT);
        this.timeOnTrueValue.setFont(MonitorUtils.LABEL_FONT);
        this.timeOnFalseLabel.setFont(MonitorUtils.LABEL_FONT);
        this.timeOnFalseValue.setFont(MonitorUtils.LABEL_FONT);
        this.specPanel.setLayout(new GridLayout(4, 2));
        this.specPanel.add(this.avalLabel);
        this.specPanel.add(this.valueInPercentage);
        this.specPanel.add(this.valueLabel);
        this.specPanel.add(this.value);
        this.specPanel.add(this.timeOnTrueLabel);
        this.specPanel.add(this.timeOnTrueValue);
        this.specPanel.add(this.timeOnFalseLabel);
        this.specPanel.add(this.timeOnFalseValue);
    }

    private void updateValues() {
        if (this.monitorNode.getHasReportedValue()) {
            this.value.setText(((IAvailabilityMonitorNode)this.monitorNode).getValue() + " ");
            this.valueInPercentage.setText(MonitorUtils.formatDouble(((IAvailabilityMonitorNode)this.monitorNode).getAvailability()) + " " + MonitorUtils.UNIT_PERCENTAGE);
        } else {
            IAvailabilityMonitorNode cfr_ignored_0 = (IAvailabilityMonitorNode)this.monitorNode;
            this.value.setText("No value has been reported yet");
            IAvailabilityMonitorNode cfr_ignored_1 = (IAvailabilityMonitorNode)this.monitorNode;
            this.valueInPercentage.setText("No value has been reported yet");
        }
        this.timeOnTrueValue.setText(Math.floor(((IAvailabilityMonitorNode)this.monitorNode).getTimeOnTrueInMilliseconds() / 60L) + " sec");
        this.timeOnFalseValue.setText(Math.floor(((IAvailabilityMonitorNode)this.monitorNode).getTimeOnFalseInMilliseconds() / 60L) + " sec");
    }

    public JPanel getSpecificPanel() {
        this.updateValues();
        return this.specPanel;
    }
}

