/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.history;

import com.sap.engine.library.monitor.IPerformanceMonitorNode;
import com.sap.engine.library.monitor.history.IExtremum;
import com.sap.engine.library.monitor.history.IHistory;
import com.sap.engine.library.monitor.history.IHistoryStatistics;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.history.HistoryStatisticsComparator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class PerformanceHistoryDialog
extends JDialog {
    static final int INITIAL_DIALOG_POSITION = 200;
    static final int MAX_DIALOG_POSITION = 500;
    static final int DIALOG_POSITION_OFFSET = 20;
    static final String LABEL_BUTTON_HISTORY_DIALOG = "History";
    static final Dimension TABLE_DIMENSION = new Dimension(500, 200);
    static final String DIALOG_TITLE = "Data History of ";
    static final int COLUMN_INDEX_TIME = 0;
    static final int COLUMN_INDEX_AVERAGE = 1;
    static final int COLUMN_INDEX_MIN = 2;
    static final int COLUMN_INDEX_MAX = 3;
    static final int COLUMN_INDEX_COUNS = 4;
    static final SimpleDateFormat formatter = new SimpleDateFormat("hh:mm a");
    static int X_LOCATION = 100;
    static int Y_LOCATION = 100;
    private Object[] tableColumnNames;
    private IPerformanceMonitorNode node;

    public PerformanceHistoryDialog(Frame mainFrame, IPerformanceMonitorNode node) {
        super(mainFrame, DIALOG_TITLE + node.getName() + " " + node.getUnit(), false);
        this.node = node;
        this.setDefaultCloseOperation(2);
        IHistory ihistory = node.getHistory();
        String unit = "";
        if (node.getUnit() != null && !node.getUnit().equals("")) {
            unit = " [" + node.getUnit() + "]";
            unit = " [" + node.getUnit() + "]";
        }
        if (ihistory != null) {
            String averagingMode = "";
            switch (ihistory.getAveragingMode()) {
                case 0: {
                    averagingMode = "arithmetic averaging";
                    break;
                }
                case 1: {
                    averagingMode = "time weighted average";
                }
            }
            this.tableColumnNames = new Object[]{"time", averagingMode + unit, "min" + unit, "max" + unit, "counts"};
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(this.createHistoryTablePanel(ihistory));
        } else {
            this.getContentPane().add(new JLabel("There is no available history till that moment!"));
        }
        ((Component)this).setLocation(X_LOCATION, Y_LOCATION);
        this.setNewWindowLocation();
        this.pack();
        ((Component)this).setVisible(true);
    }

    void setNewWindowLocation() {
        X_LOCATION = X_LOCATION < 500 ? (X_LOCATION += 20) : 200;
        Y_LOCATION = Y_LOCATION < 500 ? (Y_LOCATION += 20) : 200;
    }

    private JTabbedPane createHistoryTablePanel(IHistory ihistory) {
        JTabbedPane tabs = new JTabbedPane();
        if (ihistory != null) {
            Serializable[] ahistory = null;
            try {
                ahistory = ihistory.getMinutesHistory();
                if (ahistory != null) {
                    JPanel minuteTable = this.createMinutesTable(ahistory);
                    tabs.add("Minute history", minuteTable);
                } else {
                    tabs.add("Minute history", new JLabel("Minute history N/A"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ahistory = ihistory.getFiveMinutesHistory();
                if (ahistory != null) {
                    JPanel fiveMinutesTable = this.createTable(ahistory, "FiveMinutes");
                    tabs.add("5 minutes history", fiveMinutesTable);
                } else {
                    tabs.add("5 minutes history", new JLabel("5 minutes history N/A"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ahistory = ihistory.getQuartersHistory();
                if (ahistory != null) {
                    JPanel quarterTable = this.createTable(ahistory, "Quarters");
                    tabs.add("Quarters history", quarterTable);
                } else {
                    tabs.add("Quarters history", new JLabel("Quarter history N/A "));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ahistory = ihistory.getHoursHistory();
                if (ahistory != null) {
                    JPanel hourTable = this.createTable(ahistory, "Hours");
                    tabs.add("Hour history", hourTable);
                } else {
                    tabs.add("Hour history", new JLabel("Hour history N/A"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tabs;
    }

    private JPanel createMinutesTable(Serializable[] ihistory) {
        JPanel tablePanel = new JPanel();
        JTable table = new JTable();
        int numberOfEntries = ihistory.length;
        Object[][] data = new Object[numberOfEntries + 1][this.tableColumnNames.length];
        DefaultTableModel tableModel = new DefaultTableModel();
        IHistoryStatistics[] history = this.sort(ihistory);
        data[0] = this.getHistoryStatistics(this.node.getHistory().getActualMinuteHistory());
        int i = 0;
        int k = 1;
        while (i < numberOfEntries) {
            IHistoryStatistics stat = history[i];
            if (stat != null) {
                data[k] = this.getHistoryStatistics(stat);
                ++k;
            }
            ++i;
        }
        tableModel.setDataVector(data, this.tableColumnNames);
        table.setEnabled(false);
        table.setModel(tableModel);
        table.setPreferredScrollableViewportSize(TABLE_DIMENSION);
        table.setBackground(MonitorUtils.TABLE_COLOR_NOT_EDITABLE);
        tablePanel.setLayout(new GridLayout(1, 1));
        tablePanel.add(new JScrollPane(table));
        return tablePanel;
    }

    private JPanel createTable(Serializable[] ihistory, String timeUnit) {
        JPanel tablePanel = new JPanel();
        JTable table = new JTable();
        int numberOfEntries = ihistory.length;
        Object[][] data = new Object[numberOfEntries][this.tableColumnNames.length];
        DefaultTableModel tableModel = new DefaultTableModel();
        IHistoryStatistics[] history = this.sort(ihistory);
        int i = 0;
        int k = 0;
        while (i < numberOfEntries) {
            IHistoryStatistics stat = history[i];
            if (stat != null) {
                data[k++] = this.getHistoryStatistics(stat);
            }
            ++i;
        }
        tableModel.setDataVector(data, this.tableColumnNames);
        table.setEnabled(false);
        table.setModel(tableModel);
        table.setPreferredScrollableViewportSize(TABLE_DIMENSION);
        table.setBackground(MonitorUtils.TABLE_COLOR_NOT_EDITABLE);
        tablePanel.setLayout(new GridLayout(1, 1));
        tablePanel.add(new JScrollPane(table));
        return tablePanel;
    }

    private String[] getHistoryStatistics(IHistoryStatistics historyStats) {
        String[] stats = new String[this.tableColumnNames.length];
        stats[0] = formatter.format(new Date(historyStats.getStartTimestamp()));
        double average = historyStats.getAverage();
        if (historyStats.getMeasurementCounts() == 0) {
            stats[1] = "-";
            stats[2] = "-";
            stats[3] = "-";
            stats[4] = "0";
            return stats;
        }
        stats[1] = average != 0.0 ? MonitorUtils.round(average) + "\u00b1" + MonitorUtils.round(historyStats.getStandardDeviation() / average * 100.0) + MonitorUtils.UNIT_PERCENTAGE : average + "";
        IExtremum min = historyStats.getMinimum();
        stats[2] = min != null ? MonitorUtils.round(min.getValue()) + "" : "-";
        IExtremum max = historyStats.getMaximum();
        stats[3] = max != null ? MonitorUtils.round(max.getValue()) + "" : "-";
        stats[4] = historyStats.getMeasurementCounts() + "";
        return stats;
    }

    IHistoryStatistics[] sort(Serializable[] ihistory) {
        IHistoryStatistics[] stats = new IHistoryStatistics[ihistory.length];
        TreeSet<Serializable> set = new TreeSet<Serializable>(new HistoryStatisticsComparator());
        int p = ihistory.length - 1;
        int i = 0;
        while (i < ihistory.length) {
            set.add(ihistory[i]);
            ++i;
        }
        Iterator setIter = set.iterator();
        while (setIter.hasNext()) {
            stats[p] = (IHistoryStatistics)setIter.next();
            --p;
        }
        return stats;
    }
}

