/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.editors;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IStateMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.editors.GeneralInfoPanel;
import com.sap.engine.services.monitor.gui.editors.MonitorNodeEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class StateMonitorNodeEditor
extends MonitorNodeEditor {
    static Dimension TABLE_DIMENSION = new Dimension(300, 200);
    static String[] COLUMN_NAMES = new String[]{"red states", "yellow states", "greenStates"};
    static String TITLE_COLOR_STATES = "States";
    JButton addBtn = new JButton("Add states");
    Frame mainFrame;
    DefaultTableModel tableModel = new DefaultTableModel();
    JTable table = new JTable();
    GeneralInfoPanel generalInfoPanel;
    JPanel colorStatesPanel;
    IStateMonitorNode i_monitorNode;
    MonitorPanelLogical mPanel;

    public StateMonitorNodeEditor(Frame mainFrame, IStateMonitorNode i_monitorNode, MonitorPanelLogical mPanel) {
        this.mainFrame = mainFrame;
        this.i_monitorNode = i_monitorNode;
        this.mPanel = mPanel;
        this.createPanels();
    }

    protected void createPanels() {
        this.generalInfoPanel = new GeneralInfoPanel((IMonitorNode)this.i_monitorNode, this.mPanel);
        this.colorStatesPanel = this.createColorStatesPanel();
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add(MonitorNodeEditor.TITLE_GENERAL_INFO, this.generalInfoPanel);
        tabPane.add(TITLE_COLOR_STATES, this.colorStatesPanel);
        tabPane.setSelectedIndex(0);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Properties of: " + this.i_monitorNode.getPath()), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 0, MonitorUtils.INSETS, 0, 0));
        this.add((Component)tabPane, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 11, 0, MonitorUtils.INSETS, 0, 0));
        this.add((Component)this.getButtonsPanel(), new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 15, 0, MonitorUtils.INSETS_LARGE, 0, 0));
        this.validate();
    }

    public void saveMonitor() {
        this.generalInfoPanel.saveData();
        this.saveStates();
    }

    public void switchToEditMode(boolean mode) {
        this.generalInfoPanel.switchToEditMode(mode);
        this.addBtn.setEnabled(mode);
        this.table.setEnabled(mode);
        if (mode) {
            this.table.setBackground(Color.white);
        } else {
            this.table.setBackground(MonitorUtils.TABLE_COLOR_NOT_EDITABLE);
        }
    }

    public JPanel createColorStatesPanel() {
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BorderLayout());
        this.tableModel.setColumnIdentifiers(COLUMN_NAMES);
        this.table.setModel(this.tableModel);
        this.table.setBackground(MonitorUtils.TABLE_COLOR_NOT_EDITABLE);
        this.table.setPreferredScrollableViewportSize(TABLE_DIMENSION);
        this.table.setEnabled(false);
        int numberOfRows = 0;
        int numberOfRedStates = this.i_monitorNode.getRedStates().length;
        int numberOfYellowStates = this.i_monitorNode.getYellowStates().length;
        int numberOfGreenStates = this.i_monitorNode.getGreenStates().length;
        numberOfRows = Math.max(numberOfRedStates, numberOfYellowStates);
        numberOfRows = Math.max(numberOfRows, numberOfGreenStates);
        this.tableModel.setRowCount(numberOfRows);
        int i = 0;
        while (i < numberOfRedStates) {
            this.tableModel.setValueAt(this.i_monitorNode.getRedStates()[i], i, 0);
            ++i;
        }
        int i2 = 0;
        while (i2 < numberOfYellowStates) {
            this.tableModel.setValueAt(this.i_monitorNode.getYellowStates()[i2], i2, 1);
            ++i2;
        }
        int i3 = 0;
        while (i3 < numberOfGreenStates) {
            this.tableModel.setValueAt(this.i_monitorNode.getGreenStates()[i3], i3, 2);
            ++i3;
        }
        colorPanel.add((Component)new JScrollPane(this.table), "Center");
        colorPanel.add((Component)this.addBtn, "South");
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StateMonitorNodeEditor.this.tableModel.setRowCount(StateMonitorNodeEditor.this.tableModel.getRowCount() + 1);
            }
        });
        return colorPanel;
    }

    public void reactOnCancel() {
        this.generalInfoPanel.fillComponents();
    }

    private void saveStates() {
        int rows = this.tableModel.getRowCount();
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        String[][] states = new String[rows][3];
        int i = 0;
        while (i < rows) {
            states[i][0] = (String)this.table.getValueAt(i, 0);
            states[i][1] = (String)this.table.getValueAt(i, 1);
            states[i][2] = (String)this.table.getValueAt(i, 2);
            ++i;
        }
        boolean result = false;
        try {
            result = this.mPanel.getRuntimeInterface().setStates(this.i_monitorNode.getConfigurationGroup(), states);
            this.mPanel.reloadNode();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        if (!result) {
            JOptionPane.showMessageDialog(this, "Cannon set the states", "Cannon set the states", 0);
        }
    }

    public void reactOnRestore() {
        boolean isPerformed = false;
        int result = JOptionPane.showConfirmDialog(this, "You are about to restore properties of this group to default.\n If the group is saved in data base,current action will delete it.", "Restore action", 2);
        if (result == 0) {
            try {
                this.mPanel.getRuntimeInterface().restoreGroupToDefault(this.i_monitorNode.getConfigurationGroup());
                this.mPanel.reloadNode();
                isPerformed = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showMessage();
            }
        } else {
            return;
        }
        if (!isPerformed) {
            this.showMessage();
        }
    }
}

