/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.editors;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IPerformanceMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.editors.GeneralInfoPanel;
import com.sap.engine.services.monitor.gui.editors.MonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.PerformanceInfoPanel;
import com.sap.engine.services.monitor.gui.viewers.MultipleRowLabel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public abstract class PerformanceNodeEditor
extends MonitorNodeEditor {
    Frame mainFrame;
    GeneralInfoPanel generalInfoPanel;
    PerformanceInfoPanel performanceInfoPanel;
    IPerformanceMonitorNode monitorNode;
    MonitorPanelLogical mPanel;

    public PerformanceNodeEditor(Frame mainFrame, IPerformanceMonitorNode monitorNode, MonitorPanelLogical mPanel) {
        this.mainFrame = mainFrame;
        this.monitorNode = monitorNode;
        this.mPanel = mPanel;
    }

    protected void createPanels(String[] attributesArray) {
        this.generalInfoPanel = new GeneralInfoPanel((IMonitorNode)this.monitorNode, this.mPanel);
        this.performanceInfoPanel = new PerformanceInfoPanel(this.monitorNode, this.mPanel);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add(MonitorNodeEditor.TITLE_GENERAL_INFO, this.generalInfoPanel);
        tabPane.add(MonitorNodeEditor.TITLE_PERFORMANCE_INFO, this.performanceInfoPanel);
        tabPane.setSelectedIndex(0);
        this.setLayout(new GridBagLayout());
        MultipleRowLabel title = new MultipleRowLabel("Properties of: " + this.monitorNode.getPath(), 60);
        this.add((Component)title, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 0, MonitorUtils.INSETS, 0, 0));
        this.add((Component)tabPane, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 11, 0, MonitorUtils.INSETS, 0, 0));
        this.add((Component)this.getButtonsPanel(), new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 15, 0, MonitorUtils.INSETS_LARGE, 0, 0));
        this.validate();
    }

    public void saveMonitor() {
        this.generalInfoPanel.saveData();
        this.performanceInfoPanel.saveData();
    }

    public void switchToEditMode(boolean mode) {
        this.generalInfoPanel.switchToEditMode(mode);
        this.performanceInfoPanel.switchToEditMode(mode);
    }

    public void reactOnCancel() {
        this.generalInfoPanel.fillComponents();
        this.performanceInfoPanel.fillComponents();
    }

    public void reactOnRestore() {
        boolean isPerformed = false;
        int result = JOptionPane.showConfirmDialog(this, "You are about to restore properties of this group to default.\n If the group is saved in data base,current action will delete it.", "Restore action", 2);
        if (result == 0) {
            try {
                this.mPanel.getRuntimeInterface().restoreGroupToDefault(this.monitorNode.getConfigurationGroup());
                this.mPanel.reloadNode();
                isPerformed = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showMessage();
            }
        } else {
            return;
        }
        if (!isPerformed) {
            this.showMessage();
        }
    }
}

