/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.editors;

import com.sap.engine.library.monitor.IPerformanceMonitorNode;
import com.sap.engine.library.monitor.IThresholds;
import com.sap.engine.services.monitor.config.PerformanceMonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.Thresholds;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PerformanceInfoPanel
extends JPanel {
    public static final int SIZE_OF_THRESHOLD_TEXT_FIELD = 10;
    static final String LABEL_GREEN_TO_YELLOW = "Changes from green to yellow:";
    static final String LABEL_YELLOW_TO_RED = "Changes from yellow to red:";
    static final String LABEL_RED_TO_YELLOW = "Changes from red to yellow:";
    static final String LABEL_YELLOW_TO_GREEN = "Changes from yellow to green:";
    IPerformanceMonitorNode i_monitorNode;
    IThresholds thresholds;
    JLabel titleLabel = new JLabel("Color changing thresholds:");
    JTextField greenToYellowTxt = new JTextField(10);
    JTextField yellowToRedTxt = new JTextField(10);
    JTextField redToYellowTxt = new JTextField(10);
    JTextField yellowToGreenTxt = new JTextField(10);
    PerformanceMonitorConfigurationGroup configGroup;
    MonitorPanelLogical mPanel;
    private int m_direction = 0;
    public static final int S_DIRECTION_UP = 1;
    public static final int S_DIRECTION_DOWN = -1;

    public PerformanceInfoPanel(IPerformanceMonitorNode i_monitorNode, MonitorPanelLogical mPanel) {
        this.i_monitorNode = i_monitorNode;
        this.mPanel = mPanel;
        this.createPerformanceInfoPanel();
    }

    public void createPerformanceInfoPanel() {
        if (this.i_monitorNode != null) {
            this.fillComponents();
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.createThresholdsPanel(), "Center");
    }

    protected void fillComponents() {
        this.thresholds = this.i_monitorNode.getThresholds();
        this.greenToYellowTxt.setText(this.thresholds.getThresholdFromGreenToYellow() + "");
        this.yellowToRedTxt.setText(this.thresholds.getThresholdFromYellowToRed() + "");
        this.redToYellowTxt.setText(this.thresholds.getThresholdFromRedToYellow() + "");
        this.yellowToGreenTxt.setText(this.thresholds.getThresholdFromYellowToGreen() + "");
    }

    public JPanel createThresholdsPanel() {
        JPanel thresholdsPanel = new JPanel();
        thresholdsPanel.setLayout(new GridBagLayout());
        thresholdsPanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 2, 1, 0.1, 0.0, 10, 0, MonitorUtils.INSETS_LARGE, 0, 0));
        thresholdsPanel.add((Component)new JLabel(LABEL_GREEN_TO_YELLOW), new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 13, 0, MonitorUtils.INSETS, 0, 0));
        thresholdsPanel.add((Component)this.greenToYellowTxt, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        thresholdsPanel.add((Component)new JLabel(LABEL_YELLOW_TO_RED), new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 13, 0, MonitorUtils.INSETS, 0, 0));
        thresholdsPanel.add((Component)this.yellowToRedTxt, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        thresholdsPanel.add((Component)new JLabel(LABEL_RED_TO_YELLOW), new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 13, 0, MonitorUtils.INSETS, 0, 0));
        thresholdsPanel.add((Component)this.redToYellowTxt, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        thresholdsPanel.add((Component)new JLabel(LABEL_YELLOW_TO_GREEN), new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 13, 0, MonitorUtils.INSETS, 0, 0));
        thresholdsPanel.add((Component)this.yellowToGreenTxt, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        return thresholdsPanel;
    }

    public void saveData() {
        Thresholds thresholdsNew = new Thresholds(this.thresholds.getThresholdFromGreenToYellow(), this.thresholds.getThresholdFromYellowToRed(), this.thresholds.getThresholdFromRedToYellow(), this.thresholds.getThresholdFromYellowToGreen());
        if (this.i_monitorNode != null) {
            try {
                int greenToYellowInt = Integer.parseInt(this.greenToYellowTxt.getText());
                int redToYellowInt = Integer.parseInt(this.redToYellowTxt.getText());
                int yellowToGreenInt = Integer.parseInt(this.yellowToGreenTxt.getText());
                int yellowToRedInt = Integer.parseInt(this.yellowToRedTxt.getText());
                if (this.thresholds.getThresholdFromGreenToYellow() != greenToYellowInt || this.thresholds.getThresholdFromYellowToRed() != yellowToRedInt || this.thresholds.getThresholdFromRedToYellow() != redToYellowInt || this.thresholds.getThresholdFromYellowToGreen() != yellowToGreenInt) {
                    thresholdsNew.setGreen2Yellow(greenToYellowInt);
                    thresholdsNew.setRed2Yellow(redToYellowInt);
                    thresholdsNew.setYellow2Green(yellowToGreenInt);
                    thresholdsNew.setYellow2Red(yellowToRedInt);
                    this.calculateDirection(greenToYellowInt, yellowToRedInt, yellowToGreenInt, redToYellowInt);
                    this.checkConsistency(greenToYellowInt, yellowToRedInt, yellowToGreenInt, redToYellowInt);
                    try {
                        this.mPanel.getRuntimeInterface().changeThresholds(this.i_monitorNode.getConfigurationGroup(), thresholdsNew);
                        this.mPanel.reloadNode();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Cannot Set Thresholds!Check the values!" + e.getMessage(), "Error", 0);
                        e.printStackTrace();
                    }
                }
            }
            catch (NumberFormatException nex) {
                JOptionPane.showMessageDialog(null, "Threshold values must be integer!", "Error", 0);
                nex.printStackTrace();
            }
            catch (Exception mex) {
                JOptionPane.showMessageDialog(null, "Cannot Set Thresholds!Check the values!" + mex.getMessage(), "Error", 0);
                mex.printStackTrace();
            }
        }
    }

    public void switchToEditMode(boolean mode) {
        this.greenToYellowTxt.setEnabled(mode);
        this.yellowToRedTxt.setEnabled(mode);
        this.redToYellowTxt.setEnabled(mode);
        this.yellowToGreenTxt.setEnabled(mode);
    }

    protected void calculateDirection(int gTy, int yTr, int yTg, int rTy) throws Exception {
        if (gTy < rTy) {
            this.m_direction = 1;
        } else if (gTy > rTy) {
            this.m_direction = -1;
        } else {
            throw new Exception("\nThresholds:  \nreen to yellow: " + gTy + " \nyellow to red: " + yTr + " \nyellow to green: " + yTg + " \nred to yellow: " + rTy + " \nare inconsistent.");
        }
    }

    protected void checkConsistency(int gTy, int yTr, int yTg, int rTy) throws Exception {
        boolean consistent = true;
        if (this.m_direction == 1) {
            if (gTy < yTg || rTy <= gTy || yTr < rTy) {
                consistent = false;
            }
        } else if (gTy > yTg || rTy >= gTy || yTr > rTy) {
            consistent = false;
        }
        if (!consistent) {
            throw new Exception("\n Thresholds:  \ngreen to yellow: " + gTy + " \nyellow to red: " + yTr + " \nyellow to green: " + yTg + " \nred to yellow: " + rTy + " \nare inconsistent.");
        }
    }
}

