/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.editors;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.gui.MonitorRuntimeView;
import com.sap.engine.services.monitor.gui.editors.ConfigDialog;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class MonitorNodeEditor
extends JPanel
implements ActionListener {
    public static String TITLE_GENERAL_INFO = "General";
    public static String TITLE_PERFORMANCE_INFO = "Performance";
    public static String TITLE_ATTRIBUTES = "Attributes";
    public static final String ACTION_EDIT_MONITOR = "act_edit_monitor";
    public static final String ACTION_SAVE_MONITOR = "act_save_monitor";
    public static final String ACTION_CANCEL = "act_cancel";
    public static final String ACTION_RESTORE_GROUP = "act_restore";
    public JButton btnEdit = new JButton("Edit");
    public JButton btnSave = new JButton("Save");
    public JButton btnCancel = new JButton("Cancel");
    public JButton btnRestore = new JButton("Restore");
    public IMonitorNode currentNode;

    public abstract void saveMonitor();

    public abstract void switchToEditMode(boolean var1);

    public abstract void reactOnCancel();

    public abstract void reactOnRestore();

    public JPanel getButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 1));
        this.btnEdit.addActionListener(this);
        this.btnEdit.setActionCommand(ACTION_EDIT_MONITOR);
        this.btnEdit.setIcon(MonitorRuntimeView.getIcon("edit.gif"));
        this.btnSave.addActionListener(this);
        this.btnSave.setActionCommand(ACTION_SAVE_MONITOR);
        this.btnSave.setIcon(MonitorRuntimeView.getIcon("save.gif"));
        this.btnCancel.addActionListener(this);
        this.btnCancel.setActionCommand(ACTION_CANCEL);
        this.btnCancel.setIcon(MonitorRuntimeView.getIcon("cancel.gif"));
        this.btnRestore.addActionListener(this);
        this.btnRestore.setActionCommand(ACTION_RESTORE_GROUP);
        this.btnRestore.setIcon(MonitorRuntimeView.getIcon("restore_2.gif"));
        this.btnSave.setEnabled(false);
        this.btnRestore.setEnabled(false);
        buttonsPanel.add(this.btnEdit);
        buttonsPanel.add(this.btnSave);
        buttonsPanel.add(this.btnRestore);
        buttonsPanel.add(this.btnCancel);
        return buttonsPanel;
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_SAVE_MONITOR)) {
            this.saveMonitor();
            Container container = this.getParent().getParent().getParent().getParent();
            if (container instanceof JDialog) {
                ((ConfigDialog)container).dispose();
            }
        } else if (action.equals(ACTION_CANCEL)) {
            Container container = this.getParent().getParent().getParent().getParent();
            if (container instanceof JDialog) {
                ((ConfigDialog)container).dispose();
            } else {
                this.btnSave.setEnabled(false);
                this.reactOnCancel();
                this.switchToEditMode(false);
            }
        } else if (action.equals(ACTION_EDIT_MONITOR)) {
            this.proceedEditMode();
        } else if (action.equals(ACTION_RESTORE_GROUP)) {
            this.reactOnRestore();
            Container container = this.getParent().getParent().getParent().getParent();
            if (container instanceof JDialog) {
                ((ConfigDialog)container).dispose();
            }
        }
    }

    public void proceedEditMode() {
        if (this.btnSave.isEnabled()) {
            this.btnSave.setEnabled(false);
            this.btnRestore.setEnabled(false);
            this.reactOnCancel();
            this.switchToEditMode(false);
        } else {
            this.checkAutorization();
        }
    }

    public void checkAutorization() {
        boolean autorized = true;
        if (autorized) {
            this.btnSave.setEnabled(true);
            this.btnRestore.setEnabled(true);
            this.switchToEditMode(true);
        } else {
            JOptionPane.showMessageDialog(null, "You are not authorized to edit settings!", "Error", 0);
        }
    }

    public void showMessage() {
        JOptionPane.showMessageDialog(null, "Canot set to default the group!", "Error", 0);
    }
}

