/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.editors;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GeneralInfoPanel
extends JPanel
implements ActionListener {
    static String[] reactionTypes = new String[]{"Unregister monitor", "Ignore"};
    static String[] timeUnitTypes = new String[]{"MINUTE", "HOUR", "DAY"};
    static String ACTION_TRIGGERED_BY_RESOURCE = "act_trig_res";
    static String ACTION_TRIGGERED_BY_TIMER = "act_trig_timer";
    JLabel reactLabel = new JLabel("react on resource failure:");
    JComboBox reactionTypesComboBox = new JComboBox<String>(reactionTypes);
    JLabel nameLabel = new JLabel("Name:");
    JLabel nameTxt = new JLabel();
    JLabel descrLabel = new JLabel("Description:");
    JTextArea descrText = new JTextArea();
    JLabel typeLabel = new JLabel("Type:");
    JLabel typeTxt = new JLabel();
    JLabel groupLabel = new JLabel("Configuration group:");
    JLabel groupTxt = new JLabel();
    JLabel dataCollectionLabel = new JLabel("Data Collection:");
    JLabel period = new JLabel("period");
    JTextField periodTxtField = new JTextField(10);
    JLabel unitLabel = new JLabel("unit");
    JComboBox timeUnitTypesComboBox = new JComboBox<String>(timeUnitTypes);
    ButtonGroup btnGroup = new ButtonGroup();
    JRadioButton btnTimer = new JRadioButton("polled by monitor");
    JRadioButton btnResource = new JRadioButton("pushed by resource");
    IMonitorNode monitorNode;
    MappingTreeNode mappingNode;
    MonitorRuntimeControlInterface runtimeInterface;
    MonitorPanelLogical monitorPanel;

    public GeneralInfoPanel(IMonitorNode monitorNode, MonitorPanelLogical monitorPanel) {
        this.monitorNode = monitorNode;
        this.monitorPanel = monitorPanel;
        this.runtimeInterface = monitorPanel.getRuntimeInterface();
        if (monitorNode != null) {
            this.fillComponents();
        }
        this.createGeneralInfoPanel();
    }

    public void createGeneralInfoPanel() {
        GridBagLayout gridbagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel dataColectionPanel = this.createDataColectionPanel();
        this.setLayout(gridbagLayout);
        this.btnTimer.setEnabled(false);
        this.btnResource.setEnabled(false);
        this.descrText.setColumns(20);
        this.descrText.setLineWrap(true);
        constraints.anchor = 17;
        constraints.insets = MonitorUtils.INSETS;
        constraints.gridx = 0;
        constraints.gridy = 0;
        gridbagLayout.setConstraints(this.nameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        gridbagLayout.setConstraints(this.nameTxt, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        gridbagLayout.setConstraints(this.descrLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        gridbagLayout.setConstraints(this.descrText, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        gridbagLayout.setConstraints(this.typeLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        gridbagLayout.setConstraints(this.typeTxt, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        gridbagLayout.setConstraints(this.groupLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        gridbagLayout.setConstraints(this.groupTxt, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.anchor = 18;
        gridbagLayout.setConstraints(this.dataCollectionLabel, constraints);
        constraints.gridx = 1;
        constraints.anchor = 17;
        gridbagLayout.setConstraints(dataColectionPanel, constraints);
        constraints.gridy = 4;
        constraints.gridx = 1;
        constraints.gridy = 5;
        gridbagLayout.setConstraints(this.reactLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 6;
        gridbagLayout.setConstraints(this.reactionTypesComboBox, constraints);
        this.add(this.nameLabel);
        this.add(this.nameTxt);
        this.add(this.descrLabel);
        this.add(this.descrText);
        this.add(this.typeLabel);
        this.add(this.typeTxt);
        this.add(this.groupLabel);
        this.add(this.groupTxt);
        this.add(this.dataCollectionLabel);
        this.add(dataColectionPanel);
        this.add(this.reactLabel);
        this.add(this.reactionTypesComboBox);
    }

    public JPanel createDataColectionPanel() {
        JPanel dataCollectionPanel = new JPanel();
        GridBagLayout gridbagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        dataCollectionPanel.setLayout(gridbagLayout);
        this.btnResource.addActionListener(this);
        this.btnResource.setActionCommand(ACTION_TRIGGERED_BY_RESOURCE);
        this.btnTimer.addActionListener(this);
        this.btnTimer.setActionCommand(ACTION_TRIGGERED_BY_TIMER);
        constraints.anchor = 17;
        constraints.insets = MonitorUtils.INSETS;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        gridbagLayout.setConstraints(this.btnResource, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        gridbagLayout.setConstraints(this.btnTimer, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.insets.left = 30;
        gridbagLayout.setConstraints(this.period, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets.left = 5;
        gridbagLayout.setConstraints(this.periodTxtField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets.left = 30;
        gridbagLayout.setConstraints(this.unitLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.insets.left = 5;
        gridbagLayout.setConstraints(this.timeUnitTypesComboBox, constraints);
        this.btnGroup.add(this.btnTimer);
        this.btnGroup.add(this.btnResource);
        dataCollectionPanel.add(this.btnTimer);
        dataCollectionPanel.add(this.btnResource);
        dataCollectionPanel.add(this.period);
        dataCollectionPanel.add(this.periodTxtField);
        dataCollectionPanel.add(this.unitLabel);
        dataCollectionPanel.add(this.timeUnitTypesComboBox);
        return dataCollectionPanel;
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_TRIGGERED_BY_RESOURCE)) {
            this.period.setEnabled(false);
            this.periodTxtField.setEnabled(false);
            this.unitLabel.setEnabled(false);
            this.timeUnitTypesComboBox.setEnabled(false);
            this.validate();
        } else if (action.equals(ACTION_TRIGGERED_BY_TIMER)) {
            this.period.setEnabled(true);
            this.periodTxtField.setEnabled(true);
            this.unitLabel.setEnabled(true);
            this.timeUnitTypesComboBox.setEnabled(true);
            this.validate();
        }
    }

    protected void fillComponents() {
        if (this.monitorNode != null) {
            this.groupTxt.setText(this.monitorNode.getConfigurationGroup());
            this.descrText.setText(this.monitorNode.getDescription());
            int reactOnFailure = this.monitorNode.getReactOnCollectionFailure();
            if (reactOnFailure == 3) {
                this.reactionTypesComboBox.setSelectedIndex(0);
            } else if (reactOnFailure == 4) {
                this.reactionTypesComboBox.setSelectedIndex(1);
            }
            this.nameTxt.setText(this.monitorNode.getName());
            this.typeTxt.setText(MonitorUtils.getStringType(this.monitorNode.getTyp(), this.monitorNode));
            switch (this.monitorNode.getDataCollectionType()) {
                case 0: {
                    if (this.period == null) break;
                    this.periodTxtField.setText(this.monitorNode.getPeriodValue() + "");
                    this.timeUnitTypesComboBox.setSelectedIndex(this.monitorNode.getPeriodUnit());
                    this.btnTimer.setSelected(true);
                    break;
                }
                case 2: {
                    this.btnResource.setSelected(true);
                    break;
                }
            }
        }
    }

    public void saveData() {
        boolean toUpdate = false;
        String text = this.descrText.getText();
        DataCollection dataCollection = null;
        if (!text.equals(this.monitorNode.getDescription())) {
            try {
                toUpdate = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Cannot Set Description! Reason: " + e.getMessage(), "Error", 0);
                e.printStackTrace();
            }
        }
        Period collectPeriod = null;
        int reactOnCollectionFailure = -1;
        try {
            if (this.btnTimer.isSelected()) {
                int value = Integer.parseInt(this.periodTxtField.getText());
                String unit = (String)this.timeUnitTypesComboBox.getSelectedItem();
                int unitInt = 0;
                if (unit.equals(timeUnitTypes[0])) {
                    unitInt = 0;
                } else if (unit.equals(timeUnitTypes[1])) {
                    unitInt = 1;
                } else if (unit.equals(timeUnitTypes[2])) {
                    unitInt = 2;
                }
                collectPeriod = new Period(value, unitInt);
            }
            if (this.reactionTypesComboBox.getSelectedItem().equals(reactionTypes[0])) {
                reactOnCollectionFailure = 3;
            } else if (this.reactionTypesComboBox.getSelectedItem().equals(reactionTypes[1])) {
                reactOnCollectionFailure = 4;
            }
            if (collectPeriod == null) {
                dataCollection = new DataCollection(this.monitorNode.getDataCollectionType(), null, reactOnCollectionFailure);
                toUpdate = true;
            } else {
                dataCollection = new DataCollection(this.monitorNode.getDataCollectionType(), collectPeriod, reactOnCollectionFailure);
                toUpdate = true;
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Input data is not valid.Period must be integer ", "Eror", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error occured:" + e.getMessage(), "Error ", 0);
        }
        if (toUpdate) {
            try {
                this.runtimeInterface.changeMonitorGroupProperties(this.monitorNode.getConfigurationGroup(), text, dataCollection);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error occured:" + e.getMessage(), "Error ", 0);
            }
            this.monitorPanel.reloadNode();
        }
    }

    public void switchToEditMode(boolean mode) {
        this.reactionTypesComboBox.setEnabled(mode);
        if (this.btnTimer.isSelected()) {
            this.btnTimer.setEnabled(mode);
            this.periodTxtField.setEnabled(mode);
            this.timeUnitTypesComboBox.setEnabled(mode);
            this.period.setEnabled(mode);
            this.unitLabel.setEnabled(mode);
        } else if (this.btnResource.isSelected()) {
            this.btnResource.setEnabled(mode);
            this.periodTxtField.setEnabled(false);
            this.timeUnitTypesComboBox.setEnabled(false);
            this.period.setEnabled(false);
            this.unitLabel.setEnabled(false);
        }
        this.descrText.setEnabled(mode);
        if (mode) {
            this.descrText.setBackground(Color.white);
        } else {
            this.descrText.setBackground(MonitorUtils.TABLE_COLOR_NOT_EDITABLE);
        }
    }
}

