/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui.editors;

import com.sap.engine.library.monitor.IAvailabilityMonitorNode;
import com.sap.engine.library.monitor.ICacheMonitorNode;
import com.sap.engine.library.monitor.ICounterMonitorNode;
import com.sap.engine.library.monitor.IDurationMonitorNode;
import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.ILongMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IPoolMonitorNode;
import com.sap.engine.library.monitor.IPropertiesMonitorNode;
import com.sap.engine.library.monitor.IQualityRateMonitorNode;
import com.sap.engine.library.monitor.IStateMonitorNode;
import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.IVariableStateMonitorNode;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import com.sap.engine.services.monitor.gui.editors.AvaliabilityMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.CacheMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.ConfigurationMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.CounterMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.DurationMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.FrequencyMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.IntegerMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.LongMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.MonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.PoolMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.PropertiesMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.QualityRateMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.StateMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.StringMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.TableMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.VariableMonitorNodeEditor;
import com.sap.engine.services.monitor.gui.editors.VersionMonitorNodeEditor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.JDialog;

public class ConfigDialog
extends JDialog {
    public static String TITLE_OF_DIALOG = "Monitor Configuration";
    Frame mainFrame;
    IMonitorNode monitorNode;
    Properties properties;
    MonitorNodeEditor mainPanel;
    MonitorRuntimeControlInterface runtimeInterface;
    MonitorPanelLogical mPanel;

    public ConfigDialog(Frame mainFrame, MonitorPanelLogical mPanel) {
        super(mainFrame, TITLE_OF_DIALOG, true);
        this.mPanel = mPanel;
        this.setDefaultCloseOperation(2);
        this.mainFrame = mainFrame;
        this.runtimeInterface = mPanel.getRuntimeInterface();
    }

    public void updateDialog(IMonitorNode monitorNode, MonitorRuntimeControlInterface runtimeInterface) {
        this.monitorNode = monitorNode;
        this.runtimeInterface = runtimeInterface;
        this.getContentPane().removeAll();
        this.selectPanel();
        this.initView();
        this.setResizable(false);
        this.pack();
    }

    private void selectPanel() {
        switch (this.monitorNode.getTyp()) {
            case 1: {
                this.mainPanel = new IntegerMonitorNodeEditor(this.mainFrame, (IIntegerMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 2: {
                this.mainPanel = new LongMonitorNodeEditor(this.mainFrame, (ILongMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 8: {
                this.mainPanel = new PoolMonitorNodeEditor(this.mainFrame, (IPoolMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 15: {
                this.mainPanel = new AvaliabilityMonitorNodeEditor(this.mainFrame, (IAvailabilityMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 6: {
                this.mainPanel = new StringMonitorNodeEditor(this.mainFrame, (IStringMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 7: {
                this.mainPanel = new TableMonitorNodeEditor(this.mainFrame, (ITableMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 9: {
                this.mainPanel = new StateMonitorNodeEditor(this.mainFrame, (IStateMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 11: {
                this.mainPanel = new CacheMonitorNodeEditor(this.mainFrame, (ICacheMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 12: {
                this.mainPanel = new CounterMonitorNodeEditor(this.mainFrame, (ICounterMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 13: {
                this.mainPanel = new FrequencyMonitorNodeEditor(this.mainFrame, (IFrequencyMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 14: {
                this.mainPanel = new QualityRateMonitorNodeEditor(this.mainFrame, (IQualityRateMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 10: {
                this.mainPanel = new VariableMonitorNodeEditor(this.mainFrame, (IVariableStateMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 16: {
                this.mainPanel = new PropertiesMonitorNodeEditor(this.mainFrame, (IPropertiesMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 17: {
                this.mainPanel = new DurationMonitorNodeEditor(this.mainFrame, (IDurationMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 18: {
                this.mainPanel = new ConfigurationMonitorNodeEditor(this.mainFrame, (IPropertiesMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
            case 19: {
                this.mainPanel = new VersionMonitorNodeEditor(this.mainFrame, (IPropertiesMonitorNode)this.monitorNode, this.mPanel);
                break;
            }
        }
        this.mainPanel.switchToEditMode(false);
    }

    private void initView() {
        ((Component)this).setLocation(200, 200);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 0, MonitorUtils.INSETS, 0, 0));
        this.pack();
    }
}

