/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.gui.ArrayComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class MonitorUtils {
    public static final String EMPTY_STRING = "";
    public static final String SPACE = " ";
    public static final String SLASH_LEFT = "/";
    public static final String DASH = "-";
    public static final String PLUS_MINUS = "\u00b1";
    public static final Border BORDER = BorderFactory.createLineBorder(Color.black);
    public static final Border ETCHED_BORDER = BorderFactory.createEtchedBorder();
    public static final Insets INSETS = new Insets(5, 5, 5, 5);
    public static final Insets INSETS_LARGE = new Insets(5, 20, 20, 20);
    public static final Insets INSETS_LARGE_TITLE = new Insets(20, 20, 5, 20);
    public static final String LABEL_BUTTON_OK = "OK";
    public static final String LABEL_BUTTON_CANCEL = "Cancel";
    public static final String LABEL_BUTTON_NEW = "New";
    public static final String LABEL_BUTTON_EDIT = "Edit";
    public static final String LABEL_BUTTON_DELETE = "Del";
    public static final String LABEL_BUTTON_SAVE = "Save";
    public static final String LABEL_BUTTON_RESTORE = "Restore";
    public static int MINUTE_IN_MILLIS = 60000;
    public static int MINUTES_IN_QUARTER = 15;
    public static int QUARTERS_IN_HOUR = 4;
    public static int MINUTES_IN_HOUR = 60;
    public static String UNIT_PERCENTAGE = "%";
    public static String UNIT_FREQUENCY = "1/s";
    public static DecimalFormat s_decimalFormat = new DecimalFormat("##0.00");
    public static Font TITLE_FONT = new Font("boldFont", 2, 14);
    public static Font LABEL_FONT = new Font("lableFont", 2, 12);
    public static Color TABLE_COLOR_NOT_EDITABLE = new Color(0xCBCBCB);

    public static final String getStringType(int intType, IMonitorNode node) {
        String type = null;
        switch (intType) {
            case 1: {
                type = "IntegerMonitor";
                break;
            }
            case 2: {
                type = "LongMonitor";
                break;
            }
            case 5: {
                type = "BooleanMonitor";
                break;
            }
            case 6: {
                type = "StringMonitor";
                break;
            }
            case 7: {
                type = "TableMonitor";
                break;
            }
            case 8: {
                type = "PoolMonitor";
                break;
            }
            case 9: {
                type = "StateMonitor";
                break;
            }
            case 11: {
                type = "CacheMonitor";
                break;
            }
            case 12: {
                type = "CounterMonitor";
                break;
            }
            case 13: {
                type = "FrequencyMonitor";
                break;
            }
            case 14: {
                type = "QualityRateMonitor";
                break;
            }
            case 15: {
                type = "AvailabilityMonitor";
                break;
            }
            case 10: {
                type = "VariableStateMonitor";
                break;
            }
            case 16: {
                type = "PropertyListMonitor";
                break;
            }
            case 17: {
                type = "DurationMonitor";
                break;
            }
            case 18: {
                type = "ConfigurationMonitor";
                break;
            }
            case 19: {
                type = "VersionMonitor";
                break;
            }
            default: {
                type = "not monitor!";
            }
        }
        return type;
    }

    public static int getIntType(String typeStr) {
        int typeInt = -1;
        if (typeStr.equals("IntegerMonitor")) {
            typeInt = 1;
        } else if (typeStr.equals("LongMonitor")) {
            typeInt = 2;
        } else if (typeStr.equals("BooleanMonitor")) {
            typeInt = 5;
        } else if (typeStr.equals("StringMonitor")) {
            typeInt = 6;
        } else if (typeStr.equals("TableMonitor")) {
            typeInt = 7;
        } else if (typeStr.equals("PoolMonitor")) {
            typeInt = 8;
        } else if (typeStr.equals("StateMonitor")) {
            typeInt = 9;
        } else if (typeStr.equals("CacheMonitor")) {
            typeInt = 11;
        } else if (typeStr.equals("CounterMonitor")) {
            typeInt = 12;
        } else if (typeStr.equals("FrequencyMonitor")) {
            typeInt = 13;
        } else if (typeStr.equals("QualityRateMonitor")) {
            typeInt = 14;
        } else if (typeStr.equals("AvailabilityMonitor")) {
            typeInt = 15;
        } else if (typeStr.equals("DurationMonitor")) {
            typeInt = 17;
        } else {
            System.out.println("Unknown type :" + typeInt);
        }
        return typeInt;
    }

    public static final String formatSerializable(Serializable value) {
        if (value == null) {
            return " - ";
        }
        if (value instanceof Double) {
            return MonitorUtils.formatDouble((Double)value);
        }
        return value.toString();
    }

    public static final String formatDouble(Double value) {
        return s_decimalFormat.format(value);
    }

    public static final String formatFloat(Float value) {
        return s_decimalFormat.format(value.doubleValue());
    }

    public static final String formatInteger(Integer value) {
        return value.toString();
    }

    public static final String formatLong(Long value) {
        return value.toString();
    }

    public static final String formatDate(Date value) {
        return value.toString();
    }

    public static final String formatDouble(double value) {
        return s_decimalFormat.format(value);
    }

    public static String[][] sortTwoDimArray(String[][] array) {
        TreeSet<String[]> set = new TreeSet<String[]>(new ArrayComparator());
        int p = 0;
        int rows = array.length;
        int columns = 0;
        if (rows > 0) {
            columns = array[0].length;
        }
        String[][] resultArray = new String[rows][columns];
        int i = 0;
        while (i < rows) {
            set.add(array[i]);
            ++i;
        }
        Iterator setIter = set.iterator();
        while (setIter.hasNext()) {
            String[] temp = (String[])setIter.next();
            resultArray[p] = temp;
            ++p;
        }
        return resultArray;
    }

    public static double round(double h) {
        double coef = 1.0;
        int sign = 1;
        if (h < 0.0) {
            sign = -1;
            h *= -1.0;
        }
        if (h > 1.0) {
            h *= 100.0;
            h = Math.round(h);
            h /= 100.0;
        } else if (h != 0.0) {
            while (h < 1.0) {
                h *= 100.0;
                coef *= 100.0;
            }
            h *= 100.0;
            h = Math.round(h);
            h /= coef * 100.0;
        }
        if (sign == -1) {
            h *= (double)sign;
        }
        return h;
    }
}

