/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.agent.client.CcmsAgentConfigurationPanel;
import com.sap.engine.services.monitor.gui.GrmgCustomizingPanel;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MonitorRuntimeView
extends JPanel
implements VisualRuntimeControl,
ChangeListener,
ActionListener {
    public static final String REFRESH_MONITOR_PANEL_COMMAND = "Refresh monitor panel";
    public static final String EXPAND_TREE_COMMAND = "Expand tree";
    public static final String COLLAPSE_TREE_COMMAND = "Collapse tree";
    public static final String RESTORE_TO_DEFAULT_COMMAND = "Restore groups to default";
    public static final int MONITOR_TAB_IDEX = 0;
    public static final int GRMG_TAB_IDEX = 1;
    MonitorRuntimeControlInterface mri = null;
    protected JTabbedPane mainTabPane = new JTabbedPane();
    protected BorderLayout borderLayout1 = new BorderLayout();
    IMonitorNode node = null;
    MonitorPanelLogical mPanel = null;
    GrmgCustomizingPanel grmgPanel = null;
    CcmsAgentConfigurationPanel agentPanel = null;
    JButton m_refreshButton = null;
    JButton m_exportButton = null;
    JButton m_customizeButton = null;
    JButton m_expandButton = null;
    JButton m_collapseButton = null;
    JButton m_restoreButton = null;
    Frame mainFrame;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$gui$MonitorRuntimeView;

    public MonitorRuntimeView() {
        Dimension dim = new Dimension(24, 24);
        this.m_refreshButton = new JButton();
        this.m_refreshButton.setPreferredSize(dim);
        this.m_refreshButton.setToolTipText("Refresh Tree");
        this.m_refreshButton.setIcon(MonitorRuntimeView.getIcon("refresh.gif"));
        this.m_refreshButton.setActionCommand(REFRESH_MONITOR_PANEL_COMMAND);
        this.m_refreshButton.addActionListener(this);
        this.m_expandButton = new JButton();
        this.m_expandButton.setPreferredSize(dim);
        this.m_expandButton.setToolTipText(EXPAND_TREE_COMMAND);
        this.m_expandButton.setIcon(MonitorRuntimeView.getIcon("expandtree.gif"));
        this.m_expandButton.setActionCommand(EXPAND_TREE_COMMAND);
        this.m_expandButton.addActionListener(this);
        this.m_collapseButton = new JButton();
        this.m_collapseButton.setPreferredSize(dim);
        this.m_collapseButton.setToolTipText("Collapse tree ");
        this.m_collapseButton.setIcon(MonitorRuntimeView.getIcon("colapstree.gif"));
        this.m_collapseButton.setActionCommand(COLLAPSE_TREE_COMMAND);
        this.m_collapseButton.addActionListener(this);
        this.m_restoreButton = new JButton();
        this.m_restoreButton.setPreferredSize(dim);
        this.m_restoreButton.setToolTipText(RESTORE_TO_DEFAULT_COMMAND);
        this.m_restoreButton.setIcon(MonitorRuntimeView.getIcon("restore_2.gif"));
        this.m_restoreButton.setActionCommand(RESTORE_TO_DEFAULT_COMMAND);
        this.m_restoreButton.addActionListener(this);
        this.init();
    }

    public void init() {
        this.mainTabPane.addChangeListener(this);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.mainTabPane, "Center");
    }

    public static ImageIcon getIcon(String imageFilename) {
        URL url = (class$com$sap$engine$services$monitor$gui$MonitorRuntimeView == null ? (class$com$sap$engine$services$monitor$gui$MonitorRuntimeView = MonitorRuntimeView.class$("com.sap.engine.services.monitor.gui.MonitorRuntimeView")) : class$com$sap$engine$services$monitor$gui$MonitorRuntimeView).getResource("images/" + imageFilename);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public void freeResources() {
        this.mri = null;
        this.mainTabPane = null;
        this.borderLayout1 = null;
        this.node = null;
        this.grmgPanel = null;
        this.agentPanel = null;
        this.m_refreshButton = null;
        this.m_exportButton = null;
        this.m_customizeButton = null;
        this.m_expandButton = null;
        this.m_collapseButton = null;
        this.m_restoreButton = null;
        this.mainFrame = null;
        this.mPanel.stopRefresh();
        this.mPanel = null;
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new UnsupportedEditorException("admin_0");
        }
    }

    public void show(ManagementInterface ri) {
        try {
            this.mri = (MonitorRuntimeControlInterface)ri;
            if (this.mri != null) {
                this.node = this.mri.getRootNode();
                this.initPanel(this.mri);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initPanel(MonitorRuntimeControlInterface mri) {
        this.mPanel = new MonitorPanelLogical(mri, this.mainFrame);
        this.mainTabPane.add("MonitorTree", this.mPanel);
        try {
            if (mri.isServer()) {
                this.grmgPanel = new GrmgCustomizingPanel(mri, this.mainFrame);
                this.mainTabPane.add("GRMG Customizing", this.grmgPanel);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!mri.isServer()) {
                this.agentPanel = new CcmsAgentConfigurationPanel(mri, this.mainFrame);
                this.mainTabPane.add("CCMS Agent Configuration", this.agentPanel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainTabPane.setSelectedIndex(0);
        this.mPanel.startRefresh();
        this.mainTabPane.updateUI();
        this.mPanel.initTree();
        this.mPanel.reloadTree();
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return new JButton[]{this.m_refreshButton, this.m_expandButton, this.m_collapseButton, this.m_restoreButton};
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        block3: {
            JButton[] runtimeButtons;
            int selectedIdex;
            block2: {
                selectedIdex = ((JTabbedPane)changeEvent.getSource()).getSelectedIndex();
                runtimeButtons = this.getRuntimeButtons();
                if (selectedIdex != 0) break block2;
                int i = 0;
                while (i < runtimeButtons.length) {
                    runtimeButtons[i].setVisible(true);
                    ++i;
                }
                break block3;
            }
            if (selectedIdex != 1) break block3;
            int i = 0;
            while (i < runtimeButtons.length) {
                runtimeButtons[i].setVisible(false);
                ++i;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        int currentPanelIndex = this.mainTabPane.getSelectedIndex();
        if (action.equals(REFRESH_MONITOR_PANEL_COMMAND)) {
            this.mPanel.refreshTreeAction();
        } else if (action.equals(EXPAND_TREE_COMMAND)) {
            switch (currentPanelIndex) {
                case 0: {
                    this.mPanel.expandTree();
                    break;
                }
            }
        } else if (action.equals(COLLAPSE_TREE_COMMAND)) {
            switch (currentPanelIndex) {
                case 0: {
                    this.mPanel.collapseTree();
                    break;
                }
            }
        } else if (action.equals(RESTORE_TO_DEFAULT_COMMAND)) {
            switch (currentPanelIndex) {
                case 0: {
                    this.mPanel.restoreGroupsToDefault();
                    break;
                }
            }
        }
    }

    public IMonitorNode getChangedMonitorNode(IMonitorNode monitorNode) throws RemoteException {
        return this.mri.getChangedMonitorNode(monitorNode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

