/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.library.monitor.IAvailabilityMonitorNode;
import com.sap.engine.library.monitor.IDurationMonitorNode;
import com.sap.engine.library.monitor.IFrequencyMonitorNode;
import com.sap.engine.library.monitor.IIntegerMonitorNode;
import com.sap.engine.library.monitor.ILongMonitorNode;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IPropertiesMonitorNode;
import com.sap.engine.library.monitor.IQualityRateMonitorNode;
import com.sap.engine.library.monitor.IStateMonitorNode;
import com.sap.engine.library.monitor.IStringMonitorNode;
import com.sap.engine.library.monitor.ITableMonitorNode;
import com.sap.engine.library.monitor.IVariableStateMonitorNode;
import com.sap.engine.library.monitor.gui.tree.MonitorTreeNode;
import com.sap.engine.library.monitor.impl0.SimpleMonitorNode;
import com.sap.engine.library.monitor.impl0.TableMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.gui.MonitorPanel;
import com.sap.engine.services.monitor.gui.TreeThread;
import com.sap.engine.services.monitor.gui.viewers.AvailabilityMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.BooleanMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.CacheMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.ConfigurationMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.CounterMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.DoubleMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.DurationMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.FloatMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.FrequencyMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.IntegerMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.LongMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.PoolMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.PropertiesMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.QualityRateMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.SimpleViewer;
import com.sap.engine.services.monitor.gui.viewers.StateMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.StringMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.TableMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.TableViewer;
import com.sap.engine.services.monitor.gui.viewers.VariableMonitorNodeViewer;
import com.sap.engine.services.monitor.gui.viewers.VersionMonitorNodeViewer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MonitorPanelLogical
extends MonitorPanel {
    protected JPanel descrPanel;
    PoolMonitorNodeViewer poolViewer = null;
    TableMonitorNodeViewer tableViewer = null;
    IntegerMonitorNodeViewer integerViewer = null;
    BooleanMonitorNodeViewer booleanViewer = null;
    CacheMonitorNodeViewer cacheViewer = null;
    CounterMonitorNodeViewer counterViewer = null;
    FrequencyMonitorNodeViewer frequencyViewer = null;
    QualityRateMonitorNodeViewer qualityRateViewer = null;
    DoubleMonitorNodeViewer doubleViewer = null;
    FloatMonitorNodeViewer floatViewer = null;
    LongMonitorNodeViewer longViewer = null;
    StateMonitorNodeViewer stateViewer = null;
    StringMonitorNodeViewer stringViewer = null;
    AvailabilityMonitorNodeViewer availabilityViewer = null;
    VariableMonitorNodeViewer variableViewer = null;
    PropertiesMonitorNodeViewer propertiesViewer = null;
    VersionMonitorNodeViewer versionViewer = null;
    ConfigurationMonitorNodeViewer configurationViewer = null;
    DurationMonitorNodeViewer durationViewer = null;
    SimpleViewer simpleViewer = null;
    MappingTreeNode m_root = null;
    MappedTree m_mappedTree = null;
    DefaultTreeModel treeModel;
    MonitorRuntimeControlInterface runtimeInterface;
    private JFileChooser fc = new JFileChooser();
    final Frame mainFrame;
    TreeThread refreshThread;

    public MonitorPanelLogical(MonitorRuntimeControlInterface mri, Frame frame) {
        this.mainFrame = frame;
        this.runtimeInterface = mri;
        this.refreshThread = new TreeThread(this);
        this.monitorTree.setShowsRootHandles(true);
        this.monitorTree.getSelectionModel().setSelectionMode(1);
        this.monitorTree.addMouseListener(new MouseAdapter(){
            public TreePath path;
            MappingTreeNode mappingNode;

            public void mousePressed(MouseEvent e) {
                this.path = MonitorPanelLogical.this.monitorTree.getPathForLocation(e.getX(), e.getY());
                if (this.path != null) {
                    this.mappingNode = (MappingTreeNode)this.path.getLastPathComponent();
                    MonitorPanelLogical.this.showNode(this.path);
                }
                if (this.mappingNode == null || this.mappingNode.node instanceof SimpleMonitorNode) {
                    return;
                }
                if ((e.getModifiers() & 4) == 0) {
                    return;
                }
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem itemGetValue = new JMenuItem("Update");
                JMenuItem itemTable = new JMenuItem("Show table in a frame");
                popupMenu.add(itemGetValue);
                if (this.mappingNode.node instanceof TableMonitorNode) {
                    popupMenu.add(itemTable);
                }
                popupMenu.show(MonitorPanelLogical.this.monitorTree, e.getX(), e.getY());
                if (this.mappingNode.node.getDataCollectionType() != 0) {
                    itemGetValue.setEnabled(false);
                } else {
                    itemGetValue.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void actionPerformed(ActionEvent e) {
                            MonitorPanelLogical.access$100(1.access$000(this.this$1), this.this$1.mappingNode, this.this$1.path);
                        }
                    });
                }
                itemTable.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        JDialog dialog = new JDialog(1.access$000(this.this$1).mainFrame, this.this$1.mappingNode.node.getName());
                        TableViewer table = new TableViewer((String[])((TableMonitorNode)this.this$1.mappingNode.node).getHeader());
                        Serializable[][] serArray = ((ITableMonitorNode)this.this$1.mappingNode.node).getEntries();
                        String[][] strArray = TableMonitorNodeViewer.arrayToString(serArray);
                        table.update(strArray, (String[])((TableMonitorNode)this.this$1.mappingNode.node).getHeader());
                        dialog.getContentPane().add(table);
                        dialog.pack();
                        ((Component)dialog).setVisible(true);
                        dialog.setDefaultCloseOperation(2);
                    }
                });
            }

            static /* synthetic */ MonitorPanelLogical access$000(1 x0) {
                return x0.MonitorPanelLogical.this;
            }
        });
    }

    public void initTree() {
        if (this.runtimeInterface != null) {
            try {
                this.m_mappedTree = this.runtimeInterface.getMapping("default");
                this.m_root = this.m_mappedTree.getRootNode();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                // empty catch block
            }
            this.treeModel = (DefaultTreeModel)this.monitorTree.getModel();
            this.treeModel.setRoot((TreeNode)this.m_root);
            this.treeModel.reload();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void refreshTreeAction() {
        Enumeration<TreePath> expandedNodes = this.monitorTree.getExpandedDescendants(this.monitorTree.getPathForRow(0));
        Vector<String> paths = new Vector<String>();
        TreePath treePath = null;
        String stringPath = "";
        while (expandedNodes.hasMoreElements()) {
            treePath = expandedNodes.nextElement();
            stringPath = this.determineSelectionPath(treePath);
            paths.add(stringPath);
        }
        this.monitorTree.setEnabled(false);
        String pathString = this.determineSelectionPath();
        this.initTree();
        this.printMonitorTreeInVM();
        int i = 0;
        while (i < paths.size()) {
            try {
                treePath = this.constructPathFromString((String)paths.elementAt(i));
                this.monitorTree.expandPath(treePath);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        try {
            treePath = this.constructPathFromString(pathString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (treePath != null) {
            this.monitorTree.setSelectionPath(treePath);
            this.showNode(treePath);
        }
        this.monitorTree.setEnabled(true);
    }

    public void exportTreeAction() {
        int returnVal = this.fc.showSaveDialog(this);
        this.fc.setDialogTitle("Export monitor tree to XML...");
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            try {
                this.exportToFile(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Exception occured", 0);
            }
        }
    }

    public void exportToFile(File file) throws IOException {
        IMonitorNode root = this.m_root.getMonitorObject();
        String xml = root.toXml();
        FileWriter outFile = new FileWriter(file);
        outFile.write(xml);
        outFile.close();
    }

    public void valueChanged(TreeSelectionEvent e) {
    }

    public void showNode(TreePath path) {
        DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.showSelectedNodeProperties(sellNode);
        if (this.descrPanel != null) {
            this.viewerPanel.removeAll();
            this.viewerPanel.add(this.descrPanel);
            this.viewerPanel.updateUI();
        }
    }

    protected void showSelectedNodeProperties(DefaultMutableTreeNode sellNode) {
        IMonitorNode i_monitorNode = null;
        MonitorTreeNode monitorNode = null;
        if (sellNode instanceof MonitorTreeNode) {
            monitorNode = (MonitorTreeNode)sellNode;
            i_monitorNode = monitorNode.getMonitorObject();
            int type = 0;
            if (i_monitorNode != null) {
                type = i_monitorNode.getTyp();
            }
            switch (type) {
                case 1: {
                    this.integerViewer = new IntegerMonitorNodeViewer(this.mainFrame, (IIntegerMonitorNode)i_monitorNode, this);
                    this.integerViewer.update(i_monitorNode);
                    this.descrPanel = this.integerViewer;
                    break;
                }
                case 2: {
                    this.longViewer = new LongMonitorNodeViewer(this.mainFrame, (ILongMonitorNode)i_monitorNode, this);
                    this.longViewer.update(i_monitorNode);
                    this.descrPanel = this.longViewer;
                    break;
                }
                case 15: {
                    this.availabilityViewer = new AvailabilityMonitorNodeViewer(this.mainFrame, (IAvailabilityMonitorNode)i_monitorNode, this);
                    this.availabilityViewer.update(i_monitorNode);
                    this.descrPanel = this.availabilityViewer;
                    break;
                }
                case 6: {
                    this.stringViewer = new StringMonitorNodeViewer(this.mainFrame, (IStringMonitorNode)i_monitorNode, this);
                    this.stringViewer.update(i_monitorNode);
                    this.descrPanel = this.stringViewer;
                    break;
                }
                case 7: {
                    if (this.tableViewer == null) {
                        this.tableViewer = new TableMonitorNodeViewer(this.mainFrame, (ITableMonitorNode)i_monitorNode, this);
                        this.tableViewer.update(i_monitorNode);
                    } else if (i_monitorNode.getPath().equals(this.tableViewer.monitorNode.getPath()) && this.areEqualGroupProps(i_monitorNode, this.tableViewer.monitorNode)) {
                        this.tableViewer.updateViewer();
                    } else {
                        this.tableViewer.update(i_monitorNode);
                    }
                    this.descrPanel = this.tableViewer;
                    break;
                }
                case 9: {
                    this.stateViewer = new StateMonitorNodeViewer(this.mainFrame, (IStateMonitorNode)i_monitorNode, this);
                    this.stateViewer.update(i_monitorNode);
                    this.descrPanel = this.stateViewer;
                    break;
                }
                case 13: {
                    this.frequencyViewer = new FrequencyMonitorNodeViewer(this.mainFrame, (IFrequencyMonitorNode)i_monitorNode, this);
                    this.frequencyViewer.update(i_monitorNode);
                    this.descrPanel = this.frequencyViewer;
                    break;
                }
                case 14: {
                    this.qualityRateViewer = new QualityRateMonitorNodeViewer(this.mainFrame, (IQualityRateMonitorNode)i_monitorNode, this);
                    this.qualityRateViewer.update(i_monitorNode);
                    this.descrPanel = this.qualityRateViewer;
                    break;
                }
                case 10: {
                    this.variableViewer = new VariableMonitorNodeViewer(this.mainFrame, (IVariableStateMonitorNode)i_monitorNode, this);
                    this.variableViewer.update(i_monitorNode);
                    this.descrPanel = this.variableViewer;
                    break;
                }
                case 17: {
                    this.durationViewer = new DurationMonitorNodeViewer(this.mainFrame, (IDurationMonitorNode)i_monitorNode, this);
                    this.durationViewer.update(i_monitorNode);
                    this.descrPanel = this.durationViewer;
                    break;
                }
                case 19: {
                    this.versionViewer = new VersionMonitorNodeViewer(this.mainFrame, (IPropertiesMonitorNode)i_monitorNode, this);
                    this.versionViewer.update(i_monitorNode);
                    this.descrPanel = this.versionViewer;
                    break;
                }
                case 18: {
                    this.configurationViewer = new ConfigurationMonitorNodeViewer(this.mainFrame, (IPropertiesMonitorNode)i_monitorNode, this);
                    this.configurationViewer.update(i_monitorNode);
                    this.descrPanel = this.configurationViewer;
                    break;
                }
                default: {
                    this.simpleViewer = new SimpleViewer(i_monitorNode);
                    this.simpleViewer.update(i_monitorNode);
                    this.descrPanel = this.simpleViewer;
                }
            }
        }
    }

    public void reloadTree() {
        ((DefaultTreeModel)this.monitorTree.getModel()).reload();
    }

    public MonitorTreeNode getDefaultRoot() {
        return this.m_root;
    }

    private String determineSelectionPath() {
        String pathString = "/";
        try {
            TreePath path = this.monitorTree.getSelectionPath();
            Object[] temp = path.getPath();
            if (temp.length > 0) {
                pathString = ((MappingTreeNode)temp[temp.length - 1]).getMappingPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pathString;
    }

    private String determineSelectionPath(TreePath path) {
        String pathString = "/";
        try {
            Object[] temp = path.getPath();
            if (temp.length > 0) {
                pathString = ((MappingTreeNode)temp[temp.length - 1]).getMappingPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pathString;
    }

    private void printMonitorTreeInVM() {
    }

    public MonitorTreeNode getRoot() {
        return this.m_root;
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.monitorTree.getModel();
    }

    public MappedTree getMapping() {
        return this.m_mappedTree;
    }

    public JTree getMonitorTree() {
        return this.monitorTree;
    }

    public void restoreDefault() {
        try {
            this.m_mappedTree = this.runtimeInterface.getMapping("default");
            this.m_root = this.m_mappedTree.getRootNode();
            this.treeModel = (DefaultTreeModel)this.monitorTree.getModel();
            this.treeModel.setRoot((TreeNode)this.m_root);
            this.treeModel.reload();
        }
        catch (RemoteException rm) {
            rm.printStackTrace();
        }
    }

    public DefaultTreeModel getDefaultTreeModel() {
        DefaultTreeModel newModel = null;
        try {
            this.m_mappedTree = this.runtimeInterface.getMapping("default");
            this.m_root = this.m_mappedTree.getRootNode();
            newModel = (DefaultTreeModel)this.monitorTree.getModel();
            newModel.setRoot((TreeNode)this.m_root);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return newModel;
    }

    public void startRefresh() {
        TreeThread.running = true;
        this.refreshThread.start();
    }

    public void stopRefresh() {
        TreeThread.running = false;
        this.refreshThread.interrupt();
    }

    public boolean areEqual(String[] arr1, String[] arr2) {
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (!arr1[i].equals(arr2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void reloadNode() {
        TreePath path = this.monitorTree.getSelectionPath();
        MappingTreeNode mappingNode = (MappingTreeNode)path.getLastPathComponent();
        this.reloadUpdatedMonitorNode(mappingNode, path);
    }

    private void reloadUpdatedMonitorNode(MappingTreeNode mappingNode, TreePath path) {
        IMonitorNode nodeNew = null;
        try {
            nodeNew = this.runtimeInterface.getChangedMonitorNode(mappingNode.node);
            mappingNode.setMonitorObject(nodeNew);
            this.treeModel.nodeStructureChanged((TreeNode)mappingNode);
            this.treeModel.reload((TreeNode)mappingNode);
            String stringPath = this.determineSelectionPath(path);
            TreePath treePath = this.constructPathFromString(stringPath);
            if (treePath != null) {
                this.monitorTree.setSelectionPath(treePath);
                this.showNode(treePath);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MonitorRuntimeControlInterface getRuntimeInterface() {
        return this.runtimeInterface;
    }

    public boolean areEqualGroupProps(IMonitorNode node1, IMonitorNode node2) {
        return node1.getPeriodUnit() == node2.getPeriodUnit() && node1.getPeriodValue() == node2.getPeriodValue() && node1.getDescription().equals(node2.getDescription()) && node1.getReactOnCollectionFailure() == node2.getReactOnCollectionFailure();
    }

    public void restoreGroupsToDefault() {
        int userChoice = JOptionPane.showConfirmDialog(this, "You are about to restore properties of all groups to default.\n This will delete current properties for the groups from the data base", "Restore to default action", 2);
        if (userChoice == 0) {
            boolean result = false;
            try {
                result = this.runtimeInterface.restoreAllGroupsToDefault();
                this.refreshTreeAction();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showMessage();
            }
            if (!result) {
                this.showMessage();
            }
        }
    }

    private void showMessage() {
        JOptionPane.showMessageDialog(this, "Cannot restore default groups", "Restore error", 0);
    }

    static /* synthetic */ void access$100(MonitorPanelLogical x0, MappingTreeNode x1, TreePath x2) {
        x0.reloadUpdatedMonitorNode(x1, x2);
    }
}

