/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.gui.tree.MonitorTreeNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.gui.MonitorEditablePanel;
import com.sap.engine.services.monitor.gui.editors.MonitorNodeEditor;
import com.sap.engine.services.monitor.gui.viewers.MappingNodeViewer;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MonitorEditablePanelLogical
extends MonitorEditablePanel {
    MonitorRuntimeControlInterface m_runtimeInterface;
    protected JPanel descrPanel;
    protected MappingNodeViewer m_mappingNodeViewer = null;
    private Frame mainFrame;
    private MonitorNodeEditor currentEditor;
    MappedTree m_mappedTree = null;
    MappingTreeNode root;
    public DefaultTreeModel treeModel;
    MappedTree mapping;

    public MonitorEditablePanelLogical(MonitorRuntimeControlInterface mri, Frame mainFrame) {
        this.mainFrame = mainFrame;
        try {
            this.m_runtimeInterface = mri;
            this.mapping = this.m_runtimeInterface.getMapping("default");
            this.root = this.mapping.getRootNode();
            this.treeModel = (DefaultTreeModel)this.monitorTree.getModel();
            this.treeModel.setRoot((TreeNode)this.root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.treeModel.reload();
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        this.showNode(path);
    }

    protected void showNode(TreePath path) {
        DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.showSelectedNodeProperties(sellNode);
        if (this.descrPanel != null) {
            this.viewerPanel.removeAll();
            this.viewerPanel.add(this.descrPanel);
            this.viewerPanel.updateUI();
        }
    }

    protected void showSelectedNodeProperties(DefaultMutableTreeNode sellNode) {
        IMonitorNode i_monitorNode = null;
        MonitorTreeNode monitorNode = null;
        if (sellNode instanceof MonitorTreeNode) {
            monitorNode = (MonitorTreeNode)sellNode;
            Properties properties = new Properties();
            if (monitorNode instanceof MappingTreeNode) {
                properties = ((MappingTreeNode)monitorNode).getProperties();
            }
            i_monitorNode = monitorNode.getMonitorObject();
            int type = 0;
            if (i_monitorNode != null) {
                type = i_monitorNode.getTyp();
            }
            this.chooseMonitorPanel(type, i_monitorNode, properties);
        }
    }

    private void chooseMonitorPanel(int type, IMonitorNode i_monitorNode, Properties properties) {
    }

    public void restoreDefault() {
        try {
            this.mapping = this.m_runtimeInterface.getMapping("default");
            this.root = this.mapping.getRootNode();
            this.treeModel = (DefaultTreeModel)this.monitorTree.getModel();
            this.treeModel.setRoot((TreeNode)this.root);
            this.treeModel.reload();
        }
        catch (RemoteException rm) {
            rm.printStackTrace();
        }
    }

    public MonitorTreeNode getRoot() {
        return this.root;
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.monitorTree.getModel();
    }

    public MappedTree getMapping() {
        return this.mapping;
    }

    public JTree getMonitorTree() {
        return this.monitorTree;
    }

    public DefaultTreeModel getDefaultTreeModel() {
        DefaultTreeModel newModel = null;
        try {
            this.mapping = this.m_runtimeInterface.getMapping("default");
            this.root = this.mapping.getRootNode();
            newModel = (DefaultTreeModel)this.monitorTree.getModel();
            newModel.setRoot((TreeNode)this.root);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return newModel;
    }
}

