/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.library.monitor.gui.tree.MonitorTreeNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.gui.LayoutPanel;
import com.sap.engine.services.monitor.gui.viewers.MappingNodeViewer;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LayoutPanelLogical
extends LayoutPanel {
    MonitorRuntimeControlInterface m_runtimeInterface;
    protected JPanel descrPanel;
    protected MappingNodeViewer m_mappingNodeViewer = null;
    MappedTree mapping;
    MappingTreeNode root;
    DefaultTreeModel treeModel;

    public LayoutPanelLogical(MonitorRuntimeControlInterface mri) {
        try {
            this.m_runtimeInterface = mri;
            this.initLayoutSelectionBox();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("LAYOUT")) {
            this.layoutAction();
        } else if (cmd.equals("ADD_CMD")) {
            this.addAction();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeAction();
        }
    }

    public void layoutAction() {
        String layoutName = (String)this.mappingSelectionBox.getSelectedItem();
        if (this.mappingSelectionBox.getSelectedItem().equals("")) {
            this.treeModel = (DefaultTreeModel)this.monitorTree.getModel();
            this.treeModel.setRoot(new DefaultMutableTreeNode());
        } else {
            try {
                this.mapping = this.m_runtimeInterface.getMapping(layoutName);
                this.root = this.mapping.getRootNode();
                this.treeModel = (DefaultTreeModel)this.monitorTree.getModel();
                this.treeModel.setRoot((TreeNode)this.root);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.treeModel.reload();
    }

    public void addAction() {
    }

    public void removeAction() {
    }

    protected void initLayoutSelectionBox() throws Exception {
        String[] mappingNames = this.m_runtimeInterface.getMappings();
        int i = 0;
        while (i < mappingNames.length) {
            this.mappingSelectionBox.addItem(mappingNames[i]);
            ++i;
        }
        if (mappingNames.length > 0) {
            this.mappingSelectionBox.addActionListener(this);
        }
        this.mappingSelectionBox.setActionCommand("LAYOUT");
        if (mappingNames.length > 0) {
            this.mappingSelectionBox.setSelectedIndex(0);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        this.showNode(path);
    }

    protected void showNode(TreePath path) {
        DefaultMutableTreeNode sellNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.showSelectedNodeProperties(sellNode);
        if (this.descrPanel != null) {
            this.viewerPanel.removeAll();
            this.viewerPanel.add(this.descrPanel);
            this.viewerPanel.updateUI();
        }
    }

    protected void showSelectedNodeProperties(DefaultMutableTreeNode selectedNode) {
        MappingTreeNode mappingNode = null;
        if (selectedNode instanceof MappingTreeNode) {
            mappingNode = (MappingTreeNode)selectedNode;
            if (this.m_mappingNodeViewer == null) {
                this.m_mappingNodeViewer = new MappingNodeViewer();
            }
            this.m_mappingNodeViewer.update(mappingNode);
            this.descrPanel = this.m_mappingNodeViewer;
        } else {
            this.descrPanel = null;
            this.viewerPanel.removeAll();
            this.viewerPanel.updateUI();
        }
    }

    public void restoreDefault() {
        try {
            this.mapping = this.m_runtimeInterface.getMapping((String)this.mappingSelectionBox.getSelectedItem());
            this.root = this.mapping.getRootNode();
            this.treeModel = (DefaultTreeModel)this.monitorTree.getModel();
            this.treeModel.setRoot((TreeNode)this.root);
            this.treeModel.reload();
        }
        catch (RemoteException rm) {
            rm.printStackTrace();
        }
    }

    public MonitorTreeNode getRoot() {
        return this.root;
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.monitorTree.getModel();
    }

    public MappedTree getMapping() {
        return this.mapping;
    }

    public JTree getMonitorTree() {
        return this.monitorTree;
    }

    public DefaultTreeModel getDefaultTreeModel() {
        DefaultTreeModel newModel = null;
        try {
            this.mapping = this.m_runtimeInterface.getMapping((String)this.mappingSelectionBox.getSelectedItem());
            this.root = this.mapping.getRootNode();
            newModel = (DefaultTreeModel)this.monitorTree.getModel();
            newModel.setRoot((TreeNode)this.root);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return newModel;
    }
}

